/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.topic;

import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 (2\u00020\u0001:\u0001(B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J&\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/Ticket;", "", "topic", "Lorg/apache/tuweni/bytes/Bytes;", "srcNodeId", "srcIp", "", "requestTime", "", "waitTime", "cumTime", "(Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/String;JJJ)V", "getCumTime", "()J", "getRequestTime", "getSrcIp", "()Ljava/lang/String;", "getSrcNodeId", "()Lorg/apache/tuweni/bytes/Bytes;", "getTopic", "getWaitTime", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "encode", "encrypt", "key", "equals", "", "other", "hashCode", "", "toString", "validate", "", "now", "Companion", "devp2p"})
public final class Ticket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bytes topic;
    @NotNull
    private final Bytes srcNodeId;
    @NotNull
    private final String srcIp;
    private final long requestTime;
    private final long waitTime;
    private final long cumTime;
    private static final int ZERO_NONCE_SIZE = 12;
    public static final int TIME_WINDOW_MS = 10000;
    @NotNull
    public static final String TICKET_INVALID_MSG = "Ticket is invalid";

    public Ticket(@NotNull Bytes topic, @NotNull Bytes srcNodeId, @NotNull String srcIp, long requestTime, long waitTime, long cumTime) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)srcIp, (String)"srcIp");
        this.topic = topic;
        this.srcNodeId = srcNodeId;
        this.srcIp = srcIp;
        this.requestTime = requestTime;
        this.waitTime = waitTime;
        this.cumTime = cumTime;
    }

    @NotNull
    public final Bytes getTopic() {
        return this.topic;
    }

    @NotNull
    public final Bytes getSrcNodeId() {
        return this.srcNodeId;
    }

    @NotNull
    public final String getSrcIp() {
        return this.srcIp;
    }

    public final long getRequestTime() {
        return this.requestTime;
    }

    public final long getWaitTime() {
        return this.waitTime;
    }

    public final long getCumTime() {
        return this.cumTime;
    }

    @NotNull
    public final Bytes encode() {
        Bytes bytes = RLP.encodeList(arg_0 -> Ticket.encode$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"encodeList { writer ->\n \u2026.writeLong(cumTime)\n    }");
        return bytes;
    }

    @NotNull
    public final Bytes encrypt(@NotNull Bytes key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Bytes ticketBytes = this.encode();
        Bytes bytes = Bytes.wrap((byte[])new byte[12]);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(ByteArray(ZERO_NONCE_SIZE))");
        Bytes bytes2 = bytes;
        bytes = Bytes.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"EMPTY");
        return AES128GCM.INSTANCE.encrypt(key, bytes2, ticketBytes, bytes);
    }

    public final void validate(@NotNull Bytes srcNodeId, @NotNull String srcIp, long now, @NotNull Bytes topic) {
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)srcIp, (String)"srcIp");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        if (!Intrinsics.areEqual((Object)this.srcNodeId, (Object)srcNodeId)) {
            boolean $i$a$-require-Ticket$validate$52 = false;
            String $i$a$-require-Ticket$validate$52 = TICKET_INVALID_MSG;
            throw new IllegalArgumentException($i$a$-require-Ticket$validate$52.toString());
        }
        if (!Intrinsics.areEqual((Object)this.srcIp, (Object)srcIp)) {
            boolean $i$a$-require-Ticket$validate$62 = false;
            String $i$a$-require-Ticket$validate$62 = TICKET_INVALID_MSG;
            throw new IllegalArgumentException($i$a$-require-Ticket$validate$62.toString());
        }
        if (!Intrinsics.areEqual((Object)this.topic, (Object)topic)) {
            boolean bl = false;
            String string = TICKET_INVALID_MSG;
            throw new IllegalArgumentException(string.toString());
        }
        long windowStart = this.requestTime + this.waitTime;
        if (!(now >= windowStart && now <= windowStart + (long)10000)) {
            boolean bl = false;
            String string = TICKET_INVALID_MSG;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Bytes component1() {
        return this.topic;
    }

    @NotNull
    public final Bytes component2() {
        return this.srcNodeId;
    }

    @NotNull
    public final String component3() {
        return this.srcIp;
    }

    public final long component4() {
        return this.requestTime;
    }

    public final long component5() {
        return this.waitTime;
    }

    public final long component6() {
        return this.cumTime;
    }

    @NotNull
    public final Ticket copy(@NotNull Bytes topic, @NotNull Bytes srcNodeId, @NotNull String srcIp, long requestTime, long waitTime, long cumTime) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)srcIp, (String)"srcIp");
        return new Ticket(topic, srcNodeId, srcIp, requestTime, waitTime, cumTime);
    }

    public static /* synthetic */ Ticket copy$default(Ticket ticket, Bytes bytes, Bytes bytes2, String string, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            bytes = ticket.topic;
        }
        if ((n & 2) != 0) {
            bytes2 = ticket.srcNodeId;
        }
        if ((n & 4) != 0) {
            string = ticket.srcIp;
        }
        if ((n & 8) != 0) {
            l = ticket.requestTime;
        }
        if ((n & 0x10) != 0) {
            l2 = ticket.waitTime;
        }
        if ((n & 0x20) != 0) {
            l3 = ticket.cumTime;
        }
        return ticket.copy(bytes, bytes2, string, l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "Ticket(topic=" + this.topic + ", srcNodeId=" + this.srcNodeId + ", srcIp=" + this.srcIp + ", requestTime=" + this.requestTime + ", waitTime=" + this.waitTime + ", cumTime=" + this.cumTime + ")";
    }

    public int hashCode() {
        int result2 = this.topic.hashCode();
        result2 = result2 * 31 + this.srcNodeId.hashCode();
        result2 = result2 * 31 + this.srcIp.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.requestTime);
        result2 = result2 * 31 + Long.hashCode(this.waitTime);
        result2 = result2 * 31 + Long.hashCode(this.cumTime);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ticket)) {
            return false;
        }
        Ticket ticket = (Ticket)other;
        if (!Intrinsics.areEqual((Object)this.topic, (Object)ticket.topic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.srcNodeId, (Object)ticket.srcNodeId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.srcIp, (Object)ticket.srcIp)) {
            return false;
        }
        if (this.requestTime != ticket.requestTime) {
            return false;
        }
        if (this.waitTime != ticket.waitTime) {
            return false;
        }
        return this.cumTime == ticket.cumTime;
    }

    private static final void encode$lambda-0(Ticket this$0, RLPWriter writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        writer.writeValue(this$0.topic);
        writer.writeValue(this$0.srcNodeId);
        writer.writeValue(Bytes.wrap((byte[])InetAddress.getByName(this$0.srcIp).getAddress()));
        writer.writeLong(this$0.requestTime);
        writer.writeLong(this$0.waitTime);
        writer.writeLong(this$0.cumTime);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/Ticket$Companion;", "", "()V", "TICKET_INVALID_MSG", "", "TIME_WINDOW_MS", "", "ZERO_NONCE_SIZE", "create", "Lorg/apache/tuweni/devp2p/v5/topic/Ticket;", "content", "Lorg/apache/tuweni/bytes/Bytes;", "decrypt", "encrypted", "key", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Ticket create(@NotNull Bytes content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Object object = RLP.decodeList((Bytes)content, Companion::create$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeList(content) { re\u2026aitTime, cumTime)\n      }");
            return (Ticket)object;
        }

        @NotNull
        public final Ticket decrypt(@NotNull Bytes encrypted, @NotNull Bytes key) {
            Intrinsics.checkNotNullParameter((Object)encrypted, (String)"encrypted");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Bytes bytes = Bytes.wrap((byte[])new byte[12]);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(ByteArray(ZERO_NONCE_SIZE))");
            Bytes bytes2 = bytes;
            bytes = Bytes.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"EMPTY");
            Bytes decrypted = AES128GCM.INSTANCE.decrypt(key, bytes2, encrypted, bytes);
            return this.create(decrypted);
        }

        private static final Ticket create$lambda-0(RLPReader reader) {
            Bytes topic = reader.readValue();
            Bytes srcNodeId = reader.readValue();
            InetAddress srcIp = InetAddress.getByAddress(reader.readValue().toArray());
            long requestTime = reader.readLong();
            long waitTime = reader.readLong();
            long cumTime = reader.readLong();
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"topic");
            Intrinsics.checkNotNullExpressionValue((Object)srcNodeId, (String)"srcNodeId");
            String string = srcIp.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcIp.hostAddress");
            return new Ticket(topic, srcNodeId, string, requestTime, waitTime, cumTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

