/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.encrypt;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKey;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKeyGenerator;", "", "()V", "DERIVED_KEY_SIZE", "", "INFO_PREFIX", "Lorg/apache/tuweni/bytes/Bytes;", "kotlin.jvm.PlatformType", "generate", "Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKey;", "srcNodeId", "destNodeId", "secret", "idNonce", "devp2p"})
public final class SessionKeyGenerator {
    @NotNull
    public static final SessionKeyGenerator INSTANCE = new SessionKeyGenerator();
    private static final int DERIVED_KEY_SIZE = 16;
    private static final Bytes INFO_PREFIX;

    private SessionKeyGenerator() {
    }

    @NotNull
    public final SessionKey generate(@NotNull Bytes srcNodeId, @NotNull Bytes destNodeId, @NotNull Bytes secret, @NotNull Bytes idNonce) {
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)destNodeId, (String)"destNodeId");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)idNonce, (String)"idNonce");
        Bytes[] bytesArray = new Bytes[]{INFO_PREFIX, srcNodeId, destNodeId};
        Bytes info = Bytes.concatenate((Bytes[])bytesArray);
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        HKDFParameters params = new HKDFParameters(secret.toArrayUnsafe(), idNonce.toArrayUnsafe(), info.toArrayUnsafe());
        hkdf.init((DerivationParameters)params);
        Bytes output = Bytes.wrap((byte[])new byte[48]);
        hkdf.generateBytes(output.toArrayUnsafe(), 0, output.size());
        Bytes bytes = output.slice(0, 16);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"output.slice(0, DERIVED_KEY_SIZE)");
        Bytes bytes2 = bytes;
        bytes = output.slice(16, 16);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"output.slice(DERIVED_KEY_SIZE, DERIVED_KEY_SIZE)");
        Bytes bytes3 = bytes;
        bytes = output.slice(32);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"output.slice(DERIVED_KEY_SIZE * 2)");
        return new SessionKey(bytes2, bytes3, bytes);
    }

    static {
        String string = "discovery v5 key agreement";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        INFO_PREFIX = Bytes.wrap((byte[])byArray);
    }
}

