/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import io.vertx.core.net.SocketAddress;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.ExpiringMap;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DiscoveryService;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.FindNodeMessage;
import org.apache.tuweni.devp2p.v5.Message;
import org.apache.tuweni.devp2p.v5.MessageType;
import org.apache.tuweni.devp2p.v5.NodesMessage;
import org.apache.tuweni.devp2p.v5.PingMessage;
import org.apache.tuweni.devp2p.v5.PongMessage;
import org.apache.tuweni.devp2p.v5.RegConfirmationMessage;
import org.apache.tuweni.devp2p.v5.RegTopicMessage;
import org.apache.tuweni.devp2p.v5.RoutingTable;
import org.apache.tuweni.devp2p.v5.Session;
import org.apache.tuweni.devp2p.v5.TicketMessage;
import org.apache.tuweni.devp2p.v5.TopicQueryMessage;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKey;
import org.apache.tuweni.devp2p.v5.topic.Ticket;
import org.apache.tuweni.devp2p.v5.topic.Topic;
import org.apache.tuweni.devp2p.v5.topic.TopicTable;
import org.apache.tuweni.rlp.InvalidRLPTypeException;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 m2\u00020\u0001:\u0001mB\u0098\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000fJ)\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u000202H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0019\u0010=\u001a\u00020\u00102\u0006\u00107\u001a\u00020>H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010@\u001a\u00020\u00102\u0006\u00107\u001a\u00020AH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ\u0019\u0010C\u001a\u00020\u00102\u0006\u00107\u001a\u00020DH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010EJ\u0019\u0010F\u001a\u00020\u00102\u0006\u00107\u001a\u00020GH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010HJ\u0019\u0010I\u001a\u00020\u00102\u0006\u00107\u001a\u00020JH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ\u0019\u0010L\u001a\u00020\u00102\u0006\u00107\u001a\u00020MH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u0019\u0010O\u001a\u00020\u00102\u0006\u00107\u001a\u00020PH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ\u0019\u0010R\u001a\u00020\u00102\u0006\u00107\u001a\u00020SH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020\u0010H\u0002J\u0019\u0010V\u001a\u00020\u00102\u0006\u0010W\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010XJ%\u0010Y\u001a\u0002062\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020\\H\u0000\u00a2\u0006\u0002\b]J#\u0010^\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u000f2\b\b\u0002\u0010_\u001a\u00020\u001dH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010`J\u0019\u0010a\u001a\u00020\u00102\u0006\u00107\u001a\u000206H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ%\u0010c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$0d2\u0006\u0010e\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010fJ\u0011\u0010g\u001a\u00020hH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ+\u0010j\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010k\u001a\u00020\u000f2\b\b\u0002\u00109\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lRE\u0010!\u001a6\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$0#0\"j\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030$0#`%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R)\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00104\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\"j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006n"}, d2={"Lorg/apache/tuweni/devp2p/v5/Session;", "Lkotlinx/coroutines/CoroutineScope;", "enr", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "tag", "sessionKey", "Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKey;", "address", "Lio/vertx/core/net/SocketAddress;", "sendFn", "Lkotlin/Function2;", "Lorg/apache/tuweni/bytes/Bytes;", "", "ourENR", "Lkotlin/Function0;", "routingTable", "Lorg/apache/tuweni/devp2p/v5/RoutingTable;", "topicTable", "Lorg/apache/tuweni/devp2p/v5/topic/TopicTable;", "failedPingsListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "missedPings", "", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKey;Lio/vertx/core/net/SocketAddress;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lorg/apache/tuweni/devp2p/v5/RoutingTable;Lorg/apache/tuweni/devp2p/v5/topic/TopicTable;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/CoroutineContext;)V", "activeFindNodes", "Ljava/util/HashMap;", "Lorg/apache/tuweni/concurrent/CompletableAsyncResult;", "", "Lkotlin/collections/HashMap;", "getActiveFindNodes", "()Ljava/util/HashMap;", "activePing", "Lorg/apache/tuweni/concurrent/CompletableAsyncCompletion;", "chunkedNodeResults", "Lorg/apache/tuweni/concurrent/ExpiringMap;", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getEnr", "()Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "now", "", "peerSeq", "ticketHolder", "decode", "Lorg/apache/tuweni/devp2p/v5/Message;", "message", "delayRegTopic", "requestId", "topic", "waitTime", "(Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleFindNode", "Lorg/apache/tuweni/devp2p/v5/FindNodeMessage;", "(Lorg/apache/tuweni/devp2p/v5/FindNodeMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleNodes", "Lorg/apache/tuweni/devp2p/v5/NodesMessage;", "(Lorg/apache/tuweni/devp2p/v5/NodesMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handlePing", "Lorg/apache/tuweni/devp2p/v5/PingMessage;", "(Lorg/apache/tuweni/devp2p/v5/PingMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handlePong", "Lorg/apache/tuweni/devp2p/v5/PongMessage;", "(Lorg/apache/tuweni/devp2p/v5/PongMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRegConfirmation", "Lorg/apache/tuweni/devp2p/v5/RegConfirmationMessage;", "(Lorg/apache/tuweni/devp2p/v5/RegConfirmationMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRegTopic", "Lorg/apache/tuweni/devp2p/v5/RegTopicMessage;", "(Lorg/apache/tuweni/devp2p/v5/RegTopicMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleTicket", "Lorg/apache/tuweni/devp2p/v5/TicketMessage;", "(Lorg/apache/tuweni/devp2p/v5/TicketMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleTopicQuery", "Lorg/apache/tuweni/devp2p/v5/TopicQueryMessage;", "(Lorg/apache/tuweni/devp2p/v5/TopicQueryMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchPing", "processMessage", "messageBytes", "(Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "contentWithHeader", "reader", "Lorg/apache/tuweni/rlp/RLPReader;", "read$devp2p", "registerTopic", "withDelay", "(Lorg/apache/tuweni/bytes/Bytes;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "(Lorg/apache/tuweni/devp2p/v5/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendFindNodes", "Lorg/apache/tuweni/concurrent/AsyncResult;", "distance", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendPing", "Lorg/apache/tuweni/concurrent/AsyncCompletion;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRegTopic", "ticket", "(Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "devp2p"})
public final class Session
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EthereumNodeRecord enr;
    @NotNull
    private final SECP256K1.KeyPair keyPair;
    @NotNull
    private final Bytes32 nodeId;
    @NotNull
    private final Bytes32 tag;
    @NotNull
    private final SessionKey sessionKey;
    @NotNull
    private final SocketAddress address;
    @NotNull
    private final Function2<SocketAddress, Bytes, Unit> sendFn;
    @NotNull
    private final Function0<EthereumNodeRecord> ourENR;
    @NotNull
    private final RoutingTable routingTable;
    @NotNull
    private final TopicTable topicTable;
    @NotNull
    private final Function1<Integer, Boolean> failedPingsListener;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final HashMap<Bytes, CompletableAsyncResult<List<EthereumNodeRecord>>> activeFindNodes;
    @Nullable
    private CompletableAsyncCompletion activePing;
    @NotNull
    private final ExpiringMap<Bytes, List<EthereumNodeRecord>> chunkedNodeResults;
    private int missedPings;
    @NotNull
    private final HashMap<Bytes, Bytes> ticketHolder;
    private long peerSeq;
    @NotNull
    private final Function0<Long> now;
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    public static final long PING_REFRESH = 10000L;

    public Session(@NotNull EthereumNodeRecord enr, @NotNull SECP256K1.KeyPair keyPair, @NotNull Bytes32 nodeId, @NotNull Bytes32 tag, @NotNull SessionKey sessionKey, @NotNull SocketAddress address, @NotNull Function2<? super SocketAddress, ? super Bytes, Unit> sendFn, @NotNull Function0<EthereumNodeRecord> ourENR, @NotNull RoutingTable routingTable, @NotNull TopicTable topicTable, @NotNull Function1<? super Integer, Boolean> failedPingsListener, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)enr, (String)"enr");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(sendFn, (String)"sendFn");
        Intrinsics.checkNotNullParameter(ourENR, (String)"ourENR");
        Intrinsics.checkNotNullParameter((Object)routingTable, (String)"routingTable");
        Intrinsics.checkNotNullParameter((Object)topicTable, (String)"topicTable");
        Intrinsics.checkNotNullParameter(failedPingsListener, (String)"failedPingsListener");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.enr = enr;
        this.keyPair = keyPair;
        this.nodeId = nodeId;
        this.tag = tag;
        this.sessionKey = sessionKey;
        this.address = address;
        this.sendFn = sendFn;
        this.ourENR = ourENR;
        this.routingTable = routingTable;
        this.topicTable = topicTable;
        this.failedPingsListener = failedPingsListener;
        this.coroutineContext = coroutineContext;
        this.activeFindNodes = new HashMap();
        this.chunkedNodeResults = new ExpiringMap();
        this.ticketHolder = new HashMap();
        this.peerSeq = -1L;
        this.now = DiscoveryService.Companion.getCURRENT_TIME_SUPPLIER$devp2p();
    }

    @NotNull
    public final EthereumNodeRecord getEnr() {
        return this.enr;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final HashMap<Bytes, CompletableAsyncResult<List<EthereumNodeRecord>>> getActiveFindNodes() {
        return this.activeFindNodes;
    }

    private final void launchPing() {
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ Session this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)10000L, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = Session.access$sendPing(this.this$0, (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendPing(Continuation<? super AsyncCompletion> var1_1) {
        if (!(var1_1 instanceof sendPing.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$sendPing(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.activePing;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-Session$sendPing$2 = false;
                    if (!it.isDone()) {
                        it.cancel();
                    }
                }
                newPing = AsyncCompletion.incomplete();
                newPing.exceptionally((Consumer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, sendPing$lambda-1(org.apache.tuweni.devp2p.v5.Session java.lang.Throwable ), (Ljava/lang/Throwable;)V)((Session)this));
                newPing.thenRun((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, sendPing$lambda-2(org.apache.tuweni.devp2p.v5.Session ), ()V)((Session)this));
                this.activePing = newPing;
                $continuation.L$0 = newPing;
                $continuation.label = 1;
                v1 = this.send(new PingMessage(null, 0L, 3, null), (Continuation<? super Unit>)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl37
            }
            case 1: {
                newPing = (CompletableAsyncCompletion)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)newPing, (String)"newPing");
                return newPing;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object sendFindNodes(int var1_1, @NotNull Continuation<? super AsyncResult<List<EthereumNodeRecord>>> var2_2) {
        if (!(var2_2 instanceof sendFindNodes.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.sendFindNodes(0, (Continuation<? super AsyncResult<List<EthereumNodeRecord>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                message = new FindNodeMessage(null, (int)distance, 1, null);
                var5_7 = AsyncResult.incomplete();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"incomplete()");
                result = var5_7;
                var5_7 = this.getActiveFindNodes();
                var6_9 = message.getRequestId();
                var5_7.put(var6_9, result);
                $continuation.L$0 = result;
                $continuation.label = 1;
                v0 = this.send(message, (Continuation<? super Unit>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                result = (CompletableAsyncResult)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object processMessage(@NotNull Bytes messageBytes, @NotNull Continuation<? super Unit> $completion) {
        if (messageBytes.size() > 1280) {
            logger.trace("Message too long, dropping from {}", (Object)this.address);
            return Unit.INSTANCE;
        }
        logger.trace("Received message from {}", (Object)this.address);
        Message message = null;
        try {
            message = this.decode(messageBytes);
        }
        catch (InvalidRLPTypeException e) {
            logger.trace("Bad message content, dropping from {}: {}", (Object)this.address, (Object)messageBytes);
            return Unit.INSTANCE;
        }
        logger.trace("Received message of type {}", (Object)message.type());
        switch (WhenMappings.$EnumSwitchMapping$0[message.type().ordinal()]) {
            case 1: {
                Object object = this.handleFindNode((FindNodeMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 2: {
                Object object = this.handleNodes((NodesMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 3: {
                Object object = this.handlePing((PingMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 4: {
                Object object = this.handlePong((PongMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 5: {
                Object object = this.handleRegTopic((RegTopicMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 6: {
                Object object = this.handleRegConfirmation((RegConfirmationMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 7: {
                Object object = this.handleTicket((TicketMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 8: {
                Object object = this.handleTopicQuery((TopicQueryMessage)message, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            case 9: {
                throw new UnsupportedOperationException("random");
            }
            case 10: {
                throw new UnsupportedOperationException("whoareyou");
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleTopicQuery(TopicQueryMessage var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof handleTopicQuery.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$handleTopicQuery(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = message.getTopic().toHexString();
                Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"message.topic.toHexString()");
                nodes = this.topicTable.getNodes(new Topic((String)var4_6));
                var4_6 = CollectionsKt.chunked((Iterable)nodes, (int)4).iterator();
lbl16:
                // 3 sources

                while (var4_6.hasNext()) {
                    chunk = (List)var4_6.next();
                    response = new NodesMessage(message.getRequestId(), nodes.size(), chunk);
                    $continuation.L$0 = this;
                    $continuation.L$1 = message;
                    $continuation.L$2 = nodes;
                    $continuation.L$3 = var4_6;
                    $continuation.label = 1;
                    v0 = this.send(response, (Continuation<? super Unit>)$continuation);
                    if (v0 != var9_5) continue;
                    return var9_5;
                }
                break;
            }
            case 1: {
                var4_6 = (Iterator)$continuation.L$3;
                nodes = (List<EthereumNodeRecord>)$continuation.L$2;
                message = (TopicQueryMessage)$continuation.L$1;
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl16
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handlePong(PongMessage var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof handlePong.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$handlePong(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.activePing;
                if (v0 == null ? false : v0.isDone() == true) {
                    Session.logger.trace("Received pong when no ping was active");
                    return Unit.INSTANCE;
                }
                if (this.peerSeq != message.getEnrSeq()) {
                    request = new FindNodeMessage(message.getRequestId(), 0, 2, null);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v1 = this.send(request, (Continuation<? super Unit>)$continuation);
                    if (v1 == var6_5) {
                        return var6_5;
                    }
                }
                ** GOTO lbl28
            }
            case 1: {
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                v2 = this.activePing;
                if (v2 != null) {
                    Boxing.boxBoolean((boolean)v2.complete());
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handlePing(PingMessage message, Continuation<? super Unit> $completion) {
        this.activePing = AsyncCompletion.incomplete();
        Bytes bytes = message.getRequestId();
        long l = ((EthereumNodeRecord)this.ourENR.invoke()).seq();
        String string = this.address.host();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.host()");
        PongMessage response = new PongMessage(bytes, l, string, this.address.port());
        Object object = this.send(response, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object handleNodes(NodesMessage message, Continuation<? super Unit> $completion) {
        if (this.getActiveFindNodes().get(message.getRequestId()) == null) {
            logger.trace("Received NODES message but no matching FINDNODES present. Dropping");
            return Unit.INSTANCE;
        }
        List<EthereumNodeRecord> enrs = message.getNodeRecords();
        List records = (List)this.chunkedNodeResults.computeIfAbsent((Object)message.getRequestId(), Session::handleNodes$lambda-3);
        records.addAll((Collection)enrs);
        logger.debug("Received " + enrs.size() + " for " + records.size() + "/" + message.getTotal());
        if (records.size() == 0 && message.getTotal() != 0 || records.size() >= message.getTotal()) {
            CompletableAsyncResult<List<EthereumNodeRecord>> completableAsyncResult;
            CompletableAsyncResult<List<EthereumNodeRecord>> completableAsyncResult2 = this.getActiveFindNodes().get(message.getRequestId());
            if (completableAsyncResult2 == null) {
                completableAsyncResult = null;
            } else {
                CompletableAsyncResult<List<EthereumNodeRecord>> it = completableAsyncResult2;
                boolean bl = false;
                it.complete(this.chunkedNodeResults.get((Object)message.getRequestId()));
                this.chunkedNodeResults.remove((Object)message.getRequestId());
                completableAsyncResult = this.getActiveFindNodes().remove(message.getRequestId());
            }
            if (completableAsyncResult == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return completableAsyncResult;
            }
        }
        return Unit.INSTANCE;
    }

    private final Object handleTicket(TicketMessage message, Continuation<? super Unit> $completion) {
        this.ticketHolder.put(message.getRequestId(), message.getTicket());
        if (message.getWaitTime() != 0L) {
            Ticket ticket = Ticket.Companion.decrypt(message.getTicket(), this.sessionKey.getInitiatorKey());
            Object object = this.delayRegTopic(message.getRequestId(), ticket.getTopic(), message.getWaitTime(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object handleRegTopic(RegTopicMessage message, Continuation<? super Unit> $completion) {
        long l;
        Ticket ticket;
        String string = message.getTopic().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.topic.toHexString()");
        Topic topic = new Topic(string);
        if (!message.getTicket().isEmpty()) {
            Ticket ticket2 = Ticket.Companion.decrypt(message.getTicket(), this.sessionKey.getInitiatorKey());
            Bytes bytes = (Bytes)this.nodeId;
            String string2 = this.address.host();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"address.host()");
            ticket2.validate(bytes, string2, ((Number)this.now.invoke()).longValue(), message.getTopic());
            ticket = ticket2;
        } else {
            ticket = null;
        }
        Ticket existingTicket = ticket;
        long waitTime = this.topicTable.put(topic, message.getNodeRecord());
        Ticket ticket3 = existingTicket;
        long cumTime = (ticket3 == null ? waitTime : (l = ticket3.getCumTime())) + waitTime;
        Bytes bytes = message.getTopic();
        Bytes bytes2 = (Bytes)this.nodeId;
        String string3 = this.address.host();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"address.host()");
        Ticket ticket4 = new Ticket(bytes, bytes2, string3, ((Number)this.now.invoke()).longValue(), waitTime, cumTime);
        Bytes encryptedTicket = ticket4.encrypt(this.sessionKey.getInitiatorKey());
        TicketMessage response = new TicketMessage(message.getRequestId(), encryptedTicket, waitTime);
        this.sendFn.invoke((Object)this.address, (Object)response.toRLP());
        if (waitTime == 0L) {
            RegConfirmationMessage confirmation = new RegConfirmationMessage(message.getRequestId(), message.getTopic());
            Object object = this.send(confirmation, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object handleRegConfirmation(RegConfirmationMessage message, Continuation<? super Unit> $completion) {
        this.ticketHolder.remove(message.getRequestId());
        Object object = this.registerTopic(message.getTopic(), true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object send(Message message, Continuation<? super Unit> $completion) {
        logger.trace("Sending an encrypted message of type {}", (Object)message.type());
        Bytes[] bytesArray = new Bytes[2];
        byte[] byArray = new byte[]{message.type().byte()};
        bytesArray[0] = Bytes.of((byte[])byArray);
        bytesArray[1] = message.toRLP();
        Bytes messagePlain = Bytes.concatenate((Bytes[])bytesArray);
        Bytes authTag = Message.Companion.authTag();
        Bytes bytes = this.sessionKey.getInitiatorKey();
        Intrinsics.checkNotNullExpressionValue((Object)messagePlain, (String)"messagePlain");
        Bytes encryptionResult = AES128GCM.INSTANCE.encrypt(bytes, authTag, messagePlain, (Bytes)this.tag);
        Bytes[] bytesArray2 = new Bytes[]{(Bytes)this.tag, RLP.encodeValue((Bytes)authTag), encryptionResult};
        Bytes bytes2 = Bytes.concatenate((Bytes[])bytesArray2);
        Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"concatenate(tag, RLP.enc\u2026thTag), encryptionResult)");
        Object object = this.sendFn.invoke((Object)this.address, (Object)bytes2);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleFindNode(FindNodeMessage var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof handleFindNode.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$handleFindNode(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (message.getDistance() != 0) break;
                response = new NodesMessage(message.getRequestId(), 1, CollectionsKt.listOf((Object)this.ourENR.invoke()));
                $continuation.label = 1;
                v0 = this.send(response, (Continuation<? super Unit>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        nodes = this.routingTable.nodesOfDistance(message.getDistance());
        var4_8 = CollectionsKt.chunked((Iterable)nodes, (int)4).iterator();
lbl25:
        // 3 sources

        while (var4_8.hasNext()) {
            chunk = (List)var4_8.next();
            response = new NodesMessage(message.getRequestId(), nodes.size(), chunk);
            $continuation.L$0 = this;
            $continuation.L$1 = message;
            $continuation.L$2 = nodes;
            $continuation.L$3 = var4_8;
            $continuation.label = 2;
            v1 = this.send(response, (Continuation<? super Unit>)$continuation);
            if (v1 != var9_5) continue;
            return var9_5;
        }
        {
            break;
            case 2: {
                var4_8 = (Iterator<E>)$continuation.L$3;
                nodes = (List<EthereumNodeRecord>)$continuation.L$2;
                message = (FindNodeMessage)$continuation.L$1;
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl25
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final Message decode(@NotNull Bytes message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Bytes tag = message.slice(0, 32);
        Bytes contentWithHeader = message.slice(32);
        Message decodedMessage = (Message)RLP.decode((Bytes)contentWithHeader, arg_0 -> Session.decode$lambda-5(this, tag, contentWithHeader, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)decodedMessage, (String)"decodedMessage");
        return decodedMessage;
    }

    @NotNull
    public final Message read$devp2p(@NotNull Bytes tag, @NotNull Bytes contentWithHeader, @NotNull RLPReader reader) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)contentWithHeader, (String)"contentWithHeader");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.nextIsList()) {
            // empty if block
        }
        Bytes authTag = reader.readValue();
        Bytes encryptedContent = contentWithHeader.slice(reader.position());
        Bytes decryptionKey = this.sessionKey.getRecipientKey();
        Intrinsics.checkNotNullExpressionValue((Object)authTag, (String)"authTag");
        Intrinsics.checkNotNullExpressionValue((Object)encryptedContent, (String)"encryptedContent");
        Bytes decryptedContent = AES128GCM.INSTANCE.decrypt(decryptionKey, authTag, encryptedContent, tag);
        Bytes type = decryptedContent.slice(0, 1);
        Bytes message2 = decryptedContent.slice(1);
        MessageType messageType = MessageType.Companion.valueOf(type.toInt());
        switch (WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = PingMessage.Companion.create(message2);
                break;
            }
            case 4: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = PongMessage.Companion.create(message2);
                break;
            }
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = FindNodeMessage.Companion.create(message2);
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = NodesMessage.Companion.create(message2);
                break;
            }
            case 5: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = RegTopicMessage.Companion.create(message2);
                break;
            }
            case 7: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = TicketMessage.Companion.create(message2);
                break;
            }
            case 6: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = RegConfirmationMessage.Companion.create(message2);
                break;
            }
            case 8: {
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
                message = TopicQueryMessage.Companion.create(message2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported message type " + messageType);
            }
        }
        return message;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object delayRegTopic(@NotNull Bytes var1_1, @NotNull Bytes var2_2, long var3_3, @NotNull Continuation<? super Unit> var5_4) {
        if (!(var5_4 instanceof delayRegTopic.1)) ** GOTO lbl-1000
        var9_5 = var5_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.delayRegTopic(null, null, 0L, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = requestId;
                $continuation.L$2 = topic;
                $continuation.label = 1;
                v0 = DelayKt.delay((long)waitTime, (Continuation)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                topic = (Bytes)$continuation.L$2;
                requestId = (Bytes)$continuation.L$1;
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((ticket = this.ticketHolder.get(requestId)) != null) {
                    $i$a$-let-Session$delayRegTopic$2 = false;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v1 = this.sendRegTopic(topic, ticket, requestId, (Continuation<? super Unit>)$continuation);
                    if (v1 == var10_7) {
                        return var10_7;
                    }
                }
                ** GOTO lbl41
            }
            case 2: {
                $i$a$-let-Session$delayRegTopic$2 = false;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object registerTopic(@NotNull Bytes var1_1, boolean var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof registerTopic.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.registerTopic(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (withDelay != false) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = topic;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)900000L, (Continuation)$continuation);
                    if (v0 == var7_6) {
                        return var7_6;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                topic = (Bytes)$continuation.L$1;
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                var4_7 = Bytes.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)var4_7, (String)"EMPTY");
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = Session.sendRegTopic$default(this, topic, var4_7, null, (Continuation)$continuation, 4, null);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl37
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object registerTopic$default(Session session2, Bytes bytes, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return session2.registerTopic(bytes, bl, (Continuation<? super Unit>)continuation);
    }

    private final Object sendRegTopic(Bytes topic, Bytes ticket, Bytes requestId, Continuation<? super Unit> $completion) {
        String string = "" + topic + ticket + requestId;
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)string));
    }

    static /* synthetic */ Object sendRegTopic$default(Session session2, Bytes bytes, Bytes bytes2, Bytes bytes3, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bytes3 = Message.Companion.requestId();
        }
        return session2.sendRegTopic(bytes, bytes2, bytes3, (Continuation<? super Unit>)continuation);
    }

    private static final void sendPing$lambda-1(Session this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = this$0.missedPings;
        this$0.missedPings = n + 1;
        if (!((Boolean)this$0.failedPingsListener.invoke((Object)this$0.missedPings)).booleanValue()) {
            this$0.launchPing();
        }
    }

    private static final void sendPing$lambda-2(Session this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.missedPings = 0;
        this$0.launchPing();
    }

    private static final List handleNodes$lambda-3(Bytes it) {
        return new ArrayList();
    }

    private static final Message decode$lambda-5(Session this$0, Bytes $tag, Bytes $contentWithHeader, RLPReader reader) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)$tag, (String)"tag");
        Intrinsics.checkNotNullExpressionValue((Object)$contentWithHeader, (String)"contentWithHeader");
        Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"reader");
        return this$0.read$devp2p($tag, $contentWithHeader, reader);
    }

    public static final /* synthetic */ Object access$sendPing(Session $this, Continuation $completion) {
        return $this.sendPing((Continuation<? super AsyncCompletion>)$completion);
    }

    public static final /* synthetic */ Object access$handleTopicQuery(Session $this, TopicQueryMessage message, Continuation $completion) {
        return $this.handleTopicQuery(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handlePong(Session $this, PongMessage message, Continuation $completion) {
        return $this.handlePong(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handlePing(Session $this, PingMessage message, Continuation $completion) {
        return $this.handlePing(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleNodes(Session $this, NodesMessage message, Continuation $completion) {
        return $this.handleNodes(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleTicket(Session $this, TicketMessage message, Continuation $completion) {
        return $this.handleTicket(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleRegTopic(Session $this, RegTopicMessage message, Continuation $completion) {
        return $this.handleRegTopic(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleRegConfirmation(Session $this, RegConfirmationMessage message, Continuation $completion) {
        return $this.handleRegConfirmation(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$send(Session $this, Message message, Continuation $completion) {
        return $this.send(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleFindNode(Session $this, FindNodeMessage message, Continuation $completion) {
        return $this.handleFindNode(message, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$sendRegTopic(Session $this, Bytes topic, Bytes ticket, Bytes requestId, Continuation $completion) {
        return $this.sendRegTopic(topic, ticket, requestId, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/devp2p/v5/Session$Companion;", "", "()V", "PING_REFRESH", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            nArray[MessageType.FINDNODE.ordinal()] = 1;
            nArray[MessageType.NODES.ordinal()] = 2;
            nArray[MessageType.PING.ordinal()] = 3;
            nArray[MessageType.PONG.ordinal()] = 4;
            nArray[MessageType.REGTOPIC.ordinal()] = 5;
            nArray[MessageType.REGCONFIRM.ordinal()] = 6;
            nArray[MessageType.TICKET.ordinal()] = 7;
            nArray[MessageType.TOPICQUERY.ordinal()] = 8;
            nArray[MessageType.RANDOM.ordinal()] = 9;
            nArray[MessageType.WHOAREYOU.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

