/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.devp2p.v5.MessageType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/v5/Message;", "", "toRLP", "Lorg/apache/tuweni/bytes/Bytes;", "type", "Lorg/apache/tuweni/devp2p/v5/MessageType;", "Companion", "devp2p"})
public interface Message {
    @NotNull
    public static final Companion Companion = org.apache.tuweni.devp2p.v5.Message$Companion.$$INSTANCE;
    public static final int MAX_UDP_MESSAGE_SIZE = 1280;
    public static final int TAG_LENGTH = 32;
    public static final int AUTH_TAG_LENGTH = 12;
    public static final int RANDOM_DATA_LENGTH = 44;
    public static final int ID_NONCE_LENGTH = 32;
    public static final int REQUEST_ID_LENGTH = 8;

    @NotNull
    public Bytes toRLP();

    @NotNull
    public MessageType type();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/tuweni/devp2p/v5/Message$Companion;", "", "()V", "AUTH_TAG_LENGTH", "", "ID_NONCE_LENGTH", "MAX_UDP_MESSAGE_SIZE", "RANDOM_DATA_LENGTH", "REQUEST_ID_LENGTH", "TAG_LENGTH", "WHO_ARE_YOU", "Lorg/apache/tuweni/bytes/Bytes;", "authTag", "getSourceFromTag", "tag", "dest", "idNonce", "magic", "requestId", "Lorg/apache/tuweni/bytes/Bytes32;", "src", "devp2p"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int MAX_UDP_MESSAGE_SIZE = 1280;
        public static final int TAG_LENGTH = 32;
        public static final int AUTH_TAG_LENGTH = 12;
        public static final int RANDOM_DATA_LENGTH = 44;
        public static final int ID_NONCE_LENGTH = 32;
        public static final int REQUEST_ID_LENGTH = 8;
        @NotNull
        private static final Bytes WHO_ARE_YOU;

        private Companion() {
        }

        @NotNull
        public final Bytes magic(@NotNull Bytes dest) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Bytes[] bytesArray = new Bytes[]{dest, WHO_ARE_YOU};
            Bytes32 bytes32 = Hash.sha2_256((Bytes)Bytes.wrap((Bytes[])bytesArray));
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"sha2_256(Bytes.wrap(dest, WHO_ARE_YOU))");
            return (Bytes)bytes32;
        }

        @NotNull
        public final Bytes32 tag(@NotNull Bytes32 src, @NotNull Bytes dest) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Bytes32 encodedDestKey = Hash.sha2_256((Bytes)dest);
            Bytes32 bytes32 = encodedDestKey.xor(src);
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"encodedDestKey.xor(src)");
            return bytes32;
        }

        @NotNull
        public final Bytes getSourceFromTag(@NotNull Bytes tag, @NotNull Bytes dest) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            Bytes32 encodedDestKey = Hash.sha2_256((Bytes)dest);
            Bytes[] bytesArray = new Bytes[]{(Bytes)encodedDestKey};
            Bytes bytes = Bytes.wrap((Bytes[])bytesArray).xor(tag);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(encodedDestKey).xor(tag)");
            return bytes;
        }

        @NotNull
        public final Bytes requestId() {
            Bytes bytes = Bytes.random((int)8);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"random(REQUEST_ID_LENGTH)");
            return bytes;
        }

        @NotNull
        public final Bytes authTag() {
            Bytes bytes = Bytes.random((int)12);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"random(AUTH_TAG_LENGTH)");
            return bytes;
        }

        @NotNull
        public final Bytes idNonce() {
            Bytes bytes = Bytes.random((int)32);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"random(ID_NONCE_LENGTH)");
            return bytes;
        }

        static {
            $$INSTANCE = new Companion();
            String string = "WHOAREYOU";
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Bytes bytes = Bytes.wrap((byte[])byArray);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(\"WHOAREYOU\".toByteArray())");
            WHO_ARE_YOU = bytes;
        }
    }
}

