/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/apache/tuweni/devp2p/PongPacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "to", "Lorg/apache/tuweni/devp2p/Endpoint;", "pingHash", "expiration", "", "enrSeq", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/bytes/Bytes32;JLjava/lang/Long;)V", "getEnrSeq", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getPingHash", "()Lorg/apache/tuweni/bytes/Bytes32;", "getTo", "()Lorg/apache/tuweni/devp2p/Endpoint;", "encode", "Lorg/apache/tuweni/bytes/Bytes;", "Companion", "devp2p"})
public final class PongPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Endpoint to;
    @NotNull
    private final Bytes32 pingHash;
    @Nullable
    private final Long enrSeq;

    private PongPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint to, Bytes32 pingHash, long expiration, Long enrSeq) {
        super(nodeId, signature, hash, expiration, null);
        this.to = to;
        this.pingHash = pingHash;
        this.enrSeq = enrSeq;
    }

    @NotNull
    public final Endpoint getTo() {
        return this.to;
    }

    @NotNull
    public final Bytes32 getPingHash() {
        return this.pingHash;
    }

    @Nullable
    public final Long getEnrSeq() {
        return this.enrSeq;
    }

    @Override
    @NotNull
    public Bytes encode() {
        return this.encodeTo(PacketType.PONG, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ PongPacket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.PongPacket$Companion.access$encodeTo(PongPacket.Companion, writer, this.this$0.getTo(), this.this$0.getPingHash(), this.this$0.getExpiration(), this.this$0.getEnrSeq());
            }
        }));
    }

    public /* synthetic */ PongPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint to, Bytes32 pingHash, long expiration, Long enrSeq, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, to, pingHash, expiration, enrSeq);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J7\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/devp2p/PongPacket$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/PongPacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "to", "Lorg/apache/tuweni/devp2p/Endpoint;", "pingHash", "Lorg/apache/tuweni/bytes/Bytes32;", "enrSeq", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/bytes/Bytes32;Ljava/lang/Long;)Lorg/apache/tuweni/devp2p/PongPacket;", "decode", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "(Lorg/apache/tuweni/rlp/RLPWriter;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/bytes/Bytes32;JLjava/lang/Long;)V", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PongPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull Endpoint to, @NotNull Bytes32 pingHash, @Nullable Long enrSeq) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)pingHash, (String)"pingHash");
            long expiration = Packet.expirationFor(now);
            SigHash sigHash2 = Packet.createSignature(PacketType.PONG, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(to, pingHash, expiration, enrSeq){
                final /* synthetic */ Endpoint $to;
                final /* synthetic */ Bytes32 $pingHash;
                final /* synthetic */ long $expiration;
                final /* synthetic */ Long $enrSeq;
                {
                    this.$to = $to;
                    this.$pingHash = $pingHash;
                    this.$expiration = $expiration;
                    this.$enrSeq = $enrSeq;
                    super(1);
                }

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.PongPacket$Companion.access$encodeTo(PongPacket.Companion, writer, this.$to, this.$pingHash, this.$expiration, this.$enrSeq);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.publicKey()");
            return new PongPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), to, pingHash, expiration, enrSeq, null);
        }

        @NotNull
        public final PongPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, arg_0 -> Companion.decode$lambda-1(publicKey, signature, hash, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeList(payload) { re\u2026piration), seq)\n        }");
                return (PongPacket)object;
            }
            catch (RLPException e) {
                throw new DecodingException("Invalid pong packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, Endpoint to, Bytes32 pingHash, long expiration, Long enrSeq) {
            writer.writeList(arg_0 -> Companion.encodeTo$lambda-2(to, arg_0));
            writer.writeValue((Bytes)pingHash);
            writer.writeLong(PacketKt.access$msecToSec(expiration));
            Long l = enrSeq;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                writer.writeLong(it);
            }
        }

        private static final Endpoint decode$lambda-1$lambda-0(RLPReader r) {
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            return Endpoint.Companion.readFrom(r);
        }

        private static final PongPacket decode$lambda-1(SECP256K1.PublicKey $publicKey, SECP256K1.Signature $signature, Bytes32 $hash, RLPReader reader) {
            Intrinsics.checkNotNullParameter((Object)$publicKey, (String)"$publicKey");
            Intrinsics.checkNotNullParameter((Object)$signature, (String)"$signature");
            Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
            Endpoint to = (Endpoint)reader.readList(Companion::decode$lambda-1$lambda-0);
            Bytes32 pingHash = Bytes32.wrap((Bytes)reader.readValue());
            long expiration = reader.readLong();
            Long seq = null;
            seq = !reader.isComplete() ? Long.valueOf(reader.readLong()) : null;
            Intrinsics.checkNotNullExpressionValue((Object)to, (String)"to");
            Intrinsics.checkNotNullExpressionValue((Object)pingHash, (String)"pingHash");
            return new PongPacket($publicKey, $signature, $hash, to, pingHash, PacketKt.access$secToMsec(expiration), seq, null);
        }

        private static final void encodeTo$lambda-2(Endpoint $to, RLPWriter w) {
            Intrinsics.checkNotNullParameter((Object)$to, (String)"$to");
            Intrinsics.checkNotNullExpressionValue((Object)w, (String)"w");
            $to.writeTo$devp2p(w);
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, Endpoint to, Bytes32 pingHash, long expiration, Long enrSeq) {
            $this.encodeTo(writer, to, pingHash, expiration, enrSeq);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

