/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/devp2p/PingPacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "from", "Lorg/apache/tuweni/devp2p/Endpoint;", "to", "expiration", "", "enrSeq", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/devp2p/Endpoint;JLjava/lang/Long;)V", "getEnrSeq", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getFrom", "()Lorg/apache/tuweni/devp2p/Endpoint;", "getTo", "encode", "Lorg/apache/tuweni/bytes/Bytes;", "Companion", "devp2p"})
public final class PingPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Endpoint from;
    @NotNull
    private final Endpoint to;
    @Nullable
    private final Long enrSeq;
    private static final int VERSION = 4;

    private PingPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint from, Endpoint to, long expiration, Long enrSeq) {
        super(nodeId, signature, hash, expiration, null);
        this.from = from;
        this.to = to;
        this.enrSeq = enrSeq;
    }

    @NotNull
    public final Endpoint getFrom() {
        return this.from;
    }

    @NotNull
    public final Endpoint getTo() {
        return this.to;
    }

    @Nullable
    public final Long getEnrSeq() {
        return this.enrSeq;
    }

    @Override
    @NotNull
    public Bytes encode() {
        return this.encodeTo(PacketType.PING, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ PingPacket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.PingPacket$Companion.access$encodeTo(PingPacket.Companion, writer, this.this$0.getFrom(), this.this$0.getTo(), this.this$0.getExpiration(), this.this$0.getEnrSeq());
            }
        }));
    }

    public /* synthetic */ PingPacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, Endpoint from, Endpoint to, long expiration, Long enrSeq, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, from, to, expiration, enrSeq);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J7\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/apache/tuweni/devp2p/PingPacket$Companion;", "", "()V", "VERSION", "", "create", "Lorg/apache/tuweni/devp2p/PingPacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "from", "Lorg/apache/tuweni/devp2p/Endpoint;", "to", "seq", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/devp2p/Endpoint;Ljava/lang/Long;)Lorg/apache/tuweni/devp2p/PingPacket;", "decode", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "(Lorg/apache/tuweni/rlp/RLPWriter;Lorg/apache/tuweni/devp2p/Endpoint;Lorg/apache/tuweni/devp2p/Endpoint;JLjava/lang/Long;)V", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PingPacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull Endpoint from, @NotNull Endpoint to, @Nullable Long seq) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            long expiration = Packet.expirationFor(now);
            SigHash sigHash2 = Packet.createSignature(PacketType.PING, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(from, to, expiration, seq){
                final /* synthetic */ Endpoint $from;
                final /* synthetic */ Endpoint $to;
                final /* synthetic */ long $expiration;
                final /* synthetic */ Long $seq;
                {
                    this.$from = $from;
                    this.$to = $to;
                    this.$expiration = $expiration;
                    this.$seq = $seq;
                    super(1);
                }

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.PingPacket$Companion.access$encodeTo(PingPacket.Companion, writer, this.$from, this.$to, this.$expiration, this.$seq);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.publicKey()");
            return new PingPacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), from, to, expiration, seq, null);
        }

        @NotNull
        public final PingPacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, arg_0 -> Companion.decode$lambda-2(publicKey, signature, hash, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeList(payload) { re\u2026piration), seq)\n        }");
                return (PingPacket)object;
            }
            catch (RLPException e) {
                throw new DecodingException("Invalid ping packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, Endpoint from, Endpoint to, long expiration, Long seq) {
            writer.writeInt(4);
            writer.writeList(arg_0 -> Companion.encodeTo$lambda-3(from, arg_0));
            writer.writeList(arg_0 -> Companion.encodeTo$lambda-4(to, arg_0));
            writer.writeLong(PacketKt.access$msecToSec(expiration));
            Long l = seq;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                writer.writeLong(it);
            }
        }

        private static final Endpoint decode$lambda-2$lambda-0(RLPReader r) {
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            return Endpoint.Companion.readFrom(r);
        }

        private static final Endpoint decode$lambda-2$lambda-1(RLPReader r) {
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            return Endpoint.Companion.readFrom(r);
        }

        private static final PingPacket decode$lambda-2(SECP256K1.PublicKey $publicKey, SECP256K1.Signature $signature, Bytes32 $hash, RLPReader reader) {
            Intrinsics.checkNotNullParameter((Object)$publicKey, (String)"$publicKey");
            Intrinsics.checkNotNullParameter((Object)$signature, (String)"$signature");
            Intrinsics.checkNotNullParameter((Object)$hash, (String)"$hash");
            int version = reader.readInt();
            Endpoint from = (Endpoint)reader.readList(Companion::decode$lambda-2$lambda-0);
            Endpoint to = (Endpoint)reader.readList(Companion::decode$lambda-2$lambda-1);
            long expiration = reader.readLong();
            Long seq = null;
            seq = !reader.isComplete() ? Long.valueOf(reader.readLong()) : null;
            if (version < 4) {
                throw new DecodingException("Unexpected version 4 in ping", null, 2, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)from, (String)"from");
            Intrinsics.checkNotNullExpressionValue((Object)to, (String)"to");
            return new PingPacket($publicKey, $signature, $hash, from, to, PacketKt.access$secToMsec(expiration), seq, null);
        }

        private static final void encodeTo$lambda-3(Endpoint $from, RLPWriter w) {
            Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
            Intrinsics.checkNotNullExpressionValue((Object)w, (String)"w");
            $from.writeTo$devp2p(w);
        }

        private static final void encodeTo$lambda-4(Endpoint $to, RLPWriter w) {
            Intrinsics.checkNotNullParameter((Object)$to, (String)"$to");
            Intrinsics.checkNotNullExpressionValue((Object)w, (String)"w");
            $to.writeTo$devp2p(w);
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, Endpoint from, Endpoint to, long expiration, Long seq) {
            $this.encodeTo(writer, from, to, expiration, seq);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

