/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H&J$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0006\u001e\u001f !\"#\u00a8\u0006$"}, d2={"Lorg/apache/tuweni/devp2p/Packet;", "", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "expiration", "", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;J)V", "getExpiration", "()J", "getHash", "()Lorg/apache/tuweni/bytes/Bytes32;", "getNodeId", "()Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "encode", "Lorg/apache/tuweni/bytes/Bytes;", "encodeTo", "packetType", "Lorg/apache/tuweni/devp2p/PacketType;", "contentWriter", "Lkotlin/Function1;", "Lorg/apache/tuweni/rlp/RLPWriter;", "", "isExpired", "", "now", "Companion", "Lorg/apache/tuweni/devp2p/PingPacket;", "Lorg/apache/tuweni/devp2p/PongPacket;", "Lorg/apache/tuweni/devp2p/FindNodePacket;", "Lorg/apache/tuweni/devp2p/NeighborsPacket;", "Lorg/apache/tuweni/devp2p/ENRRequestPacket;", "Lorg/apache/tuweni/devp2p/ENRResponsePacket;", "devp2p"})
public abstract class Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SECP256K1.PublicKey nodeId;
    @NotNull
    private final SECP256K1.Signature signature;
    @NotNull
    private final Bytes32 hash;
    private final long expiration;
    public static final int MIN_SIZE = 104;
    public static final int MAX_SIZE = 1280;
    private static final int HASH_INDEX = 0;
    private static final int SIGNATURE_INDEX = 32;
    private static final int PACKET_TYPE_INDEX = 97;
    private static final int PACKET_DATA_INDEX = 98;

    private Packet(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, long expiration) {
        this.nodeId = nodeId;
        this.signature = signature;
        this.hash = hash;
        this.expiration = expiration;
    }

    @NotNull
    public final SECP256K1.PublicKey getNodeId() {
        return this.nodeId;
    }

    @NotNull
    public final Bytes32 getHash() {
        return this.hash;
    }

    public final long getExpiration() {
        return this.expiration;
    }

    public final boolean isExpired(long now) {
        return this.expiration <= now;
    }

    @NotNull
    public abstract Bytes encode();

    @NotNull
    protected final Bytes encodeTo(@NotNull PacketType packetType, @NotNull Function1<? super RLPWriter, Unit> contentWriter) {
        Intrinsics.checkNotNullParameter((Object)((Object)packetType), (String)"packetType");
        Intrinsics.checkNotNullParameter(contentWriter, (String)"contentWriter");
        Bytes[] bytesArray = new Bytes[4];
        bytesArray[0] = (Bytes)this.hash;
        bytesArray[1] = this.signature.bytes();
        byte[] byArray = new byte[]{packetType.getTypeId()};
        bytesArray[2] = Bytes.of((byte[])byArray);
        bytesArray[3] = RLP.encodeList(arg_0 -> Packet.encodeTo$lambda-0(contentWriter, arg_0));
        Bytes bytes = Bytes.wrap((Bytes[])bytesArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(hash, signature.byt\u2026ncodeList(contentWriter))");
        return bytes;
    }

    private static final void encodeTo$lambda-0(Function1 $tmp0, RLPWriter p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0);
    }

    @JvmStatic
    protected static final long expirationFor(long now) {
        return Companion.expirationFor(now);
    }

    @JvmStatic
    @NotNull
    protected static final SigHash createSignature(@NotNull PacketType packetType, @NotNull SECP256K1.KeyPair keyPair, @NotNull Function1<? super RLPWriter, Unit> encoder) {
        return Companion.createSignature(packetType, keyPair, encoder);
    }

    public /* synthetic */ Packet(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, long expiration, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, expiration);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/apache/tuweni/devp2p/Packet$Companion;", "", "()V", "HASH_INDEX", "", "MAX_SIZE", "MIN_SIZE", "PACKET_DATA_INDEX", "PACKET_TYPE_INDEX", "SIGNATURE_INDEX", "createSignature", "Lorg/apache/tuweni/devp2p/SigHash;", "packetType", "Lorg/apache/tuweni/devp2p/PacketType;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "encoder", "Lkotlin/Function1;", "Lorg/apache/tuweni/rlp/RLPWriter;", "", "decodeFrom", "Lorg/apache/tuweni/devp2p/Packet;", "datagram", "Ljava/nio/ByteBuffer;", "Lorg/apache/tuweni/bytes/Bytes;", "expirationFor", "", "now", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Packet decodeFrom(@NotNull ByteBuffer datagram) {
            Intrinsics.checkNotNullParameter((Object)datagram, (String)"datagram");
            Bytes bytes = Bytes.wrapByteBuffer((ByteBuffer)datagram);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrapByteBuffer(datagram)");
            return this.decodeFrom(bytes);
        }

        @NotNull
        public final Packet decodeFrom(@NotNull Bytes datagram) {
            Intrinsics.checkNotNullParameter((Object)datagram, (String)"datagram");
            byte typeByte = datagram.get(97);
            PacketType packetType = PacketType.Companion.forType(typeByte);
            if (packetType == null) {
                throw new DecodingException("Unrecognized packet type: " + typeByte, null, 2, null);
            }
            PacketType packetType2 = packetType;
            SECP256K1.Signature signature = SECP256K1.Signature.fromBytes((Bytes)datagram.slice(32, 65));
            SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.recoverFromSignature((Bytes)datagram.slice(97, datagram.size() - 97), (SECP256K1.Signature)signature);
            if (publicKey == null) {
                throw new DecodingException("Invalid packet signature", null, 2, null);
            }
            SECP256K1.PublicKey publicKey2 = publicKey;
            Bytes32 hash = Bytes32.wrap((Bytes)datagram.slice(0, 32));
            if (!Intrinsics.areEqual((Object)Hash.keccak256((Bytes)datagram.slice(32)), (Object)hash)) {
                throw new DecodingException("Invalid packet hash", null, 2, null);
            }
            publicKey = datagram.slice(98);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"datagram.slice(PACKET_DATA_INDEX)");
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
            return packetType2.decode((Bytes)publicKey, hash, publicKey2, signature);
        }

        @JvmStatic
        protected final long expirationFor(long now) {
            return now + 20000L;
        }

        @JvmStatic
        @NotNull
        protected final SigHash createSignature(@NotNull PacketType packetType, @NotNull SECP256K1.KeyPair keyPair, @NotNull Function1<? super RLPWriter, Unit> encoder) {
            Intrinsics.checkNotNullParameter((Object)((Object)packetType), (String)"packetType");
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
            byte[] byArray = new byte[]{packetType.getTypeId()};
            Bytes typeByte = Bytes.of((byte[])byArray);
            Bytes dataBytes = RLP.encodeList(arg_0 -> Companion.createSignature$lambda-0(encoder, arg_0));
            Bytes[] bytesArray = new Bytes[]{typeByte, dataBytes};
            Bytes payloadBytes = Bytes.wrap((Bytes[])bytesArray);
            SECP256K1.Signature signature = SECP256K1.sign((Bytes)payloadBytes, (SECP256K1.KeyPair)keyPair);
            Bytes[] bytesArray2 = new Bytes[]{signature.bytes(), payloadBytes};
            Bytes32 hash = Hash.keccak256((Bytes)Bytes.wrap((Bytes[])bytesArray2));
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
            return new SigHash(signature, hash);
        }

        private static final void createSignature$lambda-0(Function1 $encoder, RLPWriter writer) {
            Intrinsics.checkNotNullParameter((Object)$encoder, (String)"$encoder");
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            $encoder.invoke((Object)writer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

