/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.math.BigInteger;
import java.net.InetAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.InvalidNodeRecordException;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010!\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u0003J\b\u0010$\u001a\u00020\bH\u0016J\r\u0010%\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\"J\u0006\u0010&\u001a\u00020'R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "", "signature", "Lorg/apache/tuweni/bytes/Bytes;", "seq", "", "data", "", "", "listData", "", "rlp", "(Lorg/apache/tuweni/bytes/Bytes;JLjava/util/Map;Ljava/util/Map;Lorg/apache/tuweni/bytes/Bytes;)V", "getData", "()Ljava/util/Map;", "getListData", "getRlp", "()Lorg/apache/tuweni/bytes/Bytes;", "getSeq", "()J", "getSignature", "equals", "", "other", "hashCode", "", "ip", "Ljava/net/InetAddress;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "publicKeyBytes", "tcp", "()Ljava/lang/Integer;", "toRLP", "toString", "udp", "validate", "", "Companion", "devp2p"})
public final class EthereumNodeRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bytes signature;
    private final long seq;
    @NotNull
    private final Map<String, Bytes> data;
    @NotNull
    private final Map<String, List<Bytes>> listData;
    @NotNull
    private final Bytes rlp;

    public EthereumNodeRecord(@NotNull Bytes signature, long seq, @NotNull Map<String, ? extends Bytes> data, @NotNull Map<String, ? extends List<? extends Bytes>> listData, @NotNull Bytes rlp) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(listData, (String)"listData");
        Intrinsics.checkNotNullParameter((Object)rlp, (String)"rlp");
        this.signature = signature;
        this.seq = seq;
        this.data = data;
        this.listData = listData;
        this.rlp = rlp;
    }

    public /* synthetic */ EthereumNodeRecord(Bytes bytes, long l, Map map, Map map2, Bytes bytes2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(bytes, l, map, map2, bytes2);
    }

    @NotNull
    public final Bytes getSignature() {
        return this.signature;
    }

    public final long getSeq() {
        return this.seq;
    }

    @NotNull
    public final Map<String, Bytes> getData() {
        return this.data;
    }

    @NotNull
    public final Map<String, List<Bytes>> getListData() {
        return this.listData;
    }

    @NotNull
    public final Bytes getRlp() {
        return this.rlp;
    }

    public final void validate() {
        SECP256K1.Signature sig0;
        SECP256K1.PublicKey recovered0;
        SECP256K1.PublicKey recovered;
        String string = "v4";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        if (!Intrinsics.areEqual((Object)Bytes.wrap((byte[])byArray), (Object)this.data.get("id"))) {
            throw new InvalidNodeRecordException("id attribute is not set to v4");
        }
        Bytes encoded = RLP.encodeList(arg_0 -> EthereumNodeRecord.validate$lambda-0(this, arg_0));
        SECP256K1.Signature sig = SECP256K1.Signature.create((byte)1, (BigInteger)this.signature.slice(0, 32).toUnsignedBigInteger(), (BigInteger)this.signature.slice(32).toUnsignedBigInteger());
        SECP256K1.PublicKey pubKey = this.publicKey();
        if (!Intrinsics.areEqual((Object)pubKey, (Object)(recovered = SECP256K1.PublicKey.recoverFromSignature((Bytes)encoded, (SECP256K1.Signature)sig))) && !Intrinsics.areEqual((Object)pubKey, (Object)(recovered0 = SECP256K1.PublicKey.recoverFromSignature((Bytes)encoded, (SECP256K1.Signature)(sig0 = SECP256K1.Signature.create((byte)0, (BigInteger)this.signature.slice(0, 32).toUnsignedBigInteger(), (BigInteger)this.signature.slice(32).toUnsignedBigInteger())))))) {
            throw new InvalidNodeRecordException("Public key does not match signature");
        }
    }

    @NotNull
    public final SECP256K1.PublicKey publicKey() {
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.fromBytes((Bytes)this.publicKeyBytes());
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"fromBytes(publicKeyBytes())");
        return publicKey;
    }

    @NotNull
    public final Bytes publicKeyBytes() {
        Bytes bytes = this.data.get("secp256k1");
        if (bytes == null) {
            throw new InvalidNodeRecordException("Missing secp256k1 entry");
        }
        Bytes keyBytes = bytes;
        ECPoint ecPoint = SECP256K1.Parameters.CURVE.getCurve().decodePoint(keyBytes.toArrayUnsafe());
        Bytes bytes2 = Bytes.wrap((byte[])ecPoint.getEncoded(false)).slice(1);
        Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"wrap(ecPoint.getEncoded(false)).slice(1)");
        return bytes2;
    }

    @NotNull
    public final Bytes32 nodeId() {
        return Companion.nodeId(this.publicKey());
    }

    @NotNull
    public final InetAddress ip() {
        InetAddress inetAddress;
        Bytes bytes = this.data.get("ip");
        if (bytes == null) {
            inetAddress = null;
        } else {
            Bytes it = bytes;
            boolean bl = false;
            inetAddress = InetAddress.getByAddress(it.toArrayUnsafe());
        }
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress == null) {
            InetAddress inetAddress3 = InetAddress.getLoopbackAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress3, (String)"getLoopbackAddress()");
            inetAddress2 = inetAddress3;
        }
        return inetAddress2;
    }

    @Nullable
    public final Integer tcp() {
        Bytes bytes = this.data.get("tcp");
        return bytes == null ? null : Integer.valueOf(bytes.toInt());
    }

    @Nullable
    public final Integer udp() {
        Bytes bytes = this.data.get("udp");
        Integer n = bytes == null ? null : Integer.valueOf(bytes.toInt());
        if (n == null) {
            n = this.tcp();
        }
        return n;
    }

    public final long seq() {
        return this.seq;
    }

    @NotNull
    public String toString() {
        return "enr:" + this.ip() + ":" + this.tcp() + "?udp=" + this.udp();
    }

    @NotNull
    public final Bytes toRLP() {
        return this.rlp;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.EthereumNodeRecord");
        }
        EthereumNodeRecord cfr_ignored_0 = (EthereumNodeRecord)object2;
        return Intrinsics.areEqual((Object)this.rlp, (Object)((EthereumNodeRecord)other).rlp);
    }

    public int hashCode() {
        return this.rlp.hashCode();
    }

    private static final void validate$lambda-0(EthereumNodeRecord this$0, RLPWriter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Companion companion = Companion;
        Map<String, Bytes> map = this$0.data;
        long l = this$0.seq;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.encode$default(companion, null, l, null, null, null, map, null, it, 93, null);
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull Bytes rlp) {
        return Companion.fromRLP(rlp);
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull RLPReader reader) {
        return Companion.fromRLP(reader);
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull RLPReader reader, @NotNull Bytes rlp) {
        return Companion.fromRLP(reader, rlp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
        return Companion.create(signatureKeyPair, seq, data, listData, ip, tcp, udp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
        return Companion.toRLP(signatureKeyPair, seq, data, listData, ip, tcp, udp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
        return Companion.create(signatureKeyPair, seq, data, listData, ip, tcp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
        return Companion.create(signatureKeyPair, seq, data, listData, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
        return Companion.create(signatureKeyPair, seq, data, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
        return Companion.create(signatureKeyPair, seq, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
        return Companion.create(signatureKeyPair, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
        return Companion.toRLP(signatureKeyPair, seq, data, listData, ip, tcp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
        return Companion.toRLP(signatureKeyPair, seq, data, listData, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
        return Companion.toRLP(signatureKeyPair, seq, data, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
        return Companion.toRLP(signatureKeyPair, seq, ip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
        return Companion.toRLP(signatureKeyPair, ip);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Ju\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0083\u0001\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\fH\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!Ju\u0010\"\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Lorg/apache/tuweni/devp2p/EthereumNodeRecord$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "signatureKeyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "seq", "", "data", "", "", "Lorg/apache/tuweni/bytes/Bytes;", "listData", "", "ip", "Ljava/net/InetAddress;", "tcp", "", "udp", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/util/Map;Ljava/util/Map;Ljava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "encode", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Ljava/util/Map;Lorg/apache/tuweni/rlp/RLPWriter;)V", "fromRLP", "rlp", "reader", "Lorg/apache/tuweni/rlp/RLPReader;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "toRLP", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/util/Map;Ljava/util/Map;Ljava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/apache/tuweni/bytes/Bytes;", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Bytes32 nodeId(@NotNull SECP256K1.PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            ECPoint pt = publicKey.asEcPoint();
            Bytes32 xPart = UInt256.valueOf((BigInteger)pt.getXCoord().toBigInteger()).toBytes();
            Bytes32 yPart = UInt256.valueOf((BigInteger)pt.getYCoord().toBigInteger()).toBytes();
            Bytes[] bytesArray = new Bytes[]{(Bytes)xPart, (Bytes)yPart};
            Bytes32 bytes32 = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])bytesArray));
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"keccak256(Bytes.concatenate(xPart, yPart))");
            return bytes32;
        }

        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull Bytes rlp) {
            Intrinsics.checkNotNullParameter((Object)rlp, (String)"rlp");
            if (rlp.size() > 300) {
                throw new IllegalArgumentException("Record too long");
            }
            Object object = RLP.decodeList((Bytes)rlp, arg_0 -> Companion.fromRLP$lambda-0(rlp, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decodeList(rlp) { fromRLP(it, rlp) }");
            return (EthereumNodeRecord)object;
        }

        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull RLPReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Bytes bytes = Bytes.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"EMPTY");
            EthereumNodeRecord tempRecord = this.fromRLP(reader, bytes);
            Bytes encoded = RLP.encodeList(arg_0 -> Companion.fromRLP$lambda-1(tempRecord, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
            return this.fromRLP(encoded);
        }

        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull RLPReader reader, @NotNull Bytes rlp) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)rlp, (String)"rlp");
            Bytes sig = reader.readValue();
            long seq = reader.readLong();
            Map data = new LinkedHashMap();
            Map listData = new LinkedHashMap();
            while (!reader.isComplete()) {
                String key = reader.readString();
                if (reader.nextIsList()) {
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    List list = reader.readListContents(Companion::fromRLP$lambda-2);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"reader.readListContents \u2026            }\n          }");
                    listData.put(key, CollectionsKt.filterNotNull((Iterable)list));
                    continue;
                }
                Bytes value = reader.readValue();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                data.put(key, value);
            }
            Intrinsics.checkNotNullExpressionValue((Object)sig, (String)"sig");
            return new EthereumNodeRecord(sig, seq, data, listData, rlp);
        }

        public final void encode(@Nullable SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull RLPWriter writer) {
            Bytes bytes;
            Object it;
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.writeLong(seq);
            Map<String, ? extends Bytes> map = data;
            Map map2 = map == null ? null : MapsKt.toMutableMap(map);
            Map mutableData = map2 == null ? (Map)new LinkedHashMap() : map2;
            String string = "v4";
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Bytes bytes2 = Bytes.wrap((byte[])byArray);
            Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"wrap(\"v4\".toByteArray())");
            mutableData.put("id", bytes2);
            SECP256K1.KeyPair keyPair = signatureKeyPair;
            if (keyPair != null) {
                it = keyPair;
                boolean bl = false;
                bytes = Bytes.wrap((byte[])it.publicKey().asEcPoint().getEncoded(true));
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(it.publicKey().asEcPoint().getEncoded(true))");
                mutableData.put("secp256k1", bytes);
            }
            InetAddress inetAddress = ip;
            if (inetAddress != null) {
                it = inetAddress;
                boolean bl = false;
                bytes = Bytes.wrap((byte[])((InetAddress)it).getAddress());
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(it.address)");
                mutableData.put("ip", bytes);
            }
            Integer n = tcp;
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl = false;
                bytes = Bytes.ofUnsignedShort((int)it2);
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ofUnsignedShort(it)");
                mutableData.put("tcp", bytes);
            }
            Integer n2 = udp;
            if (n2 != null) {
                int it3 = ((Number)n2).intValue();
                boolean bl = false;
                bytes = Bytes.ofUnsignedShort((int)it3);
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ofUnsignedShort(it)");
                mutableData.put("udp", bytes);
            }
            List keys = new ArrayList();
            keys.addAll(mutableData.keySet());
            Map<String, ? extends List<? extends Bytes>> map3 = listData;
            if (map3 != null) {
                Map<String, ? extends List<? extends Bytes>> it4 = map3;
                boolean bl = false;
                keys.addAll((Collection)it4.keySet());
            }
            Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)keys);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List<? extends Bytes> value;
                String key = (String)element$iv;
                boolean bl = false;
                if ((Bytes)mutableData.get(key) != null) {
                    Bytes value2;
                    boolean bl2 = false;
                    writer.writeString(key);
                    writer.writeValue(value2);
                }
                Map<String, ? extends List<? extends Bytes>> map4 = listData;
                if (map4 == null || map4.get(key) == null) continue;
                boolean bl3 = false;
                writer.writeString(key);
                writer.writeList(value, Companion::encode$lambda-11$lambda-10$lambda-9);
            }
        }

        public static /* synthetic */ void encode$default(Companion companion, SECP256K1.KeyPair keyPair, long l, InetAddress inetAddress, Integer n, Integer n2, Map map, Map map2, RLPWriter rLPWriter, int n3, Object object) {
            if ((n3 & 1) != 0) {
                keyPair = null;
            }
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                inetAddress = null;
            }
            if ((n3 & 8) != 0) {
                n = null;
            }
            if ((n3 & 0x10) != 0) {
                n2 = null;
            }
            if ((n3 & 0x20) != 0) {
                map = null;
            }
            if ((n3 & 0x40) != 0) {
                map2 = null;
            }
            companion.encode(keyPair, l, inetAddress, n, n2, map, map2, rLPWriter);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return this.fromRLP(this.toRLP(signatureKeyPair, seq, data, listData, ip, tcp, udp));
        }

        public static /* synthetic */ EthereumNodeRecord create$default(Companion companion, SECP256K1.KeyPair keyPair, long l, Map map, Map map2, InetAddress inetAddress, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                map = null;
            }
            if ((n3 & 8) != 0) {
                map2 = null;
            }
            if ((n3 & 0x20) != 0) {
                n = null;
            }
            if ((n3 & 0x40) != 0) {
                n2 = null;
            }
            return companion.create(keyPair, l, map, map2, inetAddress, n, n2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            Bytes encoded = RLP.encodeList(arg_0 -> Companion.toRLP$lambda-12(signatureKeyPair, seq, ip, tcp, udp, data, listData, arg_0));
            SECP256K1.Signature signature = SECP256K1.sign((Bytes)encoded, (SECP256K1.KeyPair)signatureKeyPair);
            MutableBytes sigBytes = MutableBytes.create((int)64);
            UInt256.valueOf((BigInteger)signature.r()).toBytes().copyTo(sigBytes, 0);
            UInt256.valueOf((BigInteger)signature.s()).toBytes().copyTo(sigBytes, 32);
            Bytes completeEncoding = RLP.encodeList(arg_0 -> Companion.toRLP$lambda-13(sigBytes, signatureKeyPair, seq, ip, tcp, udp, data, listData, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completeEncoding, (String)"completeEncoding");
            return completeEncoding;
        }

        public static /* synthetic */ Bytes toRLP$default(Companion companion, SECP256K1.KeyPair keyPair, long l, Map map, Map map2, InetAddress inetAddress, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                map = null;
            }
            if ((n3 & 8) != 0) {
                map2 = null;
            }
            if ((n3 & 0x20) != 0) {
                n = null;
            }
            if ((n3 & 0x40) != 0) {
                n2 = null;
            }
            return companion.toRLP(keyPair, l, map, map2, inetAddress, n, n2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, data, listData, ip, tcp, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, data, listData, ip, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, data, null, ip, null, null, 104, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, null, null, ip, null, null, 108, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, 0L, null, null, ip, null, null, 110, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, listData, ip, tcp, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, listData, ip, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, null, ip, null, null, 104, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, null, null, ip, null, null, 108, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, 0L, null, null, ip, null, null, 110, null);
        }

        private static final EthereumNodeRecord fromRLP$lambda-0(Bytes $rlp, RLPReader it) {
            Intrinsics.checkNotNullParameter((Object)$rlp, (String)"$rlp");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            return Companion.fromRLP(it, $rlp);
        }

        private static final void fromRLP$lambda-1(EthereumNodeRecord $tempRecord, RLPWriter it) {
            Intrinsics.checkNotNullParameter((Object)$tempRecord, (String)"$tempRecord");
            it.writeValue($tempRecord.getSignature());
            Companion companion = Companion;
            Map<String, Bytes> map = $tempRecord.getData();
            long l = $tempRecord.getSeq();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.encode$default(companion, null, l, null, null, null, map, null, it, 93, null);
        }

        private static final Bytes fromRLP$lambda-2(RLPReader listreader) {
            Bytes bytes;
            if (listreader.nextIsList()) {
                listreader.skipNext();
                bytes = null;
            } else {
                bytes = listreader.readValue();
            }
            return bytes;
        }

        private static final void encode$lambda-11$lambda-10$lambda-9(RLPWriter writer, Bytes v) {
            writer.writeValue(v);
        }

        private static final void toRLP$lambda-12(SECP256K1.KeyPair $signatureKeyPair, long $seq, InetAddress $ip, Integer $tcp, Integer $udp, Map $data, Map $listData, RLPWriter writer) {
            Intrinsics.checkNotNullParameter((Object)$signatureKeyPair, (String)"$signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)$ip, (String)"$ip");
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            Companion.encode($signatureKeyPair, $seq, $ip, $tcp, $udp, $data, $listData, writer);
        }

        private static final void toRLP$lambda-13(MutableBytes $sigBytes, SECP256K1.KeyPair $signatureKeyPair, long $seq, InetAddress $ip, Integer $tcp, Integer $udp, Map $data, Map $listData, RLPWriter writer) {
            Intrinsics.checkNotNullParameter((Object)$signatureKeyPair, (String)"$signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)$ip, (String)"$ip");
            writer.writeValue((Bytes)$sigBytes);
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            Companion.encode($signatureKeyPair, $seq, $ip, $tcp, $udp, $data, $listData, writer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

