/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.EnodeUriComponents;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"DISCPORT_QUERY_STRING_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parseEnodeUri", "Lorg/apache/tuweni/devp2p/EnodeUriComponents;", "uri", "Ljava/net/URI;", "devp2p"})
public final class EnodeUriKt {
    private static final Pattern DISCPORT_QUERY_STRING_REGEX = Pattern.compile(".*discport=([^&]+).*");

    @NotNull
    public static final EnodeUriComponents parseEnodeUri(@NotNull URI uri) {
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!Intrinsics.areEqual((Object)"enode", (Object)uri.getScheme())) {
            boolean $i$a$-require-EnodeUriKt$parseEnodeUri$32 = false;
            String $i$a$-require-EnodeUriKt$parseEnodeUri$32 = "URI must be an enode:// uri";
            throw new IllegalArgumentException($i$a$-require-EnodeUriKt$parseEnodeUri$32.toString());
        }
        if (!(uri.getUserInfo() != null)) {
            boolean $i$a$-require-EnodeUriKt$parseEnodeUri$42 = false;
            String $i$a$-require-EnodeUriKt$parseEnodeUri$42 = "URI must have a node id";
            throw new IllegalArgumentException($i$a$-require-EnodeUriKt$parseEnodeUri$42.toString());
        }
        SECP256K1.PublicKey nodeId = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.fromHexString((CharSequence)uri.getUserInfo()));
        int tcpPort = 30303;
        if (uri.getPort() >= 0) {
            tcpPort = uri.getPort();
        }
        int udpPort = tcpPort;
        String query = uri.getQuery();
        if (query != null && (matcher = DISCPORT_QUERY_STRING_REGEX.matcher(query)).matches()) {
            try {
                udpPort = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid discport query parameter");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)nodeId, (String)"nodeId");
        String string = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.host");
        return new EnodeUriComponents(nodeId, new Endpoint(string, udpPort, tcpPort));
    }
}

