/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import io.vertx.core.net.SocketAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ.\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\r\u0010!\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\"J\t\u0010#\u001a\u00020\u0007H\u00d6\u0001J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lorg/apache/tuweni/devp2p/Endpoint;", "", "address", "Lio/vertx/core/net/SocketAddress;", "tcpPort", "", "(Lio/vertx/core/net/SocketAddress;Ljava/lang/Integer;)V", "", "udpPort", "(Ljava/lang/String;ILjava/lang/Integer;)V", "getAddress", "()Ljava/lang/String;", "getTcpPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "tcpSocketAddress", "Ljava/net/InetSocketAddress;", "getTcpSocketAddress", "()Ljava/net/InetSocketAddress;", "getUdpPort", "()I", "udpSocketAddress", "getUdpSocketAddress", "()Lio/vertx/core/net/SocketAddress;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;ILjava/lang/Integer;)Lorg/apache/tuweni/devp2p/Endpoint;", "equals", "", "other", "hashCode", "rlpSize", "rlpSize$devp2p", "toString", "writeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "writeTo$devp2p", "Companion", "devp2p"})
public final class Endpoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String address;
    private final int udpPort;
    @Nullable
    private final Integer tcpPort;
    @NotNull
    private final SocketAddress udpSocketAddress;
    @Nullable
    private final InetSocketAddress tcpSocketAddress;
    public static final int DEFAULT_PORT = 30303;

    public Endpoint(@NotNull String address, int udpPort, @Nullable Integer tcpPort) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address = address;
        this.udpPort = udpPort;
        this.tcpPort = tcpPort;
        int n = this.udpPort;
        if (!(1 <= n ? n < 65536 : false)) {
            boolean $i$a$-require-Endpoint$32 = false;
            String $i$a$-require-Endpoint$32 = "udpPort should be between 1 and 65535, got " + this.getUdpPort();
            throw new IllegalArgumentException($i$a$-require-Endpoint$32.toString());
        }
        if (!(this.tcpPort == null || new IntRange(1, 65535).contains(this.tcpPort.intValue()))) {
            boolean bl = false;
            String string = "tcpPort should be between 1 and 65535, got " + this.getTcpPort();
            throw new IllegalArgumentException(string.toString());
        }
        SocketAddress socketAddress = SocketAddress.inetSocketAddress((int)this.udpPort, (String)this.address);
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"inetSocketAddress(udpPort, address)");
        this.udpSocketAddress = socketAddress;
        this.tcpSocketAddress = this.tcpPort != null ? new InetSocketAddress(this.address, (int)this.tcpPort) : null;
    }

    public /* synthetic */ Endpoint(String string, int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 30303;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        this(string, n, n2);
    }

    @NotNull
    public final String getAddress() {
        return this.address;
    }

    public final int getUdpPort() {
        return this.udpPort;
    }

    @Nullable
    public final Integer getTcpPort() {
        return this.tcpPort;
    }

    public Endpoint(@NotNull SocketAddress address, @Nullable Integer tcpPort) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String string = address.host();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.host()");
        this(string, address.port(), tcpPort);
    }

    public /* synthetic */ Endpoint(SocketAddress socketAddress, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(socketAddress, n);
    }

    @NotNull
    public final SocketAddress getUdpSocketAddress() {
        return this.udpSocketAddress;
    }

    @Nullable
    public final InetSocketAddress getTcpSocketAddress() {
        return this.tcpSocketAddress;
    }

    public final void writeTo$devp2p(@NotNull RLPWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.writeByteArray(InetAddress.getByName(this.address).getAddress());
        writer.writeInt(this.udpPort);
        Integer n = this.tcpPort;
        writer.writeInt(n == null ? 0 : n);
    }

    public final int rlpSize$devp2p() {
        return 1 + InetAddress.getByName(this.address).getAddress().length + 6;
    }

    @NotNull
    public final String component1() {
        return this.address;
    }

    public final int component2() {
        return this.udpPort;
    }

    @Nullable
    public final Integer component3() {
        return this.tcpPort;
    }

    @NotNull
    public final Endpoint copy(@NotNull String address, int udpPort, @Nullable Integer tcpPort) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return new Endpoint(address, udpPort, tcpPort);
    }

    public static /* synthetic */ Endpoint copy$default(Endpoint endpoint, String string, int n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = endpoint.address;
        }
        if ((n3 & 2) != 0) {
            n = endpoint.udpPort;
        }
        if ((n3 & 4) != 0) {
            n2 = endpoint.tcpPort;
        }
        return endpoint.copy(string, n, n2);
    }

    @NotNull
    public String toString() {
        return "Endpoint(address=" + this.address + ", udpPort=" + this.udpPort + ", tcpPort=" + this.tcpPort + ")";
    }

    public int hashCode() {
        int result2 = this.address.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.udpPort);
        result2 = result2 * 31 + (this.tcpPort == null ? 0 : ((Object)this.tcpPort).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)other;
        if (!Intrinsics.areEqual((Object)this.address, (Object)endpoint.address)) {
            return false;
        }
        if (this.udpPort != endpoint.udpPort) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tcpPort, (Object)endpoint.tcpPort);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/apache/tuweni/devp2p/Endpoint$Companion;", "", "()V", "DEFAULT_PORT", "", "readFrom", "Lorg/apache/tuweni/devp2p/Endpoint;", "reader", "Lorg/apache/tuweni/rlp/RLPReader;", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Endpoint readFrom(@NotNull RLPReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            InetAddress addr = null;
            try {
                InetAddress inetAddress = InetAddress.getByAddress(reader.readValue().toArrayUnsafe());
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(reader.readValue().toArrayUnsafe())");
                addr = inetAddress;
            }
            catch (UnknownHostException e) {
                throw new RLPException((Throwable)e);
            }
            int udpPort = reader.readInt();
            if (udpPort == 0) {
                udpPort = 30303;
            }
            Integer tcpPort = null;
            if (!reader.isComplete()) {
                tcpPort = reader.readInt();
                boolean bl = false;
                if (tcpPort == 0) {
                    tcpPort = null;
                }
            }
            String string = addr.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addr.hostAddress");
            return new Endpoint(string, udpPort, tcpPort);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

