/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc.methods;

import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tuweni.eth.JSONRPCRequest;
import org.apache.tuweni.eth.JSONRPCResponse;
import org.apache.tuweni.eth.JSONRPCResponseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B:\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\"\u0010\u0005\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0005\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lorg/apache/tuweni/jsonrpc/methods/MethodAllowListHandler;", "", "allowedMethods", "", "", "delegateHandler", "Lkotlin/Function2;", "Lorg/apache/tuweni/eth/JSONRPCRequest;", "Lkotlin/coroutines/Continuation;", "Lorg/apache/tuweni/eth/JSONRPCResponse;", "(Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "Lkotlin/jvm/functions/Function2;", "handleRequest", "request", "(Lorg/apache/tuweni/eth/JSONRPCRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jsonrpc"})
public final class MethodAllowListHandler {
    @NotNull
    private final List<String> allowedMethods;
    @NotNull
    private final Function2<JSONRPCRequest, Continuation<? super JSONRPCResponse>, Object> delegateHandler;

    public MethodAllowListHandler(@NotNull List<String> allowedMethods, @NotNull Function2<? super JSONRPCRequest, ? super Continuation<? super JSONRPCResponse>, ? extends Object> delegateHandler) {
        Intrinsics.checkNotNullParameter(allowedMethods, (String)"allowedMethods");
        Intrinsics.checkNotNullParameter(delegateHandler, (String)"delegateHandler");
        this.allowedMethods = allowedMethods;
        this.delegateHandler = delegateHandler;
    }

    @Nullable
    public final Object handleRequest(@NotNull JSONRPCRequest request, @NotNull Continuation<? super JSONRPCResponse> $completion) {
        boolean found = false;
        for (String method : this.allowedMethods) {
            if (!StringsKt.startsWith$default((String)request.getMethod(), (String)method, (boolean)false, (int)2, null)) continue;
            found = true;
            break;
        }
        if (!found) {
            return JSONRPCResponse.copy$default((JSONRPCResponse)JSONRPCResponseKt.getMethodNotEnabled(), (int)request.getId(), null, null, null, (int)14, null);
        }
        return this.delegateHandler.invoke((Object)request, $completion);
    }
}

