/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.eth.JSONRPCRequest;
import org.apache.tuweni.eth.JSONRPCResponse;
import org.apache.tuweni.eth.JSONRPCResponseKt;
import org.apache.tuweni.jsonrpc.JSONRPCServer;
import org.apache.tuweni.jsonrpc.JSONRPCUser;
import org.apache.tuweni.net.ip.IPRangeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 <2\u00020\u0001:\u0001<B\u00a6\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\"\u0010\u0016\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0017\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a052\u0006\u00106\u001a\u00020\u0018H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0006\u0010\u0004\u001a\u00020\u0005J\u0011\u00108\u001a\u000209H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0011\u0010;\u001a\u000209H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:R\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R2\u0010\u0016\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0017\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010)\u001a\u0004\b'\u0010(R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lorg/apache/tuweni/jsonrpc/JSONRPCServer;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "port", "", "networkInterface", "", "ssl", "", "trustOptions", "Lio/vertx/core/net/TrustOptions;", "useBasicAuthentication", "basicAuthenticationUsername", "basicAuthenticationPassword", "basicAuthRealm", "ipRangeChecker", "Lorg/apache/tuweni/net/ip/IPRangeChecker;", "openTelemetry", "Lio/opentelemetry/api/OpenTelemetry;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "methodHandler", "Lkotlin/Function2;", "Lorg/apache/tuweni/eth/JSONRPCRequest;", "Lkotlin/coroutines/Continuation;", "Lorg/apache/tuweni/eth/JSONRPCResponse;", "", "(Lio/vertx/core/Vertx;ILjava/lang/String;ZLio/vertx/core/net/TrustOptions;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/apache/tuweni/net/ip/IPRangeChecker;Lio/opentelemetry/api/OpenTelemetry;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function2;)V", "getBasicAuthRealm", "()Ljava/lang/String;", "getBasicAuthenticationPassword", "getBasicAuthenticationUsername", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "httpServer", "Lio/vertx/core/http/HttpServer;", "getIpRangeChecker", "()Lorg/apache/tuweni/net/ip/IPRangeChecker;", "getMethodHandler", "()Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function2;", "getNetworkInterface", "getOpenTelemetry", "()Lio/opentelemetry/api/OpenTelemetry;", "getSsl", "()Z", "getTrustOptions", "()Lio/vertx/core/net/TrustOptions;", "getUseBasicAuthentication", "getVertx", "()Lio/vertx/core/Vertx;", "handleRequest", "Lkotlinx/coroutines/Deferred;", "request", "(Lorg/apache/tuweni/eth/JSONRPCRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "Companion", "jsonrpc"})
public final class JSONRPCServer
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    private final int port;
    @NotNull
    private final String networkInterface;
    private final boolean ssl;
    @Nullable
    private final TrustOptions trustOptions;
    private final boolean useBasicAuthentication;
    @Nullable
    private final String basicAuthenticationUsername;
    @Nullable
    private final String basicAuthenticationPassword;
    @NotNull
    private final String basicAuthRealm;
    @NotNull
    private final IPRangeChecker ipRangeChecker;
    @NotNull
    private final OpenTelemetry openTelemetry;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final Function2<JSONRPCRequest, Continuation<? super JSONRPCResponse>, Object> methodHandler;
    @Nullable
    private HttpServer httpServer;
    private static final Logger logger = LoggerFactory.getLogger(JSONRPCServer.class);
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    public JSONRPCServer(@NotNull Vertx vertx, int port, @NotNull String networkInterface, boolean ssl, @Nullable TrustOptions trustOptions, boolean useBasicAuthentication, @Nullable String basicAuthenticationUsername, @Nullable String basicAuthenticationPassword, @NotNull String basicAuthRealm, @NotNull IPRangeChecker ipRangeChecker, @NotNull OpenTelemetry openTelemetry, @NotNull CoroutineContext coroutineContext, @NotNull Function2<? super JSONRPCRequest, ? super Continuation<? super JSONRPCResponse>, ? extends Object> methodHandler) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)basicAuthRealm, (String)"basicAuthRealm");
        Intrinsics.checkNotNullParameter((Object)ipRangeChecker, (String)"ipRangeChecker");
        Intrinsics.checkNotNullParameter((Object)openTelemetry, (String)"openTelemetry");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter(methodHandler, (String)"methodHandler");
        this.vertx = vertx;
        this.port = port;
        this.networkInterface = networkInterface;
        this.ssl = ssl;
        this.trustOptions = trustOptions;
        this.useBasicAuthentication = useBasicAuthentication;
        this.basicAuthenticationUsername = basicAuthenticationUsername;
        this.basicAuthenticationPassword = basicAuthenticationPassword;
        this.basicAuthRealm = basicAuthRealm;
        this.ipRangeChecker = ipRangeChecker;
        this.openTelemetry = openTelemetry;
        this.coroutineContext = coroutineContext;
        this.methodHandler = methodHandler;
        if (this.useBasicAuthentication) {
            if (this.basicAuthenticationUsername == null) {
                throw new IllegalArgumentException("Cannot use basic authentication without specifying a username");
            }
            if (this.basicAuthenticationPassword == null) {
                throw new IllegalArgumentException("Cannot use basic authentication without specifying a password");
            }
        }
    }

    public /* synthetic */ JSONRPCServer(Vertx vertx, int n, String string, boolean bl, TrustOptions trustOptions, boolean bl2, String string2, String string3, String string4, IPRangeChecker iPRangeChecker, OpenTelemetry openTelemetry, CoroutineContext coroutineContext, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        IPRangeChecker iPRangeChecker2;
        if ((n2 & 4) != 0) {
            string = "127.0.0.1";
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            trustOptions = null;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            string2 = null;
        }
        if ((n2 & 0x80) != 0) {
            string3 = null;
        }
        if ((n2 & 0x100) != 0) {
            string4 = "Apache Tuweni JSON-RPC proxy";
        }
        if ((n2 & 0x200) != 0) {
            iPRangeChecker2 = IPRangeChecker.allowAll();
            Intrinsics.checkNotNullExpressionValue((Object)iPRangeChecker2, (String)"allowAll()");
            iPRangeChecker = iPRangeChecker2;
        }
        if ((n2 & 0x400) != 0) {
            iPRangeChecker2 = OpenTelemetry.noop();
            Intrinsics.checkNotNullExpressionValue((Object)iPRangeChecker2, (String)"noop()");
            openTelemetry = iPRangeChecker2;
        }
        if ((n2 & 0x800) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(vertx, n, string, bl, trustOptions, bl2, string2, string3, string4, iPRangeChecker, openTelemetry, coroutineContext, (Function2<? super JSONRPCRequest, ? super Continuation<? super JSONRPCResponse>, ? extends Object>)function2);
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    public final boolean getSsl() {
        return this.ssl;
    }

    @Nullable
    public final TrustOptions getTrustOptions() {
        return this.trustOptions;
    }

    public final boolean getUseBasicAuthentication() {
        return this.useBasicAuthentication;
    }

    @Nullable
    public final String getBasicAuthenticationUsername() {
        return this.basicAuthenticationUsername;
    }

    @Nullable
    public final String getBasicAuthenticationPassword() {
        return this.basicAuthenticationPassword;
    }

    @NotNull
    public final String getBasicAuthRealm() {
        return this.basicAuthRealm;
    }

    @NotNull
    public final IPRangeChecker getIpRangeChecker() {
        return this.ipRangeChecker;
    }

    @NotNull
    public final OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final Function2<JSONRPCRequest, Continuation<? super JSONRPCResponse>, Object> getMethodHandler() {
        return this.methodHandler;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRPCServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                serverOptions = new HttpServerOptions().setPort(this.port).setHost(this.getNetworkInterface()).setSsl(this.getSsl()).setTracingPolicy(TracingPolicy.ALWAYS);
                v0 = this.getTrustOptions();
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-JSONRPCServer$start$2 = false;
                    serverOptions.setTrustOptions(it);
                }
                v1 = this.httpServer = this.getVertx().createHttpServer(serverOptions);
                if (v1 != null) {
                    v1.connectionHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, start$lambda-1(org.apache.tuweni.jsonrpc.JSONRPCServer io.vertx.core.http.HttpConnection ), (Lio/vertx/core/http/HttpConnection;)V)((JSONRPCServer)this));
                }
                v2 = this.httpServer;
                if (v2 != null) {
                    v2.exceptionHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, start$lambda-2(java.lang.Throwable ), (Ljava/lang/Throwable;)V)());
                }
                router = Router.router((Vertx)this.getVertx());
                if (this.getUseBasicAuthentication()) {
                    router.route().handler((Handler)SessionHandler.create((SessionStore)((SessionStore)LocalSessionStore.create((Vertx)this.getVertx()))));
                    basicAuthHandler = BasicAuthHandler.create((AuthenticationProvider)(AuthenticationProvider)LambdaMetafactory.metafactory(null, null, null, (Lio/vertx/core/json/JsonObject;Lio/vertx/core/Handler;)V, start$lambda-3(org.apache.tuweni.jsonrpc.JSONRPCServer io.vertx.core.json.JsonObject io.vertx.core.Handler ), (Lio/vertx/core/json/JsonObject;Lio/vertx/core/Handler;)V)((JSONRPCServer)this), (String)this.getBasicAuthRealm());
                    router.route().handler((Handler)basicAuthHandler);
                }
                router.route().handler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, start$lambda-6(org.apache.tuweni.jsonrpc.JSONRPCServer io.vertx.ext.web.RoutingContext ), (Lio/vertx/ext/web/RoutingContext;)V)((JSONRPCServer)this));
                v3 = this.httpServer;
                if (v3 != null) {
                    v3.requestHandler((Handler)router);
                }
                v4 = this.httpServer;
                if (v4 == null) ** GOTO lbl57
                v5 = v4.listen();
                if (v5 == null) ** GOTO lbl57
                $continuation.L$0 = this;
                $continuation.label = 1;
                v6 = VertxCoroutineKt.await((Future)v5, (Continuation)$continuation);
                if (v6 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl55
            }
            case 1: {
                this = (JSONRPCServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl55:
                // 2 sources

                (HttpServer)v6;
lbl57:
                // 3 sources

                JSONRPCServer.logger.info("Started JSON-RPC server on " + this.getNetworkInterface() + ":" + this.port());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handleRequest(JSONRPCRequest request, Continuation<? super Deferred<JSONRPCResponse>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Deferred<? extends JSONRPCResponse>>, Object>(this, request, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JSONRPCServer this$0;
            final /* synthetic */ JSONRPCRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        return BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSONRPCResponse>, Object>(this.this$0, this.$request, null){
                            int label;
                            final /* synthetic */ JSONRPCServer this$0;
                            final /* synthetic */ JSONRPCRequest $request;
                            {
                                this.this$0 = $receiver;
                                this.$request = $request;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.this$0.getMethodHandler().invoke((Object)this.$request, (Object)((Object)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super JSONRPCResponse> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Deferred<JSONRPCResponse>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        Object v1;
        HttpServer httpServer = this.httpServer;
        if (httpServer == null) {
            v1 = null;
        } else {
            Future future = httpServer.close();
            if (future == null) {
                v1 = null;
            } else {
                Object object = VertxCoroutineKt.await((Future)future, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return v1;
        }
        return Unit.INSTANCE;
    }

    public final int port() {
        HttpServer httpServer = this.httpServer;
        Integer n = httpServer == null ? null : Integer.valueOf(httpServer.actualPort());
        return n == null ? this.port : n;
    }

    private static final void start$lambda-1(JSONRPCServer this$0, HttpConnection it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String remoteAddress = it.remoteAddress().hostAddress();
        if (!this$0.ipRangeChecker.check(remoteAddress)) {
            logger.debug("Rejecting IP {}", (Object)remoteAddress);
            it.close();
        }
    }

    private static final void start$lambda-2(Throwable it) {
        logger.error(it.getMessage(), it);
    }

    private static final void start$lambda-3(JSONRPCServer this$0, JsonObject authInfo, Handler resultHandler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Intrinsics.areEqual((Object)this$0.basicAuthenticationUsername, (Object)authInfo.getString("username")) && Intrinsics.areEqual((Object)this$0.basicAuthenticationPassword, (Object)authInfo.getString("password"))) {
            Intrinsics.checkNotNullExpressionValue((Object)authInfo, (String)"authInfo");
            resultHandler.handle((Object)Future.succeededFuture((Object)new JSONRPCUser(authInfo)));
        } else {
            resultHandler.handle((Object)Future.failedFuture((String)"Invalid credentials"));
        }
    }

    private static final void start$lambda-6$lambda-4(HttpServerRequest $httpRequest, Span $span, Throwable it) {
        logger.error(it.getMessage(), it);
        $httpRequest.response().end(mapper.writeValueAsString((Object)JSONRPCResponseKt.getInternalError()));
        $span.setStatus(StatusCode.ERROR);
        $span.end();
    }

    private static final void start$lambda-6$lambda-5(HttpServerRequest $httpRequest, Span $span, JSONRPCServer this$0, Buffer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Ref.ObjectRef requests = new Ref.ObjectRef();
        try {
            Object object = mapper.readerFor(JSONRPCRequest[].class).readValue(it.getBytes());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readerFor(Array<J\u2026java).readValue(it.bytes)");
            requests.element = object;
        }
        catch (IOException e) {
            try {
                JSONRPCRequest[] jSONRPCRequestArray = new JSONRPCRequest[1];
                Object object = mapper.readerFor(JSONRPCRequest.class).readValue(it.getBytes());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readerFor(JSONRPC\u2026java).readValue(it.bytes)");
                jSONRPCRequestArray[0] = (JSONRPCRequest)object;
                requests.element = jSONRPCRequestArray;
            }
            catch (IOException e2) {
                logger.warn("Invalid request", (Throwable)e2);
                $httpRequest.response().end(mapper.writeValueAsString((Object)JSONRPCResponseKt.getParseError()));
                $span.setStatus(StatusCode.ERROR);
                $span.end();
                return;
            }
        }
        BuildersKt.launch$default((CoroutineScope)this$0, (CoroutineContext)((CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)this$0.vertx)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<JSONRPCRequest[]>)requests, this$0, $httpRequest, $span, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ Ref.ObjectRef<JSONRPCRequest[]> $requests;
            final /* synthetic */ JSONRPCServer this$0;
            final /* synthetic */ HttpServerRequest $httpRequest;
            final /* synthetic */ Span $span;
            {
                this.$requests = $requests;
                this.this$0 = $receiver;
                this.$httpRequest = $httpRequest;
                this.$span = $span;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        responses = new ArrayList<E>();
                        var3_4 = (JSONRPCRequest[])this.$requests.element;
                        var4_5 = 0;
                        var5_6 = var3_4.length;
lbl9:
                        // 2 sources

                        while (var4_5 < var5_6) {
                            request = var3_4[var4_5];
                            JSONRPCServer.Companion.getLogger().trace("Request {}", (Object)request);
                            var7_8 = responses;
                            this.L$0 = responses;
                            this.L$1 = var3_4;
                            this.L$2 = var7_8;
                            this.I$0 = ++var4_5;
                            this.I$1 = var5_6;
                            this.label = 1;
                            v0 = JSONRPCServer.access$handleRequest(this.this$0, request, (Continuation)this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl32
                        }
                        break;
                    }
                    case 1: {
                        var5_6 = this.I$1;
                        var4_5 = this.I$0;
                        var7_8 = (List)this.L$2;
                        var3_4 = (JSONRPCRequest[])this.L$1;
                        responses = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        var7_8.add(v0);
                        ** GOTO lbl9
                    }
                }
                this.L$0 = null;
                this.L$1 = null;
                this.L$2 = null;
                this.label = 2;
                v1 = AwaitKt.awaitAll((Collection)responses, (Continuation)((Continuation)this));
                if (v1 == var8_2) {
                    return var8_2;
                }
                ** GOTO lbl46
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl46:
                        // 2 sources

                        if ((readyResponses = (List)v1).size() == 1) {
                            this.$httpRequest.response().end(JSONRPCServer.Companion.getMapper().writeValueAsString(readyResponses.get(0)));
                        } else {
                            this.$httpRequest.response().end(JSONRPCServer.Companion.getMapper().writeValueAsString((Object)readyResponses));
                        }
                        this.$span.end();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final void start$lambda-6(JSONRPCServer this$0, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Tracer tracer = this$0.openTelemetry.getTracer("jsonrpcserver");
        Span span = tracer.spanBuilder("handleRequest").setSpanKind(SpanKind.SERVER).startSpan();
        HttpServerRequest httpRequest = context.request();
        httpRequest.exceptionHandler(arg_0 -> JSONRPCServer.start$lambda-6$lambda-4(httpRequest, span, arg_0));
        httpRequest.bodyHandler(arg_0 -> JSONRPCServer.start$lambda-6$lambda-5(httpRequest, span, this$0, arg_0));
    }

    public static final /* synthetic */ Object access$handleRequest(JSONRPCServer $this, JSONRPCRequest request, Continuation $completion) {
        return $this.handleRequest(request, (Continuation<? super Deferred<JSONRPCResponse>>)$completion);
    }

    static {
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/jsonrpc/JSONRPCServer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jsonrpc"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

