/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.DelegatingBytes32;

public final class Hash
extends DelegatingBytes32 {
    public static Hash fromBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.size() == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)bytes.size());
        return new Hash((Bytes)Bytes32.wrap((Bytes)bytes));
    }

    public static Hash fromBytes(Bytes32 bytes) {
        return new Hash((Bytes)bytes);
    }

    private Hash(Bytes delegate) {
        super(delegate);
    }

    public static Hash fromHexString(String str) {
        return new Hash((Bytes)Bytes32.fromHexStringLenient((CharSequence)str));
    }

    public static Hash hash(Bytes value) {
        return new Hash((Bytes)org.apache.tuweni.crypto.Hash.keccak256((Bytes)value));
    }
}

