/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.discovery;

import com.google.common.net.InetAddresses;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Identity;

public final class LocalIdentity {
    private static final Pattern regexpPattern = Pattern.compile("^net:(.*):(.*)~shs:(.*)$");
    private final Identity id;
    private final InetSocketAddress addr;

    public static LocalIdentity fromString(String str) {
        Matcher result = regexpPattern.matcher(str);
        if (!result.matches()) {
            return null;
        }
        return new LocalIdentity(result.group(1), result.group(2), Identity.fromPublicKey((Signature.PublicKey)Signature.PublicKey.fromBytes((Bytes)Bytes.fromBase64String((CharSequence)result.group(3)))));
    }

    public LocalIdentity(String ip, String port, Identity id) {
        this(ip, Integer.valueOf(port), id);
    }

    public LocalIdentity(String ip, int port, Identity id) {
        this(new InetSocketAddress(ip, port), id);
    }

    public LocalIdentity(InetSocketAddress addr, Identity id) {
        InetAddresses.forString((String)addr.getHostString());
        this.addr = addr;
        this.id = id;
    }

    public String toCanonicalForm() {
        return "net:" + this.addr.getHostString() + ":" + this.addr.getPort() + "~shs:" + this.id.publicKeyAsBase64String();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalIdentity that = (LocalIdentity)o;
        return this.toCanonicalForm().equals(that.toCanonicalForm());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.addr);
    }

    public String toString() {
        return this.toCanonicalForm();
    }
}

