/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public final class RLPxMessage {
    private final int messageId;
    private final Bytes content;
    private final int bytesLength;

    public RLPxMessage(int messageId, Bytes content) {
        this(messageId, content, 0);
    }

    RLPxMessage(int messageId, Bytes content, int bytesLength) {
        this.messageId = messageId;
        this.content = content;
        this.bytesLength = bytesLength;
    }

    int bytesLength() {
        return this.bytesLength;
    }

    public Bytes content() {
        return this.content;
    }

    public int messageId() {
        return this.messageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RLPxMessage that = (RLPxMessage)o;
        return this.messageId == that.messageId && Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.messageId, this.content);
    }
}

