/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tuweni.rlpx.WireConnectionRepository;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;
import org.apache.tuweni.rlpx.wire.WireConnection;

public class MemoryWireConnectionsRepository
implements WireConnectionRepository {
    private final Map<String, WireConnection> connections = new ConcurrentHashMap<String, WireConnection>();
    private final List<WireConnectionRepository.Listener> connectionListeners = new ArrayList<WireConnectionRepository.Listener>();
    private final List<WireConnectionRepository.Listener> disconnectionListeners = new ArrayList<WireConnectionRepository.Listener>();

    @Override
    public String add(WireConnection wireConnection) {
        String id = UUID.randomUUID().toString();
        this.connections.put(id, wireConnection);
        wireConnection.registerListener(event -> {
            block3: {
                block2: {
                    if (event != WireConnection.Event.CONNECTED) break block2;
                    for (WireConnectionRepository.Listener listener : this.connectionListeners) {
                        listener.connectionEvent(wireConnection);
                    }
                    break block3;
                }
                if (event != WireConnection.Event.DISCONNECTED) break block3;
                this.connections.remove(id);
                for (WireConnectionRepository.Listener listener : this.disconnectionListeners) {
                    listener.connectionEvent(wireConnection);
                }
            }
        });
        return id;
    }

    @Override
    public WireConnection get(String id) {
        return this.connections.get(id);
    }

    @Override
    public Iterable<WireConnection> asIterable() {
        return this.connections.values();
    }

    @Override
    public Iterable<WireConnection> asIterable(SubProtocolIdentifier identifier) {
        return this.connections.values().stream().filter(conn -> conn.supports(identifier)).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.connections.clear();
    }

    public Map<String, WireConnection> asMap() {
        return this.connections;
    }

    @Override
    public void addConnectionListener(WireConnectionRepository.Listener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void addDisconnectionListener(WireConnectionRepository.Listener listener) {
        this.disconnectionListeners.add(listener);
    }
}

