/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.plumtree.vertx;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.plumtree.MessageHashing;
import org.apache.tuweni.plumtree.MessageListener;
import org.apache.tuweni.plumtree.MessageSender;
import org.apache.tuweni.plumtree.MessageValidator;
import org.apache.tuweni.plumtree.Peer;
import org.apache.tuweni.plumtree.PeerPruning;
import org.apache.tuweni.plumtree.PeerRepository;
import org.apache.tuweni.plumtree.State;
import org.apache.tuweni.plumtree.vertx.SocketPeer;

public final class VertxGossipServer {
    private static final ObjectMapper mapper = new ObjectMapper();
    private NetClient client;
    private final int graftDelay;
    private final int lazyQueueInterval;
    private final MessageHashing messageHashing;
    private final String networkInterface;
    private final MessageListener payloadListener;
    private final MessageValidator payloadValidator;
    private final PeerPruning peerPruningFunction;
    private final PeerRepository peerRepository;
    private final int port;
    private NetServer server;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private State state;
    private final Vertx vertx;

    public VertxGossipServer(Vertx vertx, String networkInterface, int port, MessageHashing messageHashing, PeerRepository peerRepository, MessageListener payloadListener, @Nullable MessageValidator payloadValidator, @Nullable PeerPruning peerPruningFunction, int graftDelay, int lazyQueueInterval) {
        this.vertx = vertx;
        this.networkInterface = networkInterface;
        this.port = port;
        this.messageHashing = messageHashing;
        this.peerRepository = peerRepository;
        this.payloadListener = payloadListener;
        this.payloadValidator = payloadValidator == null ? (bytes, peer) -> true : payloadValidator;
        this.peerPruningFunction = peerPruningFunction == null ? peer -> true : peerPruningFunction;
        this.graftDelay = graftDelay;
        this.lazyQueueInterval = lazyQueueInterval;
    }

    public AsyncCompletion start() {
        if (this.started.compareAndSet(false, true)) {
            CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
            this.server = this.vertx.createNetServer();
            this.client = this.vertx.createNetClient();
            this.server.connectHandler(socket -> {
                SocketPeer peer = new SocketPeer((NetSocket)socket);
                SocketHandler handler = new SocketHandler(peer);
                socket.handler(handler::handle).closeHandler(handler::close).exceptionHandler(Throwable::printStackTrace);
            });
            this.server.exceptionHandler(Throwable::printStackTrace);
            this.server.listen(this.port, this.networkInterface, res -> {
                if (res.failed()) {
                    completion.completeExceptionally(res.cause());
                } else {
                    this.state = new State(this.peerRepository, this.messageHashing, (verb, attributes, peer, hash, payload) -> this.vertx.executeBlocking(future -> {
                        Message message = new Message();
                        message.verb = verb;
                        message.attributes = attributes;
                        message.hash = hash.toHexString();
                        message.payload = payload == null ? null : payload.toHexString();
                        try {
                            ((SocketPeer)peer).socket().write((Object)Buffer.buffer((byte[])mapper.writeValueAsBytes((Object)message)));
                            future.complete();
                        }
                        catch (JsonProcessingException e) {
                            future.fail((Throwable)e);
                        }
                    }, done -> {}), this.payloadListener, this.payloadValidator, this.peerPruningFunction, this.graftDelay, this.lazyQueueInterval);
                    completion.complete();
                }
            });
            return completion;
        }
        return AsyncCompletion.completed();
    }

    public AsyncCompletion stop() {
        if (this.started.compareAndSet(true, false)) {
            CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
            this.state.stop();
            this.client.close();
            this.server.close(res -> {
                if (res.failed()) {
                    completion.completeExceptionally(res.cause());
                } else {
                    completion.complete();
                }
            });
            return completion;
        }
        return AsyncCompletion.completed();
    }

    public AsyncCompletion connectTo(String host, int port) {
        if (!this.started.get()) {
            throw new IllegalStateException("Server has not started");
        }
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        AtomicInteger counter = new AtomicInteger(0);
        this.roundConnect(host, port, counter, completion);
        return completion;
    }

    private void roundConnect(String host, int port, AtomicInteger counter, CompletableAsyncCompletion completion) {
        this.client.connect(port, host, res -> {
            if (res.failed()) {
                if (counter.incrementAndGet() > 5) {
                    completion.completeExceptionally(res.cause());
                } else {
                    this.roundConnect(host, port, counter, completion);
                }
            } else {
                SocketPeer peer = new SocketPeer((NetSocket)res.result());
                SocketHandler handler = new SocketHandler(peer);
                ((NetSocket)res.result()).handler(handler::handle).closeHandler(handler::close);
                completion.complete();
            }
        });
    }

    public void gossip(String attributes, Bytes message) {
        if (!this.started.get()) {
            throw new IllegalStateException("Server has not started");
        }
        this.state.sendGossipMessage(attributes, message);
    }

    private final class SocketHandler {
        private final Peer peer;
        private Bytes buffer = Bytes.EMPTY;

        SocketHandler(Peer peer) {
            this.peer = peer;
            VertxGossipServer.this.state.addPeer(peer);
        }

        void handle(Buffer data) {
            this.buffer = Bytes.concatenate((Bytes[])new Bytes[]{this.buffer, Bytes.wrapBuffer((Buffer)data)});
            while (!this.buffer.isEmpty()) {
                Message message;
                try {
                    JsonParser parser = mapper.getFactory().createParser(this.buffer.toArrayUnsafe());
                    message = (Message)parser.readValueAs(Message.class);
                    this.buffer = this.buffer.slice((int)parser.getCurrentLocation().getByteOffset());
                }
                catch (IOException e) {
                    return;
                }
                switch (message.verb) {
                    case IHAVE: {
                        VertxGossipServer.this.state.receiveIHaveMessage(this.peer, Bytes.fromHexString((CharSequence)message.hash));
                        break;
                    }
                    case GOSSIP: {
                        VertxGossipServer.this.state.receiveGossipMessage(this.peer, message.attributes, Bytes.fromHexString((CharSequence)message.payload), Bytes.fromHexString((CharSequence)message.hash));
                        break;
                    }
                    case GRAFT: {
                        VertxGossipServer.this.state.receiveGraftMessage(this.peer, Bytes.fromHexString((CharSequence)message.payload));
                        break;
                    }
                    case PRUNE: {
                        VertxGossipServer.this.state.receivePruneMessage(this.peer);
                    }
                }
            }
        }

        void close(Void aVoid) {
            VertxGossipServer.this.state.removePeer(this.peer);
        }
    }

    private static final class Message {
        public MessageSender.Verb verb;
        public String attributes;
        public String hash;
        public String payload;

        private Message() {
        }
    }
}

