/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.eth.genesis.GenesisFile;
import org.apache.tuweni.ethclient.GenesisFileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/apache/tuweni/ethclient/GenesisFileConfigurationImpl;", "Lorg/apache/tuweni/ethclient/GenesisFileConfiguration;", "name", "", "genesisFilePath", "Ljava/net/URI;", "(Ljava/lang/String;Ljava/net/URI;)V", "component1", "component2", "copy", "equals", "", "other", "", "genesisFile", "Lorg/apache/tuweni/eth/genesis/GenesisFile;", "getName", "hashCode", "", "toString", "eth-client"})
public final class GenesisFileConfigurationImpl
implements GenesisFileConfiguration {
    @NotNull
    private final String name;
    @NotNull
    private final URI genesisFilePath;

    public GenesisFileConfigurationImpl(@NotNull String name, @NotNull URI genesisFilePath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)genesisFilePath, (String)"genesisFilePath");
        this.name = name;
        this.genesisFilePath = genesisFilePath;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GenesisFile genesisFile() {
        byte[] byArray;
        if (Intrinsics.areEqual((Object)this.genesisFilePath.getScheme(), (Object)"classpath")) {
            URL uRL = GenesisFileConfigurationImpl.class.getResource(this.genesisFilePath.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"GenesisFileConfiguration\u2026rce(genesisFilePath.path)");
            byArray = TextStreamsKt.readBytes((URL)uRL);
        } else {
            byArray = Files.readAllBytes(Path.of(this.genesisFilePath));
        }
        GenesisFile genesisFile = GenesisFile.read((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)genesisFile, (String)"read(\n      if (genesisF\u2026sFilePath))\n      }\n    )");
        return genesisFile;
    }

    private final String component1() {
        return this.name;
    }

    private final URI component2() {
        return this.genesisFilePath;
    }

    @NotNull
    public final GenesisFileConfigurationImpl copy(@NotNull String name, @NotNull URI genesisFilePath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)genesisFilePath, (String)"genesisFilePath");
        return new GenesisFileConfigurationImpl(name, genesisFilePath);
    }

    public static /* synthetic */ GenesisFileConfigurationImpl copy$default(GenesisFileConfigurationImpl genesisFileConfigurationImpl, String string, URI uRI, int n, Object object) {
        if ((n & 1) != 0) {
            string = genesisFileConfigurationImpl.name;
        }
        if ((n & 2) != 0) {
            uRI = genesisFileConfigurationImpl.genesisFilePath;
        }
        return genesisFileConfigurationImpl.copy(string, uRI);
    }

    @NotNull
    public String toString() {
        return "GenesisFileConfigurationImpl(name=" + this.name + ", genesisFilePath=" + this.genesisFilePath + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.genesisFilePath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenesisFileConfigurationImpl)) {
            return false;
        }
        GenesisFileConfigurationImpl genesisFileConfigurationImpl = (GenesisFileConfigurationImpl)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)genesisFileConfigurationImpl.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.genesisFilePath, (Object)genesisFileConfigurationImpl.genesisFilePath);
    }
}

