/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc.app;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.PropertyValidator;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.SchemaBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\f\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\rJ*\u0010\u0010\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\rJ\u000e\u0010\u0011\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u000e\u0010\u0012\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u000e\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ*\u0010\u001a\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\rJ\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u000e\u0010\u001e\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u000e\u0010\u001f\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u0006\u0010#\u001a\u00020\u0015J\u0006\u0010$\u001a\u00020\u0017J\u000e\u0010%\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020\u0015J\u000e\u0010(\u001a\n \u0007*\u0004\u0018\u00010\u000e0\u000eJ\u0006\u0010)\u001a\u00020!J\u0006\u0010*\u001a\u00020!J*\u0010+\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\rJ\u0006\u0010,\u001a\u00020\u0015J\u0006\u0010-\u001a\u00020\u0015R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Lorg/apache/tuweni/jsonrpc/app/JSONRPCConfig;", "", "filePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "config", "Lorg/apache/tuweni/config/Configuration;", "kotlin.jvm.PlatformType", "getConfig", "()Lorg/apache/tuweni/config/Configuration;", "getFilePath", "()Ljava/nio/file/Path;", "allowedMethods", "", "", "", "allowedRanges", "basicAuthPassword", "basicAuthRealm", "basicAuthUsername", "cacheEnabled", "", "cacheLifespan", "", "cacheMaxIdle", "cacheStoragePath", "cachedMethods", "clientFingerprintsFile", "endpointBasicAuthEnabled", "endpointBasicAuthPassword", "endpointBasicAuthUsername", "endpointUrl", "maxConcurrentRequests", "", "metricsGrpcEndpoint", "metricsGrpcPushEnabled", "metricsGrpcTimeout", "metricsNetworkInterface", "metricsPort", "metricsPrometheusEnabled", "networkInterface", "numberOfThreads", "port", "rejectedRanges", "ssl", "useBasicAuthentication", "Companion", "jsonrpc-app"})
public final class JSONRPCConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path filePath;
    private final Configuration config;

    public JSONRPCConfig(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.config = Configuration.fromToml((Path)this.filePath, (Schema)Companion.schema());
    }

    @NotNull
    public final Path getFilePath() {
        return this.filePath;
    }

    public final Configuration getConfig() {
        return this.config;
    }

    public final int numberOfThreads() {
        return this.config.getInteger("numberOfThreads");
    }

    public final int metricsPort() {
        return this.config.getInteger("metricsPort");
    }

    public final String metricsNetworkInterface() {
        return this.config.getString("metricsNetworkInterface");
    }

    public final boolean metricsGrpcPushEnabled() {
        return this.config.getBoolean("metricsGrpcPushEnabled");
    }

    public final boolean metricsPrometheusEnabled() {
        return this.config.getBoolean("metricsPrometheusEnabled");
    }

    public final int port() {
        return this.config.getInteger("port");
    }

    public final String networkInterface() {
        return this.config.getString("networkInterface");
    }

    @NotNull
    public final Path clientFingerprintsFile() {
        Path path = Paths.get(this.config.getString("clientFingerprintsFile"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(config.getString(\"clientFingerprintsFile\"))");
        return path;
    }

    public final boolean ssl() {
        return this.config.getBoolean("ssl");
    }

    public final boolean useBasicAuthentication() {
        return this.config.getBoolean("basicAuth");
    }

    public final String basicAuthUsername() {
        return this.config.getString("basicAuthUsername");
    }

    public final String basicAuthPassword() {
        return this.config.getString("basicAuthPassword");
    }

    public final String basicAuthRealm() {
        return this.config.getString("basicAuthRealm");
    }

    public final List<String> allowedMethods() {
        return this.config.getListOfString("allowedMethods");
    }

    public final List<String> allowedRanges() {
        return this.config.getListOfString("allowedRanges");
    }

    public final List<String> rejectedRanges() {
        return this.config.getListOfString("rejectedRanges");
    }

    public final String endpointUrl() {
        return this.config.getString("endpointUrl");
    }

    public final boolean endpointBasicAuthEnabled() {
        return this.config.getBoolean("endpointBasicAuthEnabled");
    }

    public final String endpointBasicAuthUsername() {
        return this.config.getString("endpointBasicAuthUsername");
    }

    public final String endpointBasicAuthPassword() {
        return this.config.getString("endpointBasicAuthPassword");
    }

    public final List<String> cachedMethods() {
        return this.config.getListOfString("cachedMethods");
    }

    public final boolean cacheEnabled() {
        return this.config.getBoolean("cacheEnabled");
    }

    public final String cacheStoragePath() {
        return this.config.getString("cacheStoragePath");
    }

    public final int maxConcurrentRequests() {
        return this.config.getInteger("maxConcurrentRequests");
    }

    public final String metricsGrpcEndpoint() {
        return this.config.getString("metricsGrpcEndpoint");
    }

    public final long metricsGrpcTimeout() {
        return this.config.getLong("metricsGrpcTimeout");
    }

    public final long cacheLifespan() {
        return this.config.getLong("cacheLifespan");
    }

    public final long cacheMaxIdle() {
        return this.config.getLong("cacheMaxIdle");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/jsonrpc/app/JSONRPCConfig$Companion;", "", "()V", "schema", "Lorg/apache/tuweni/config/Schema;", "kotlin.jvm.PlatformType", "jsonrpc-app"})
    public static final class Companion {
        private Companion() {
        }

        public final Schema schema() {
            return SchemaBuilder.create().addInteger("numberOfThreads", Integer.valueOf(10), "Number of threads for each thread pool", null).addInteger("metricsPort", Integer.valueOf(9090), "Metric service port", PropertyValidator.isValidPort()).addString("metricsNetworkInterface", "localhost", "Metric service network interface", null).addBoolean("metricsGrpcPushEnabled", Boolean.valueOf(false), "Enable pushing metrics to gRPC service", null).addBoolean("metricsPrometheusEnabled", Boolean.valueOf(false), "Enable exposing metrics on the Prometheus endpoint", null).addInteger("port", Integer.valueOf(8545), "JSON-RPC server port", PropertyValidator.isValidPort()).addString("networkInterface", "127.0.0.1", "JSON-RPC server network interface", null).addString("clientFingerprintsFile", "fingerprints.txt", "File recording client connection fingerprints", null).addBoolean("ssl", Boolean.valueOf(false), "Whether the JSON-RPC server should serve data over SSL", null).addBoolean("basicAuth", Boolean.valueOf(false), "Whether the JSON-RPC server should authenticate incoming requests with HTTP Basic Authentication", null).addString("basicAuthUsername", "", "HTTP Basic Auth username", null).addString("basicAuthPassword", "", "HTTP Basic Auth password", null).addString("basicAuthRealm", "Apache Tuweni JSON-RPC proxy", "HTTP Basic Auth realm", null).addListOfString("allowedMethods", Collections.emptyList(), "Allowed JSON-RPC methods", null).addListOfString("allowedRanges", Collections.singletonList("0.0.0.0/0"), "Allowed IP ranges", null).addListOfString("rejectedRanges", Collections.emptyList(), "Rejected IP ranges", null).addString("endpointUrl", "http://localhost:8545", "JSON-RPC endpoint", null).addBoolean("endpointBasicAuthEnabled", Boolean.valueOf(false), "Enable basic authentication for the endpoint", null).addString("endpointBasicAuthUsername", "", "Basic authentication username for the endpoint", null).addString("endpointBasicAuthPassword", "", "Basic authentication password for the endpoint", null).addListOfString("cachedMethods", Collections.emptyList(), "Cached JSON-RPC methods", null).addBoolean("cacheEnabled", Boolean.valueOf(false), "Enable caching", null).addString("cacheStoragePath", "", "Location of cache storage", null).addInteger("maxConcurrentRequests", Integer.valueOf(30), "Maximum concurrent requests", null).addString("metricsGrpcEndpoint", "http://localhost:4317", "Metrics GRPC push endpoint", null).addLong("metricsGrpcTimeout", Long.valueOf(2000L), "Metrics GRPC push timeout", null).addLong("cacheLifespan", Long.valueOf(5000L), "Lifespan time for entries on cache in milliseconds", null).addLong("cacheMaxIdle", Long.valueOf(1000L), "Max idle time for entries on cache in milliseconds", null).toSchema();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

