/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlpx.InvalidMACException;
import org.apache.tuweni.rlpx.RLPxMessage;
import org.apache.tuweni.rlpx.wire.HelloMessage;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.KeccakDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public final class RLPxConnection {
    private static final Logger logger = LoggerFactory.getLogger(RLPxConnection.class);
    private final Bytes32 aesSecret;
    private final Bytes32 macSecret;
    private final Bytes32 token;
    private final KeccakDigest egressMac = new KeccakDigest(256);
    private final KeccakDigest ingressMac = new KeccakDigest(256);
    private final SECP256K1.PublicKey publicKey;
    private final SECP256K1.PublicKey peerPublicKey;
    private final AESEngine macEncryptionEngine;
    private final SICBlockCipher decryptionCipher;
    private final SICBlockCipher encryptionCipher;
    private boolean applySnappyCompression = false;
    private Bytes buffer = Bytes.EMPTY;
    private Integer lastFrameSize;

    public static boolean isComplementedBy(RLPxConnection one, RLPxConnection other) {
        return Objects.equals(one.aesSecret, other.aesSecret) && Objects.equals(one.macSecret, other.macSecret) && Objects.equals(one.token, other.token) && Objects.equals(RLPxConnection.snapshot(one.egressMac), RLPxConnection.snapshot(other.ingressMac)) && Objects.equals(RLPxConnection.snapshot(one.ingressMac), RLPxConnection.snapshot(other.egressMac));
    }

    private static Bytes32 snapshot(KeccakDigest digest) {
        byte[] out = new byte[32];
        new KeccakDigest(digest).doFinal(out, 0);
        return Bytes32.wrap((byte[])out);
    }

    RLPxConnection(Bytes32 aesSecret, Bytes32 macSecret, Bytes32 token, Bytes egressMac, Bytes ingressMac, SECP256K1.PublicKey publicKey, SECP256K1.PublicKey peerPublicKey) {
        this.aesSecret = aesSecret;
        this.macSecret = macSecret;
        this.token = token;
        KeyParameter macKey = new KeyParameter(macSecret.toArrayUnsafe());
        this.macEncryptionEngine = new AESEngine();
        this.macEncryptionEngine.init(true, (CipherParameters)macKey);
        this.updateEgress(egressMac);
        this.updateIngress(ingressMac);
        this.publicKey = publicKey;
        this.peerPublicKey = peerPublicKey;
        KeyParameter aesKey = new KeyParameter(aesSecret.toArrayUnsafe());
        byte[] IV = new byte[16];
        Arrays.fill(IV, (byte)0);
        this.decryptionCipher = new SICBlockCipher((BlockCipher)new AESEngine());
        this.decryptionCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)aesKey, IV));
        this.encryptionCipher = new SICBlockCipher((BlockCipher)new AESEngine());
        this.encryptionCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)aesKey, IV));
    }

    public SECP256K1.PublicKey publicKey() {
        return this.publicKey;
    }

    public SECP256K1.PublicKey peerPublicKey() {
        return this.peerPublicKey;
    }

    public void configureAfterHandshake(HelloMessage helloMessage) {
        this.applySnappyCompression = helloMessage.p2pVersion() >= 5;
    }

    public synchronized void stream(Bytes newBytes, Consumer<RLPxMessage> messageConsumer) {
        logger.trace("Adding new bytes to buffer {}", (Object)newBytes);
        this.buffer = Bytes.concatenate((Bytes[])new Bytes[]{this.buffer, newBytes});
        RLPxMessage message = null;
        do {
            if ((message = this.readFrame(this.buffer)) == null) continue;
            this.buffer = this.buffer.slice(message.bytesLength());
            logger.trace("Read message of type {}", (Object)message.messageId());
            messageConsumer.accept(message);
        } while (this.buffer.size() != 0 && message != null);
    }

    public RLPxMessage readFrame(Bytes messageFrame) {
        int pad;
        if (messageFrame.size() < 32) {
            return null;
        }
        Integer frameSize = this.lastFrameSize;
        if (frameSize == null) {
            Bytes macBytes = messageFrame.slice(16, 16);
            Bytes headerBytes = messageFrame.slice(0, 16);
            Bytes decryptedHeader = Bytes.wrap((byte[])new byte[16]);
            this.decryptionCipher.processBytes(headerBytes.toArrayUnsafe(), 0, 16, decryptedHeader.toArrayUnsafe(), 0);
            frameSize = decryptedHeader.get(0) & 0xFF;
            frameSize = (frameSize << 8) + (decryptedHeader.get(1) & 0xFF);
            frameSize = (frameSize << 8) + (decryptedHeader.get(2) & 0xFF);
            Bytes expectedMac = this.calculateMac(headerBytes, true);
            if (!macBytes.equals(expectedMac)) {
                throw new InvalidMACException(String.format("Header MAC did not match expected MAC; expected: %s, received: %s", expectedMac.toHexString(), macBytes.toHexString()));
            }
        }
        int n = pad = frameSize % 16 == 0 ? 0 : 16 - frameSize % 16;
        if (messageFrame.size() < 32 + frameSize + pad + 16) {
            this.lastFrameSize = frameSize;
            return null;
        }
        this.lastFrameSize = null;
        Bytes frameData = messageFrame.slice(32, frameSize + pad);
        Bytes frameMac = messageFrame.slice(32 + frameSize + pad, 16);
        Bytes newFrameMac = Bytes.wrap((byte[])new byte[16]);
        Bytes32 frameMacSeed = this.updateIngress(messageFrame.slice(32, frameSize + pad));
        this.macEncryptionEngine.processBlock(frameMacSeed.toArrayUnsafe(), 0, newFrameMac.toArrayUnsafe(), 0);
        Bytes expectedFrameMac = this.updateIngress(newFrameMac.xor(frameMacSeed.slice(0, 16))).slice(0, 16);
        if (!expectedFrameMac.equals(frameMac)) {
            throw new InvalidMACException(String.format("Frame MAC did not match expected MAC; expected: %s, received: %s", expectedFrameMac.toHexString(), frameMac.toHexString()));
        }
        Bytes decryptedFrameData = Bytes.wrap((byte[])new byte[frameData.size()]);
        this.decryptionCipher.processBytes(frameData.toArrayUnsafe(), 0, frameData.size(), decryptedFrameData.toArrayUnsafe(), 0);
        int messageType = RLP.decodeInt((Bytes)decryptedFrameData.slice(0, 1));
        Bytes messageData = decryptedFrameData.slice(1, decryptedFrameData.size() - 1 - pad);
        if (this.applySnappyCompression) {
            try {
                messageData = Bytes.wrap((byte[])Snappy.uncompress((byte[])messageData.toArrayUnsafe()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new RLPxMessage(messageType, messageData, 32 + frameSize + pad + 16);
    }

    public Bytes write(RLPxMessage message) {
        int frameSize;
        Bytes messageData = message.content();
        if (this.applySnappyCompression) {
            try {
                messageData = Bytes.wrap((byte[])Snappy.compress((byte[])messageData.toArrayUnsafe()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        int pad = (frameSize = messageData.size() + 1) % 16 == 0 ? 0 : 16 - frameSize % 16;
        MutableBytes frameSizeBytes = MutableBytes.create((int)3);
        frameSizeBytes.set(0, (byte)(frameSize >> 16 & 0xFF));
        frameSizeBytes.set(1, (byte)(frameSize >> 8 & 0xFF));
        frameSizeBytes.set(2, (byte)(frameSize & 0xFF));
        Bytes protocolHeader = RLP.encodeList(writer -> {
            writer.writeValue(Bytes.EMPTY);
            writer.writeValue(Bytes.EMPTY);
        });
        byte[] zeros = new byte[16 - frameSizeBytes.size() - protocolHeader.size()];
        Arrays.fill(zeros, (byte)0);
        Bytes headerBytes = Bytes.concatenate((Bytes[])new Bytes[]{frameSizeBytes, protocolHeader, Bytes.wrap((byte[])zeros)});
        Bytes encryptedHeaderBytes = Bytes.wrap((byte[])new byte[16]);
        this.encryptionCipher.processBytes(headerBytes.toArrayUnsafe(), 0, 16, encryptedHeaderBytes.toArrayUnsafe(), 0);
        Bytes headerMac = this.calculateMac(encryptedHeaderBytes, false);
        Bytes idBytes = RLP.encodeInt((int)message.messageId());
        assert (idBytes.size() == 1);
        Bytes encryptedPayload = Bytes.wrap((byte[])new byte[idBytes.size() + messageData.size() + pad]);
        this.encryptionCipher.processBytes(Bytes.concatenate((Bytes[])new Bytes[]{idBytes, messageData, Bytes.wrap((byte[])new byte[pad])}).toArrayUnsafe(), 0, encryptedPayload.size(), encryptedPayload.toArrayUnsafe(), 0);
        Bytes payloadMacSeed = this.updateEgress(encryptedPayload).slice(0, 16);
        Bytes payloadMac = Bytes.wrap((byte[])new byte[16]);
        this.macEncryptionEngine.processBlock(payloadMacSeed.toArrayUnsafe(), 0, payloadMac.toArrayUnsafe(), 0);
        payloadMac = this.updateEgress(payloadMacSeed.xor(payloadMac)).slice(0, 16);
        Bytes finalBytes = Bytes.concatenate((Bytes[])new Bytes[]{encryptedHeaderBytes, headerMac, encryptedPayload, payloadMac});
        return finalBytes;
    }

    private Bytes calculateMac(Bytes input, boolean ingress) {
        Bytes mac = Bytes.wrap((byte[])new byte[16]);
        this.macEncryptionEngine.processBlock(RLPxConnection.snapshot(ingress ? this.ingressMac : this.egressMac).slice(0, 16).toArrayUnsafe(), 0, mac.toArrayUnsafe(), 0);
        mac = mac.xor(input);
        mac = ingress ? this.updateIngress(mac).slice(0, 16) : this.updateEgress(mac).slice(0, 16);
        return mac.slice(0, 16);
    }

    private Bytes32 updateEgress(Bytes bytes) {
        this.egressMac.update(bytes.toArrayUnsafe(), 0, bytes.size());
        return RLPxConnection.snapshot(this.egressMac);
    }

    private Bytes32 updateIngress(Bytes bytes) {
        this.ingressMac.update(bytes.toArrayUnsafe(), 0, bytes.size());
        return RLPxConnection.snapshot(this.ingressMac);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RLPxConnection that = (RLPxConnection)obj;
        return Objects.equals(this.aesSecret, that.aesSecret) && Objects.equals(this.macSecret, that.macSecret) && Objects.equals(this.token, that.token) && Objects.equals(RLPxConnection.snapshot(this.egressMac), RLPxConnection.snapshot(that.egressMac)) && Objects.equals(RLPxConnection.snapshot(this.ingressMac), RLPxConnection.snapshot(that.ingressMac));
    }

    public int hashCode() {
        return Objects.hash(Objects.hashCode(this.aesSecret), Objects.hashCode(this.macSecret), Objects.hashCode(this.token), this.egressMac, this.ingressMac);
    }
}

