/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.stratum.server.JsonRpcRequest;
import org.apache.tuweni.stratum.server.JsonRpcSuccessResponse;
import org.apache.tuweni.stratum.server.PoWInput;
import org.apache.tuweni.stratum.server.PoWSolution;
import org.apache.tuweni.stratum.server.StratumConnection;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 #2\u00020\u0001:\u0001#BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u001e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u000fH\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1EthProxyProtocol;", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "submitCallback", "Lkotlin/Function1;", "Lorg/apache/tuweni/stratum/server/PoWSolution;", "", "seedSupplier", "Lkotlin/Function0;", "Lorg/apache/tuweni/bytes/Bytes32;", "hashrateCallback", "Lkotlin/Function2;", "Lorg/apache/tuweni/bytes/Bytes;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "currentInput", "Lorg/apache/tuweni/stratum/server/PoWInput;", "canHandle", "initialMessage", "", "conn", "Lorg/apache/tuweni/stratum/server/StratumConnection;", "handle", "", "message", "handleHashrateSubmit", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "Lorg/apache/tuweni/stratum/server/JsonRpcRequest;", "handleMiningSubmit", "req", "onClose", "sendNewWork", "id", "setCurrentWorkTask", "input", "Companion", "server"})
public final class Stratum1EthProxyProtocol
implements StratumProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<PoWSolution, Boolean> submitCallback;
    @NotNull
    private final Function0<Bytes32> seedSupplier;
    @NotNull
    private final Function2<Bytes, Long, Boolean> hashrateCallback;
    @Nullable
    private PoWInput currentInput;
    private static final Logger logger = LoggerFactory.getLogger(Stratum1EthProxyProtocol.class);
    @NotNull
    private static final JsonMapper mapper = new JsonMapper();

    public Stratum1EthProxyProtocol(@NotNull Function1<? super PoWSolution, Boolean> submitCallback, @NotNull Function0<? extends Bytes32> seedSupplier, @NotNull Function2<? super Bytes, ? super Long, Boolean> hashrateCallback) {
        Intrinsics.checkNotNullParameter(submitCallback, (String)"submitCallback");
        Intrinsics.checkNotNullParameter(seedSupplier, (String)"seedSupplier");
        Intrinsics.checkNotNullParameter(hashrateCallback, (String)"hashrateCallback");
        this.submitCallback = submitCallback;
        this.seedSupplier = seedSupplier;
        this.hashrateCallback = hashrateCallback;
    }

    @Override
    public boolean canHandle(@NotNull String initialMessage, @NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)initialMessage, (String)"initialMessage");
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        try {
            JsonRpcRequest req = (JsonRpcRequest)mapper.readValue(initialMessage, JsonRpcRequest.class);
            if (!Intrinsics.areEqual((Object)req.getMethod(), (Object)"eth_submitLogin")) {
                logger.debug("Invalid first message method: {}", (Object)initialMessage);
                return false;
            }
            String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(req.getId(), null, true, 2, null));
            conn2.send(response + "\n");
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close();
            return false;
        }
        return true;
    }

    private final void sendNewWork(StratumConnection conn2, String id) {
        PoWInput poWInput = this.currentInput;
        if (poWInput == null) {
            return;
        }
        PoWInput input = poWInput;
        Object[] objectArray = new Comparable[]{(Comparable)((Object)input.getPrePowHash().toHexString()), (Comparable)this.seedSupplier.invoke(), (Comparable)((Object)input.getTarget().toHexString())};
        List result = CollectionsKt.mutableListOf((Object[])objectArray);
        JsonRpcSuccessResponse req = new JsonRpcSuccessResponse(id, null, result, 2, null);
        try {
            conn2.send(mapper.writeValueAsString((Object)req) + "\n");
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onClose(@NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
    }

    @Override
    public void handle(@NotNull StratumConnection conn2, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            Object object = mapper.readValue(message, JsonRpcRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(message\u2026onRpcRequest::class.java)");
            JsonRpcRequest req = (JsonRpcRequest)object;
            if (Intrinsics.areEqual((Object)"eth_getWork", (Object)req.getMethod())) {
                this.sendNewWork(conn2, req.getId());
            } else if (Intrinsics.areEqual((Object)"eth_submitWork", (Object)req.getMethod())) {
                this.handleMiningSubmit(conn2, req);
            } else if (Intrinsics.areEqual((Object)"eth_submitHashrate", (Object)req.getMethod())) {
                this.handleHashrateSubmit(mapper, conn2, req);
            } else {
                logger.debug("Unsupported message: {}", (Object)req.getMethod());
            }
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close();
        }
    }

    private final void handleMiningSubmit(StratumConnection conn2, JsonRpcRequest req) throws IOException {
        logger.debug("Miner submitted solution {}", (Object)req);
        PoWSolution solution = new PoWSolution(req.bytes(0).getLong(0), req.bytes32(2), null, req.bytes(1));
        PoWInput poWInput = this.currentInput;
        if (poWInput != null) {
            Bytes bytes = poWInput.getPrePowHash();
            if (bytes != null) {
                boolean bl;
                boolean it = bl = bytes.equals(solution.getPowHash());
                boolean bl2 = false;
                if (it) {
                    boolean result = (Boolean)this.submitCallback.invoke((Object)solution);
                    String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(req.getId(), null, result, 2, null));
                    conn2.send(response + "\n");
                }
            }
        }
    }

    @Override
    public void setCurrentWorkTask(@NotNull PoWInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.currentInput = input;
    }

    public final void handleHashrateSubmit(@NotNull JsonMapper mapper, @NotNull StratumConnection conn2, @NotNull JsonRpcRequest message) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Bytes hashRate = message.bytes(0);
        Bytes id = message.bytes(1);
        String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(message.getId(), null, this.hashrateCallback.invoke((Object)id, (Object)hashRate.toBigInteger().longValue()), 2, null));
        conn2.send(response + "\n");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1EthProxyProtocol$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

