/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.eth.Log;
import org.apache.tuweni.rlp.RLPReader;

public final class LogsBloomFilter {
    private static final int LEAST_SIGNIFICANT_THREE_BITS = 7;
    private final MutableBytes data;

    public static LogsBloomFilter compute(Collection<Log> logs) {
        LogsBloomFilter bloom = new LogsBloomFilter();
        logs.forEach(bloom::insertLog);
        return bloom;
    }

    public static LogsBloomFilter readFrom(RLPReader input) {
        return new LogsBloomFilter(input.readValue());
    }

    public LogsBloomFilter() {
        this.data = MutableBytes.create((int)256);
    }

    public LogsBloomFilter(Bytes data) {
        Preconditions.checkArgument((data.size() == 256 ? 1 : 0) != 0, (String)"Invalid size for bloom filter backing array: expected 256 but got %s", (int)data.size());
        this.data = data.mutableCopy();
    }

    public Bytes toBytes() {
        return this.data;
    }

    public void insertLog(Log log) {
        this.setBits((Bytes)Hash.keccak256((Bytes)log.getLogger()));
        for (Bytes32 topic : log.getTopics()) {
            this.setBits((Bytes)Hash.keccak256((Bytes)topic));
        }
    }

    public void digest(LogsBloomFilter other) {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.set(i, (byte)((this.data.get(i) | other.data.get(i)) & 0xFF));
        }
    }

    private void setBits(Bytes hashValue) {
        for (int counter = 0; counter < 6; counter += 2) {
            int setBloomBit = ((hashValue.get(counter) & 7) << 8) + (hashValue.get(counter + 1) & 0xFF);
            this.setBit(setBloomBit);
        }
    }

    private void setBit(int index) {
        int byteIndex = 255 - index / 8;
        int bitIndex = index % 8;
        this.data.set(byteIndex, (byte)(this.data.get(byteIndex) | 1 << bitIndex));
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogsBloomFilter)) {
            return false;
        }
        LogsBloomFilter other = (LogsBloomFilter)obj;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

