/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;

public class EthJsonModule
extends SimpleModule {
    public EthJsonModule() {
        this.addSerializer(Hash.class, (JsonSerializer)new HashSerializer());
        this.addSerializer(Address.class, (JsonSerializer)new AddressSerializer());
        this.addKeySerializer(Address.class, (JsonSerializer)new AddressKeySerializer());
        this.addSerializer(Bytes.class, (JsonSerializer)new BytesSerializer());
        this.addSerializer(Gas.class, (JsonSerializer)new GasSerializer());
        this.addSerializer(UInt256.class, (JsonSerializer)new UInt256Serializer());
        this.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        this.addKeyDeserializer(Bytes.class, new BytesKeyDeserializer());
        this.addKeyDeserializer(Address.class, new AddressKeyDeserializer());
        this.addDeserializer(Address.class, (JsonDeserializer)new AddressDeserializer());
        this.addDeserializer(Gas.class, (JsonDeserializer)new GasDeserializer());
        this.addDeserializer(Wei.class, (JsonDeserializer)new WeiDeserializer());
        this.addDeserializer(UInt256.class, (JsonDeserializer)new UInt256Deserializer());
        this.addKeyDeserializer(UInt256.class, new UInt256KeyDeserializer());
        this.addDeserializer(Bytes.class, (JsonDeserializer)new BytesDeserializer());
        this.addSerializer(SECP256K1.PublicKey.class, (JsonSerializer)new PublicKeySerializer());
    }

    static class HashSerializer
    extends StdSerializer<Hash> {
        HashSerializer() {
            super(Hash.class);
        }

        public void serialize(Hash value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toHexString());
        }
    }

    static class AddressSerializer
    extends StdSerializer<Address> {
        AddressSerializer() {
            super(Address.class);
        }

        public void serialize(Address value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toHexString());
        }
    }

    static class AddressKeySerializer
    extends StdSerializer<Address> {
        protected AddressKeySerializer() {
            super(Address.class);
        }

        public void serialize(Address value, JsonGenerator g, SerializerProvider provider) throws IOException {
            g.writeFieldName(value.toHexString());
        }
    }

    static class BytesSerializer
    extends StdSerializer<Bytes> {
        BytesSerializer() {
            super(Bytes.class);
        }

        public void serialize(Bytes value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toHexString());
        }
    }

    static class GasSerializer
    extends StdSerializer<Gas> {
        GasSerializer() {
            super(Gas.class);
        }

        public void serialize(Gas value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toBytes().toHexString());
        }
    }

    static class UInt256Serializer
    extends StdSerializer<UInt256> {
        UInt256Serializer() {
            super(UInt256.class);
        }

        public void serialize(UInt256 value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toHexString());
        }
    }

    static class InstantSerializer
    extends StdSerializer<Instant> {
        InstantSerializer() {
            super(Instant.class);
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(value.toEpochMilli());
        }
    }

    static class BytesKeyDeserializer
    extends KeyDeserializer {
        BytesKeyDeserializer() {
        }

        public Bytes deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return Bytes.fromHexString((CharSequence)key);
        }
    }

    static class AddressKeyDeserializer
    extends KeyDeserializer {
        AddressKeyDeserializer() {
        }

        public Address deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return Address.fromHexString(key);
        }
    }

    static class AddressDeserializer
    extends StdDeserializer<Address> {
        AddressDeserializer() {
            super(Address.class);
        }

        public Address deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Address.fromHexString(p.getValueAsString());
        }
    }

    static class GasDeserializer
    extends StdDeserializer<Gas> {
        GasDeserializer() {
            super(Gas.class);
        }

        public Gas deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Gas.valueOf((UInt256)UInt256.fromHexString((String)p.getValueAsString()));
        }
    }

    static class WeiDeserializer
    extends StdDeserializer<Wei> {
        WeiDeserializer() {
            super(Wei.class);
        }

        public Wei deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Wei.valueOf((UInt256)UInt256.fromHexString((String)p.getValueAsString()));
        }
    }

    static class UInt256Deserializer
    extends StdDeserializer<UInt256> {
        UInt256Deserializer() {
            super(UInt256.class);
        }

        public UInt256 deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return UInt256.fromHexString((String)p.getValueAsString());
        }
    }

    static class UInt256KeyDeserializer
    extends KeyDeserializer {
        UInt256KeyDeserializer() {
        }

        public UInt256 deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return UInt256.fromHexString((String)key);
        }
    }

    static class BytesDeserializer
    extends StdDeserializer<Bytes> {
        BytesDeserializer() {
            super(Bytes.class);
        }

        public Bytes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Bytes.fromHexString((CharSequence)p.getValueAsString());
        }
    }

    static class PublicKeySerializer
    extends StdSerializer<SECP256K1.PublicKey> {
        PublicKeySerializer() {
            super(SECP256K1.PublicKey.class);
        }

        public void serialize(SECP256K1.PublicKey value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toHexString());
        }
    }
}

