/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;

public final class Address
extends DelegatingBytes {
    public static final Address ZERO = Address.fromBytes(Bytes.repeat((byte)0, (int)20));
    private static final int SIZE = 20;

    public static Address fromPublicKey(SECP256K1.PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return Address.fromPublicKeyBytes(publicKey.bytes());
    }

    public static Address fromPublicKeyBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        Bytes32 value = Hash.keccak256((Bytes)bytes);
        return new Address(value.slice(12));
    }

    public static Address fromBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.size() == 20 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)20, (int)bytes.size());
        return new Address(bytes);
    }

    public static Address fromHexString(String str) {
        return Address.fromBytes(Bytes.fromHexString((CharSequence)str));
    }

    private Address(Bytes value) {
        super(value);
    }
}

