/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.coroutines.AsyncCompletionKt;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.EthHandler;
import org.apache.tuweni.devp2p.eth.EthHelloController;
import org.apache.tuweni.devp2p.eth.EthSubprotocol;
import org.apache.tuweni.devp2p.eth.MessageType;
import org.apache.tuweni.devp2p.eth.PeerInfo;
import org.apache.tuweni.devp2p.eth.StatusMessage;
import org.apache.tuweni.rlpx.RLPxService;
import org.apache.tuweni.rlpx.wire.DisconnectReason;
import org.apache.tuweni.rlpx.wire.SubProtocolHandler;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B'\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lorg/apache/tuweni/devp2p/eth/EthHelloHandler;", "Lorg/apache/tuweni/rlpx/wire/SubProtocolHandler;", "Lkotlinx/coroutines/CoroutineScope;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "blockchainInfo", "Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;", "service", "Lorg/apache/tuweni/rlpx/RLPxService;", "controller", "Lorg/apache/tuweni/devp2p/eth/EthHelloController;", "(Lkotlin/coroutines/CoroutineContext;Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;Lorg/apache/tuweni/rlpx/RLPxService;Lorg/apache/tuweni/devp2p/eth/EthHelloController;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "pendingStatus", "Ljava/util/WeakHashMap;", "", "Lorg/apache/tuweni/devp2p/eth/PeerInfo;", "handle", "Lorg/apache/tuweni/concurrent/AsyncCompletion;", "connection", "Lorg/apache/tuweni/rlpx/wire/WireConnection;", "messageType", "", "message", "Lorg/apache/tuweni/bytes/Bytes;", "handleNewPeerConnection", "handleStatus", "", "status", "Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "(Lorg/apache/tuweni/rlpx/wire/WireConnection;Lorg/apache/tuweni/devp2p/eth/StatusMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "Companion", "devp2p-eth"})
public final class EthHelloHandler
implements SubProtocolHandler,
CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final BlockchainInformation blockchainInfo;
    @NotNull
    private final RLPxService service;
    @NotNull
    private final EthHelloController controller;
    @NotNull
    private final WeakHashMap<String, PeerInfo> pendingStatus;
    @NotNull
    private static final Logger logger;

    public EthHelloHandler(@NotNull CoroutineContext coroutineContext, @NotNull BlockchainInformation blockchainInfo, @NotNull RLPxService service, @NotNull EthHelloController controller) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter((Object)blockchainInfo, (String)"blockchainInfo");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.coroutineContext = coroutineContext;
        this.blockchainInfo = blockchainInfo;
        this.service = service;
        this.controller = controller;
        this.pendingStatus = new WeakHashMap();
    }

    public /* synthetic */ EthHelloHandler(CoroutineContext coroutineContext, BlockchainInformation blockchainInformation, RLPxService rLPxService, EthHelloController ethHelloController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(coroutineContext, blockchainInformation, rLPxService, ethHelloController);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public AsyncCompletion handle(@NotNull WireConnection connection, int messageType, @NotNull Bytes message) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return AsyncCompletionKt.asyncCompletion$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(messageType, this, connection, message, null){
            int label;
            final /* synthetic */ int $messageType;
            final /* synthetic */ EthHelloHandler this$0;
            final /* synthetic */ WireConnection $connection;
            final /* synthetic */ Bytes $message;
            {
                this.$messageType = $messageType;
                this.this$0 = $receiver;
                this.$connection = $connection;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block5: {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            EthHelloHandler.Companion.getLogger().debug("Receiving message of type {}", (Object)Boxing.boxInt((int)this.$messageType));
                            if (this.$messageType != MessageType.Status.getCode()) break;
                            this.label = 1;
                            Object object3 = EthHelloHandler.access$handleStatus(this.this$0, this.$connection, StatusMessage.Companion.read(this.$message), (Continuation)this);
                            if (object3 == object2) {
                                return object2;
                            }
                            break block5;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            break block5;
                        }
                    }
                    EthHelloHandler.access$getService$p(this.this$0).disconnect(this.$connection, DisconnectReason.CLIENT_QUITTING);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object handleStatus(WireConnection connection, StatusMessage status, Continuation<? super Unit> $completion) {
        logger.debug("Received status message {}", (Object)status);
        PeerInfo peerInfo = this.pendingStatus.remove(connection.uri());
        if (peerInfo == null) {
            this.service.disconnect(connection, DisconnectReason.SUBPROTOCOL_REASON);
        } else {
            peerInfo.complete();
            this.controller.receiveStatus(connection, status.toStatus());
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public AsyncCompletion handleNewPeerConnection(@NotNull WireConnection connection) {
        Object v0;
        PeerInfo newPeer;
        block2: {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            newPeer = new PeerInfo();
            Map map = this.pendingStatus;
            Object object = connection.uri();
            map.put(object, newPeer);
            object = connection.agreedSubprotocols();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connection.agreedSubprotocols()");
            Iterable $this$firstOrNull$iv = (Iterable)object;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SubProtocolIdentifier it = (SubProtocolIdentifier)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)EthSubprotocol.Companion.getETH66().name())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        SubProtocolIdentifier ethSubProtocol = v0;
        if (ethSubProtocol == null) {
            newPeer.cancel();
            return (AsyncCompletion)newPeer.getReady();
        }
        this.service.send(ethSubProtocol, MessageType.Status.getCode(), connection, new StatusMessage(ethSubProtocol.version(), this.blockchainInfo.networkID(), this.blockchainInfo.totalDifficulty(), this.blockchainInfo.bestHash(), this.blockchainInfo.genesisHash(), this.blockchainInfo.getLatestForkHash(), this.blockchainInfo.getLatestFork()).toBytes());
        return (AsyncCompletion)newPeer.getReady();
    }

    @NotNull
    public AsyncCompletion stop() {
        return AsyncCompletionKt.asyncCompletion$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Object access$handleStatus(EthHelloHandler $this, WireConnection connection, StatusMessage status, Continuation $completion) {
        return $this.handleStatus(connection, status, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ RLPxService access$getService$p(EthHelloHandler $this) {
        return $this.service;
    }

    static {
        Logger logger = LoggerFactory.getLogger(EthHandler.class);
        Intrinsics.checkNotNull((Object)logger);
        EthHelloHandler.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/eth/EthHelloHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "devp2p-eth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

