/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.tuweni.io.Streams;

public final class Resources {
    private Resources() {
    }

    @MustBeClosed
    public static Stream<URL> find(String glob) throws IOException {
        return Resources.find(Defaults.CLASSLOADER, glob);
    }

    @MustBeClosed
    public static Stream<URL> find(@Nullable ClassLoader classLoader, String glob) throws IOException {
        if (glob.isEmpty()) {
            return Stream.empty();
        }
        String[] globParts = Resources.globRoot(glob);
        String root = globParts[0];
        while (!root.isEmpty() && root.charAt(0) == '/') {
            root = root.substring(1);
        }
        Enumeration<URL> resources = classLoader != null ? classLoader.getResources(root) : ClassLoader.getSystemResources(root);
        Stream<URL> stream = Streams.enumerationStream(resources);
        if ("".equals(root)) {
            stream = Stream.concat(stream, Resources.classLoaderJarRoots(classLoader));
        }
        if (globParts.length == 1) {
            return stream;
        }
        String rest = globParts[1];
        try {
            return stream.flatMap(url -> {
                try {
                    return Resources.find(url, rest);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static Stream<URL> classLoaderJarRoots(@Nullable ClassLoader classLoader) {
        return Resources.classLoaderJarRoots(classLoader, new HashMap<String, URI>()).stream().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Collection<URI> classLoaderJarRoots(@Nullable ClassLoader classLoader, Map<String, URI> results) {
        if (classLoader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                URI jarUri;
                String urlPath;
                try {
                    urlPath = Paths.get(url.toURI()).toString();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (!Files.isRegularFile(Paths.get(urlPath, new String[0]), new LinkOption[0]) || !urlPath.endsWith(".jar") && !urlPath.endsWith(".war") && !urlPath.endsWith(".zip")) continue;
                try {
                    jarUri = new URI("jar:" + url.toString() + "!/");
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                results.put(urlPath, jarUri);
            }
        }
        if (classLoader == ClassLoader.getSystemClassLoader()) {
            Resources.classPathManifestEntries(results);
        }
        if (classLoader == null) {
            return results.values();
        }
        return Resources.classLoaderJarRoots(classLoader.getParent(), results);
    }

    private static void classPathManifestEntries(Map<String, URI> results) {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(classPath, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            URI jarUri;
            Path path;
            String entry = st.nextToken().trim();
            if (entry.isEmpty() || !Files.isRegularFile(path = Paths.get(entry, new String[0]), new LinkOption[0])) continue;
            try {
                jarUri = new URI("jar:" + path.toUri().toString() + "!/");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            results.put(path.toString(), jarUri);
        }
    }

    @MustBeClosed
    private static Stream<URL> find(URL baseUrl, String glob) throws IOException {
        if (!Resources.isJarURL(baseUrl)) {
            return Resources.findFileResources(baseUrl, glob);
        }
        return Resources.findJarResources(baseUrl, glob);
    }

    private static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "war".equals(protocol) || "zip".equals(protocol);
    }

    @MustBeClosed
    private static Stream<URL> findFileResources(URL rootDirUrl, String glob) throws IOException {
        Path rootDir;
        try {
            rootDir = Paths.get(rootDirUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!Files.isDirectory(rootDir, new LinkOption[0]) || !Files.isReadable(rootDir)) {
            return Stream.empty();
        }
        PathMatcher pathMatcher = rootDir.getFileSystem().getPathMatcher("glob:" + glob);
        return Files.walk(rootDir, FileVisitOption.FOLLOW_LINKS).filter(path -> pathMatcher.matches(rootDir.relativize((Path)path))).map(path -> {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Stream<URL> findJarResources(URL baseUrl, String glob) throws IOException {
        URLConnection connection = baseUrl.openConnection();
        if (!(connection instanceof JarURLConnection)) {
            return Stream.empty();
        }
        JarURLConnection jarConnection = (JarURLConnection)connection;
        jarConnection.setUseCaches(false);
        JarFile jarFile = jarConnection.getJarFile();
        JarEntry jarEntry = jarConnection.getJarEntry();
        String rootEntryPath = jarEntry == null ? "" : jarEntry.getName();
        int rootEntryLength = rootEntryPath.length();
        FileSystem fileSystem = FileSystems.getDefault();
        PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + glob);
        return Streams.enumerationStream(jarFile.entries()).flatMap(entry -> {
            URL entryURL;
            String entryPath = entry.getName();
            if (!entryPath.startsWith(rootEntryPath) || entryPath.length() == rootEntryLength) {
                return Stream.empty();
            }
            String relativePath = entryPath.substring(rootEntryLength);
            if (!pathMatcher.matches(fileSystem.getPath(relativePath, new String[0]))) {
                return Stream.empty();
            }
            try {
                entryURL = new URL(baseUrl, relativePath);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return Stream.of(entryURL);
        });
    }

    @VisibleForTesting
    static String[] globRoot(String glob) {
        int length = glob.length();
        int j = 0;
        block5: for (int i = 0; i < length; ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '/': {
                    j = i;
                    continue block5;
                }
                case '\\': {
                    if (++i < length) continue block5;
                    throw new PatternSyntaxException("Invalid escape character at end of glob pattern", glob, length - 1);
                }
                case '*': 
                case '?': 
                case '[': 
                case '{': {
                    if (i == 0) {
                        return new String[]{"", glob};
                    }
                    return new String[]{Resources.unescape(glob.substring(0, j)), glob.substring(j + 1)};
                }
            }
        }
        return new String[]{Resources.unescape(glob)};
    }

    private static String unescape(String glob) {
        int length = glob.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = glob.charAt(i);
            if (c == '\\') assert (++i < length);
            builder.append(glob.charAt(i));
        }
        return builder.toString();
    }

    private static final class Defaults {
        static final ClassLoader CLASSLOADER;

        private Defaults() {
        }

        static {
            ClassLoader cl;
            block2: {
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (Throwable e) {
                    cl = Resources.class.getClassLoader();
                    if (cl != null) break block2;
                    cl = ClassLoader.getSystemClassLoader();
                }
            }
            CLASSLOADER = cl;
        }
    }
}

