/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.swagger.v3.jaxrs2.integration.OpenApiServlet;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.eth.crawler.RESTMetrics;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.apache.tuweni.eth.crawler.StatsJob;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.DoSFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011Bm\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.J\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00062"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerRESTService;", "Lkotlinx/coroutines/CoroutineScope;", "port", "", "networkInterface", "", "path", "maxRequestsPerSec", "allowedOrigins", "allowedMethods", "allowedHeaders", "repository", "Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;", "stats", "Lorg/apache/tuweni/eth/crawler/StatsJob;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(ILjava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;Lorg/apache/tuweni/eth/crawler/StatsJob;Lio/opentelemetry/api/metrics/Meter;Lkotlin/coroutines/CoroutineContext;)V", "actualPort", "getActualPort", "()Ljava/lang/Integer;", "setActualPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getAllowedHeaders", "()Ljava/lang/String;", "getAllowedMethods", "getAllowedOrigins", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getMaxRequestsPerSec", "()I", "getMeter", "()Lio/opentelemetry/api/metrics/Meter;", "getNetworkInterface", "getPath", "getPort", "getRepository", "()Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;", "server", "Lorg/eclipse/jetty/server/Server;", "getStats", "()Lorg/apache/tuweni/eth/crawler/StatsJob;", "start", "Lkotlinx/coroutines/Deferred;", "", "stop", "Companion", "eth-crawler"})
public final class CrawlerRESTService
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final String networkInterface;
    @NotNull
    private final String path;
    private final int maxRequestsPerSec;
    @NotNull
    private final String allowedOrigins;
    @NotNull
    private final String allowedMethods;
    @NotNull
    private final String allowedHeaders;
    @NotNull
    private final RelationalPeerRepository repository;
    @NotNull
    private final StatsJob stats;
    @NotNull
    private final Meter meter;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private Server server;
    @Nullable
    private Integer actualPort;
    private static final Logger logger = LoggerFactory.getLogger(CrawlerRESTService.class);

    public CrawlerRESTService(int port, @NotNull String networkInterface, @NotNull String path, int maxRequestsPerSec, @NotNull String allowedOrigins, @NotNull String allowedMethods, @NotNull String allowedHeaders, @NotNull RelationalPeerRepository repository, @NotNull StatsJob stats, @NotNull Meter meter, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)allowedOrigins, (String)"allowedOrigins");
        Intrinsics.checkNotNullParameter((Object)allowedMethods, (String)"allowedMethods");
        Intrinsics.checkNotNullParameter((Object)allowedHeaders, (String)"allowedHeaders");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)meter, (String)"meter");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.port = port;
        this.networkInterface = networkInterface;
        this.path = path;
        this.maxRequestsPerSec = maxRequestsPerSec;
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.repository = repository;
        this.stats = stats;
        this.meter = meter;
        this.coroutineContext = coroutineContext;
    }

    public /* synthetic */ CrawlerRESTService(int n, String string, String string2, int n2, String string3, String string4, String string5, RelationalPeerRepository relationalPeerRepository, StatsJob statsJob, Meter meter, CoroutineContext coroutineContext, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            string = "127.0.0.1";
        }
        if ((n3 & 4) != 0) {
            string2 = "/";
        }
        if ((n3 & 8) != 0) {
            n2 = 30;
        }
        if ((n3 & 0x10) != 0) {
            string3 = "*";
        }
        if ((n3 & 0x20) != 0) {
            string4 = "*";
        }
        if ((n3 & 0x40) != 0) {
            string5 = "*";
        }
        if ((n3 & 0x400) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(n, string, string2, n2, string3, string4, string5, relationalPeerRepository, statsJob, meter, coroutineContext);
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getMaxRequestsPerSec() {
        return this.maxRequestsPerSec;
    }

    @NotNull
    public final String getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @NotNull
    public final String getAllowedMethods() {
        return this.allowedMethods;
    }

    @NotNull
    public final String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    @NotNull
    public final RelationalPeerRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final StatsJob getStats() {
        return this.stats;
    }

    @NotNull
    public final Meter getMeter() {
        return this.meter;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Nullable
    public final Integer getActualPort() {
        return this.actualPort;
    }

    public final void setActualPort(@Nullable Integer n) {
        this.actualPort = n;
    }

    @NotNull
    public final Deferred<Unit> start() {
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CrawlerRESTService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Server newServer = new Server(new InetSocketAddress(this.this$0.getNetworkInterface(), this.this$0.getPort()));
                        ServletContextHandler ctx = new ServletContextHandler(0);
                        ctx.setContextPath(this.this$0.getPath());
                        newServer.setHandler((Handler)ctx);
                        ServletHolder serHol = ctx.addServlet(ServletContainer.class, "/rest/*");
                        serHol.setInitOrder(1);
                        serHol.setInitParameter("jersey.config.server.provider.packages", "org.apache.tuweni.eth.crawler.rest");
                        ServletHolder apiServlet = ctx.addServlet(OpenApiServlet.class, "/api/*");
                        apiServlet.setInitParameter("openApi.configuration.resourcePackages", "org.apache.tuweni.eth.crawler.rest");
                        apiServlet.setInitOrder(2);
                        ctx.setBaseResource(Resource.newResource((URL)CrawlerRESTService.class.getResource("/webapp")));
                        ServletHolder staticContent = ctx.addServlet(DefaultServlet.class, "/*");
                        String[] stringArray = new String[]{"index.html"};
                        ctx.setWelcomeFiles(stringArray);
                        staticContent.setInitOrder(10);
                        ServletHolder swagger = new ServletHolder("swagger-ui", DefaultServlet.class);
                        swagger.setInitParameter("resourceBase", CrawlerRESTService.class.getClassLoader().getResource("META-INF/resources/webjars/swagger-ui/3.50.0/").toString());
                        swagger.setInitParameter("pathInfoOnly", "true");
                        ctx.addServlet(swagger, "/swagger-ui/*");
                        DoSFilter filter = new DoSFilter();
                        filter.setMaxRequestsPerSec(this.this$0.getMaxRequestsPerSec());
                        ctx.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.of((Enum)DispatcherType.REQUEST));
                        CrossOriginFilter corsFilter = new CrossOriginFilter();
                        FilterHolder corsFilterHolder = new FilterHolder((Filter)corsFilter);
                        corsFilterHolder.setInitParameter("allowedOrigins", this.this$0.getAllowedOrigins());
                        corsFilterHolder.setInitParameter("allowedMethods", this.this$0.getAllowedMethods());
                        corsFilterHolder.setInitParameter("allowedHeaders", this.this$0.getAllowedHeaders());
                        ctx.addFilter(corsFilterHolder, "/*", EnumSet.of((Enum)DispatcherType.REQUEST));
                        newServer.setStopAtShutdown(true);
                        newServer.start();
                        serHol.getServlet().getServletConfig().getServletContext().setAttribute("repo", (Object)this.this$0.getRepository());
                        serHol.getServlet().getServletConfig().getServletContext().setAttribute("stats", (Object)this.this$0.getStats());
                        LongCounter longCounter = this.this$0.getMeter().longCounterBuilder("peers").setDescription("Number of times peers have been requested").build();
                        Intrinsics.checkNotNullExpressionValue((Object)longCounter, (String)"meter.longCounterBuilder\u2026 been requested\").build()");
                        LongCounter longCounter2 = longCounter;
                        longCounter = this.this$0.getMeter().longCounterBuilder("clients").setDescription("Number of times client stats have been requested").build();
                        Intrinsics.checkNotNullExpressionValue((Object)longCounter, (String)"meter.longCounterBuilder\u2026 been requested\").build()");
                        RESTMetrics restMetrics = new RESTMetrics(longCounter2, longCounter);
                        serHol.getServlet().getServletConfig().getServletContext().setAttribute("metrics", (Object)restMetrics);
                        CrawlerRESTService.access$setServer$p(this.this$0, newServer);
                        this.this$0.setActualPort(Boxing.boxInt((int)newServer.getURI().getPort()));
                        CrawlerRESTService.Companion.getLogger$eth_crawler().info("REST service started on " + newServer.getURI());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<Unit> stop() {
        return BuildersKt.async$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CrawlerRESTService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)object);
                        Server server = CrawlerRESTService.access$getServer$p(this.this$0);
                        if (server == null) {
                            unit = null;
                        } else {
                            server.stop();
                            unit = Unit.INSTANCE;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ void access$setServer$p(CrawlerRESTService $this, Server server) {
        $this.server = server;
    }

    public static final /* synthetic */ Server access$getServer$p(CrawlerRESTService $this) {
        return $this.server;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerRESTService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$eth_crawler", "()Lorg/slf4j/Logger;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$eth_crawler() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

