/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import java.security.MessageDigest;
import java.util.Arrays;
import org.identityconnectors.common.Base64;

public final class SecurityUtil {
    private SecurityUtil() {
    }

    public static byte[] charsToBytes(char[] chars) {
        byte[] bytes = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            char v = chars[i];
            bytes[i * 2] = (byte)(0xFF & v >> 8);
            bytes[i * 2 + 1] = (byte)(0xFF & v);
        }
        return bytes;
    }

    public static char[] bytesToChars(byte[] bytes) {
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i < chars.length; ++i) {
            char v;
            chars[i] = v = (char)((0xFF & bytes[i * 2]) << 8 | 0xFF & bytes[i * 2 + 1]);
        }
        return chars;
    }

    public static void clear(byte[] bytes) {
        if (bytes != null) {
            Arrays.fill(bytes, (byte)0);
        }
    }

    public static void clear(char[] chars) {
        if (chars != null) {
            Arrays.fill(chars, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeBase64SHA1Hash(char[] input) {
        byte[] bytes = null;
        try {
            bytes = SecurityUtil.charsToBytes(input);
            String string = SecurityUtil.computeBase64SHA1Hash(bytes);
            return string;
        }
        finally {
            SecurityUtil.clear(bytes);
        }
    }

    public static String computeBase64SHA1Hash(byte[] bytes) {
        byte[] data;
        try {
            MessageDigest hasher = MessageDigest.getInstance("SHA");
            data = hasher.digest(bytes);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Base64.encode(data);
    }

    public static boolean verifyBase64SHA1Hash(char[] input, String hash) {
        String inputHash = SecurityUtil.computeBase64SHA1Hash(input);
        return inputHash.equals(hash);
    }
}

