/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.tuweni.scuttlebutt.lib.model.Author;

public class FeedValue {
    private String previous;
    private Author author;
    private long sequence;
    private long timestamp;
    private String hash;
    private JsonNode content;
    private static final ObjectMapper mapper = new ObjectMapper();

    public FeedValue(String previous, Author author, long sequence, long timestamp, String hash, JsonNode content) {
        this.previous = previous;
        this.author = author;
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.hash = hash;
        this.content = content;
    }

    public String getPrevious() {
        return this.previous;
    }

    public Author getAuthor() {
        return this.author;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getHash() {
        return this.hash;
    }

    public String getContentAsJsonString() throws JsonProcessingException {
        return mapper.writeValueAsString((Object)this.content);
    }

    public <T> T getContentAs(ObjectMapper mapper, Class<T> clazz) throws IOException {
        return (T)mapper.readValue(this.getContentAsJsonString(), clazz);
    }
}

