/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import io.vertx.core.Vertx;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.io.Base64;
import org.apache.tuweni.scuttlebutt.Invite;
import org.apache.tuweni.scuttlebutt.handshake.vertx.SecureScuttlebuttVertxClient;
import org.apache.tuweni.scuttlebutt.lib.ScuttlebuttClient;
import org.apache.tuweni.scuttlebutt.rpc.mux.RPCHandler;

public final class ScuttlebuttClientFactory {
    public static final Bytes32 DEFAULT_NETWORK = Bytes32.wrap((Bytes)Base64.decode((String)"1KHLiKZvAvjbY1ziZEHMXawbCEIM6qwjCDm3VYRan/s="));

    private ScuttlebuttClientFactory() {
    }

    public static AsyncResult<ScuttlebuttClient> fromNet(String host, int port, Signature.KeyPair keyPair, Signature.PublicKey serverPublicKey) {
        Vertx vertx = Vertx.vertx();
        return ScuttlebuttClientFactory.fromNetWithVertx(vertx, host, port, keyPair, serverPublicKey);
    }

    public static AsyncResult<ScuttlebuttClient> fromNetWithVertx(Vertx vertx, String host, int port, Signature.KeyPair keyPair, Signature.PublicKey serverPublicKey) {
        return ScuttlebuttClientFactory.fromNetWithNetworkKey(vertx, host, port, keyPair, serverPublicKey, DEFAULT_NETWORK);
    }

    public static AsyncResult<ScuttlebuttClient> fromNetWithNetworkKey(Vertx vertx, String host, int port, Signature.KeyPair keyPair, Signature.PublicKey serverPublicKey, Bytes32 networkIdentifier) {
        SecureScuttlebuttVertxClient secureScuttlebuttVertxClient = new SecureScuttlebuttVertxClient(vertx, keyPair, networkIdentifier);
        return secureScuttlebuttVertxClient.connectTo(port, host, serverPublicKey, null, (sender, terminationFn) -> new RPCHandler(vertx, sender, terminationFn)).thenApply(ScuttlebuttClient::new);
    }

    public static AsyncResult<ScuttlebuttClient> withInvite(Vertx vertx, Signature.KeyPair keyPair, Invite invite, Bytes32 networkIdentifier) {
        SecureScuttlebuttVertxClient secureScuttlebuttVertxClient = new SecureScuttlebuttVertxClient(vertx, keyPair, networkIdentifier);
        return secureScuttlebuttVertxClient.connectTo(invite.port(), invite.host(), null, invite, (sender, terminationFn) -> new RPCHandler(vertx, sender, terminationFn)).thenApply(ScuttlebuttClient::new);
    }
}

