/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.trie;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0000\u00a8\u0006\t"}, d2={"bytes32Identity", "Lorg/apache/tuweni/bytes/Bytes32;", "b", "bytesIdentity", "Lorg/apache/tuweni/bytes/Bytes;", "stringDeserializer", "", "stringSerializer", "s", "merkle-trie"})
public final class MerklePatriciaTrieKt {
    @NotNull
    public static final Bytes32 bytes32Identity(@NotNull Bytes32 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b;
    }

    @NotNull
    public static final Bytes bytesIdentity(@NotNull Bytes b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b;
    }

    @NotNull
    public static final Bytes stringSerializer(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = s;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Bytes bytes = Bytes.wrap((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(s.toByteArray(UTF_8))");
        return bytes;
    }

    @NotNull
    public static final String stringDeserializer(@NotNull Bytes b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] byArray = b.toArrayUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"b.toArrayUnsafe()");
        return new String(byArray, Charsets.UTF_8);
    }
}

