/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.trie;

import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.trie.CompactEncoding;
import org.apache.tuweni.trie.Node;
import org.apache.tuweni.trie.NodeFactory;
import org.apache.tuweni.trie.NodeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0011\u0010\u0003\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0013\u0010\u0005\u001a\u0004\u0018\u00018\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/trie/LeafNode;", "V", "Lorg/apache/tuweni/trie/Node;", "path", "Lorg/apache/tuweni/bytes/Bytes;", "value", "nodeFactory", "Lorg/apache/tuweni/trie/NodeFactory;", "valueSerializer", "Lkotlin/Function1;", "(Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/Object;Lorg/apache/tuweni/trie/NodeFactory;Lkotlin/jvm/functions/Function1;)V", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "rlp", "Ljava/lang/ref/WeakReference;", "Ljava/lang/Object;", "accept", "visitor", "Lorg/apache/tuweni/trie/NodeVisitor;", "(Lorg/apache/tuweni/trie/NodeVisitor;Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replacePath", "(Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rlpRef", "merkle-trie"})
public final class LeafNode<V>
implements Node<V> {
    @NotNull
    private final Bytes path;
    private final V value;
    @NotNull
    private final NodeFactory<V> nodeFactory;
    @NotNull
    private final Function1<V, Bytes> valueSerializer;
    @Nullable
    private volatile WeakReference<Bytes> rlp;
    @Nullable
    private volatile Bytes32 hash;

    public LeafNode(@NotNull Bytes path2, V value2, @NotNull NodeFactory<V> nodeFactory, @NotNull Function1<? super V, ? extends Bytes> valueSerializer) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(nodeFactory, (String)"nodeFactory");
        Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
        this.path = path2;
        this.value = value2;
        this.nodeFactory = nodeFactory;
        this.valueSerializer = valueSerializer;
    }

    @Override
    @Nullable
    public Object accept(@NotNull NodeVisitor<V> visitor, @NotNull Bytes path2, @NotNull Continuation<? super Node<V>> $completion) {
        return visitor.visit(this, path2, $completion);
    }

    @Override
    @Nullable
    public Object path(@NotNull Continuation<? super Bytes> $completion) {
        return this.path;
    }

    @Override
    @Nullable
    public Object value(@NotNull Continuation<? super V> $completion) {
        return this.value;
    }

    @Override
    @NotNull
    public Bytes rlp() {
        Bytes prevEncoded;
        WeakReference<Bytes> weakReference = this.rlp;
        Bytes bytes = prevEncoded = weakReference == null ? null : (Bytes)weakReference.get();
        if (prevEncoded != null) {
            return prevEncoded;
        }
        Bytes encoded = RLP.encodeList(arg_0 -> LeafNode.rlp$lambda-0(this, arg_0));
        this.rlp = new WeakReference<Bytes>(encoded);
        Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
        return encoded;
    }

    @Override
    @NotNull
    public Bytes rlpRef() {
        Bytes bytes;
        Bytes rlp = this.rlp();
        if (rlp.size() < 32) {
            bytes = rlp;
        } else {
            Bytes bytes2 = RLP.encodeValue((Bytes)((Bytes)this.hash()));
            Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"encodeValue(hash())");
            bytes = bytes2;
        }
        return bytes;
    }

    @Override
    @NotNull
    public Bytes32 hash() {
        Bytes32 hashed;
        Bytes32 bytes32 = this.hash;
        if (bytes32 != null) {
            Bytes32 it = bytes32;
            boolean bl = false;
            return it;
        }
        this.hash = hashed = Hash.keccak256((Bytes)this.rlp());
        Intrinsics.checkNotNullExpressionValue((Object)hashed, (String)"hashed");
        return hashed;
    }

    @Override
    @Nullable
    public Object replacePath(@NotNull Bytes path2, @NotNull Continuation<? super Node<V>> $completion) {
        return this.nodeFactory.createLeaf(path2, this.value, $completion);
    }

    private static final void rlp$lambda-0(LeafNode this$0, RLPWriter writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        writer.writeValue(CompactEncoding.encode(this$0.path));
        writer.writeValue((Bytes)this$0.valueSerializer.invoke(this$0.value));
    }
}

