/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import java.util.ArrayList;
import java.util.List;
import jnr.ffi.Pointer;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Box;
import org.apache.tuweni.crypto.sodium.DiffieHelman;
import org.apache.tuweni.crypto.sodium.GenericHash;
import org.apache.tuweni.crypto.sodium.HMACSHA512256;
import org.apache.tuweni.crypto.sodium.SHA256Hash;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.crypto.sodium.Sodium;

public final class Concatenate {
    private final List<Allocated> values = new ArrayList<Allocated>();

    public Concatenate add(GenericHash.Hash hash) {
        this.values.add(hash.value);
        return this;
    }

    public Concatenate add(SHA256Hash.Hash hash) {
        this.values.add(hash.value);
        return this;
    }

    public Concatenate add(HMACSHA512256.Key key) {
        this.values.add(key.value);
        return this;
    }

    public Concatenate add(Allocated allocated) {
        this.values.add(allocated);
        return this;
    }

    public Concatenate add(DiffieHelman.Secret key) {
        this.values.add(key.value);
        return this;
    }

    public Concatenate add(Signature.PublicKey key) {
        this.values.add(key.value);
        return this;
    }

    public Concatenate add(Box.PublicKey key) {
        this.values.add(key.value);
        return this;
    }

    public Concatenate add(Box.SecretKey key) {
        this.values.add(key.value);
        return this;
    }

    public Concatenate add(Signature.SecretKey key) {
        this.values.add(key.value);
        return this;
    }

    public Allocated concatenate() {
        int concatenatedLength = this.values.stream().mapToInt(v -> v.length()).sum();
        Pointer ptr = Sodium.malloc(concatenatedLength);
        try {
            int index = 0;
            for (Allocated value : this.values) {
                ptr.transferFrom((long)index, value.pointer(), 0L, (long)value.length());
                index += value.length();
            }
            return new Allocated(ptr, concatenatedLength);
        }
        catch (Throwable e) {
            Sodium.sodium_free(ptr);
            throw new RuntimeException(e);
        }
    }
}

