/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.net.URI;
import java.util.function.Supplier;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private final Supplier<WebsocketServerSpec.Builder> specBuilderSupplier;
    @Nullable
    private Integer maxFramePayloadLength;
    @Nullable
    private Boolean handlePing;

    public ReactorNettyRequestUpgradeStrategy() {
        this(WebsocketServerSpec::builder);
    }

    public ReactorNettyRequestUpgradeStrategy(Supplier<WebsocketServerSpec.Builder> builderSupplier) {
        Assert.notNull(builderSupplier, (String)"WebsocketServerSpec.Builder is required");
        this.specBuilderSupplier = builderSupplier;
    }

    public WebsocketServerSpec getWebsocketServerSpec() {
        return this.buildSpec(null);
    }

    WebsocketServerSpec buildSpec(@Nullable String subProtocol) {
        WebsocketServerSpec.Builder builder = this.specBuilderSupplier.get();
        if (subProtocol != null) {
            builder.protocols(subProtocol);
        }
        if (this.maxFramePayloadLength != null) {
            builder.maxFramePayloadLength(this.maxFramePayloadLength.intValue());
        }
        if (this.handlePing != null) {
            builder.handlePing(this.handlePing.booleanValue());
        }
        return builder.build();
    }

    @Deprecated
    public void setMaxFramePayloadLength(Integer maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    @Deprecated
    public int getMaxFramePayloadLength() {
        return this.getWebsocketServerSpec().maxFramePayloadLength();
    }

    @Deprecated
    public void setHandlePing(boolean handlePing) {
        this.handlePing = handlePing;
    }

    @Deprecated
    public boolean getHandlePing() {
        return this.getWebsocketServerSpec().handlePing();
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpResponse response = exchange.getResponse();
        HttpServerResponse reactorResponse = (HttpServerResponse)ServerHttpResponseDecorator.getNativeResponse((ServerHttpResponse)response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        NettyDataBufferFactory bufferFactory = (NettyDataBufferFactory)response.bufferFactory();
        URI uri = exchange.getRequest().getURI();
        return response.setComplete().then(Mono.defer(() -> {
            WebsocketServerSpec spec = this.buildSpec(subProtocol);
            return reactorResponse.sendWebsocket((in, out) -> {
                ReactorNettyWebSocketSession session = new ReactorNettyWebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, handshakeInfo, bufferFactory, spec.maxFramePayloadLength());
                return handler.handle(session).checkpoint(uri + " [ReactorNettyRequestUpgradeStrategy]");
            }, spec);
        }));
    }
}

