/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlpx.HandshakeMessage;

final class ResponderHandshakeMessage
implements HandshakeMessage {
    private final SECP256K1.PublicKey ephemeralPublicKey;
    private final Bytes32 nonce;

    static ResponderHandshakeMessage create(SECP256K1.PublicKey ephemeralPublicKey, Bytes32 nonce) {
        return new ResponderHandshakeMessage(ephemeralPublicKey, nonce);
    }

    static ResponderHandshakeMessage decode(Bytes payload) {
        return (ResponderHandshakeMessage)RLP.decodeList((Bytes)payload, reader -> new ResponderHandshakeMessage(SECP256K1.PublicKey.fromBytes((Bytes)reader.readValue()), Bytes32.wrap((Bytes)reader.readValue())));
    }

    private ResponderHandshakeMessage(SECP256K1.PublicKey ephemeralPublicKey, Bytes32 nonce) {
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.nonce = nonce;
    }

    @Override
    public SECP256K1.PublicKey ephemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    @Override
    public Bytes32 nonce() {
        return this.nonce;
    }

    Bytes encode() {
        return RLP.encodeList(writer -> {
            writer.writeValue(this.ephemeralPublicKey.bytes());
            writer.writeValue((Bytes)this.nonce);
            writer.writeInt(4);
        });
    }
}

