/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import com.google.common.base.Splitter;
import io.vertx.core.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/apache/tuweni/stratum/server/StratumConnection;", "", "protocols", "", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "closeHandle", "Lkotlin/Function0;", "", "sender", "Lkotlin/Function1;", "", "([Lorg/apache/tuweni/stratum/server/StratumProtocol;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "getCloseHandle", "()Lkotlin/jvm/functions/Function0;", "incompleteMessage", "protocol", "[Lorg/apache/tuweni/stratum/server/StratumProtocol;", "getSender", "()Lkotlin/jvm/functions/Function1;", "close", "handleBuffer", "buffer", "Lio/vertx/core/buffer/Buffer;", "handleMessage", "message", "send", "Companion", "server"})
public final class StratumConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StratumProtocol[] protocols;
    @NotNull
    private final Function0<Unit> closeHandle;
    @NotNull
    private final Function1<String, Unit> sender;
    @NotNull
    private String incompleteMessage;
    @Nullable
    private StratumProtocol protocol;
    private static final Logger logger = LoggerFactory.getLogger(StratumConnection.class);

    public StratumConnection(@NotNull StratumProtocol[] protocols, @NotNull Function0<Unit> closeHandle, @NotNull Function1<? super String, Unit> sender) {
        Intrinsics.checkNotNullParameter((Object)protocols, (String)"protocols");
        Intrinsics.checkNotNullParameter(closeHandle, (String)"closeHandle");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        this.protocols = protocols;
        this.closeHandle = closeHandle;
        this.sender = sender;
        this.incompleteMessage = "";
    }

    @NotNull
    public final Function0<Unit> getCloseHandle() {
        return this.closeHandle;
    }

    @NotNull
    public final Function1<String, Unit> getSender() {
        return this.sender;
    }

    public final void handleBuffer(@NotNull Buffer buffer) {
        String string;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        logger.trace("Buffer received {}", (Object)buffer);
        Splitter splitter = Splitter.on((char)'\n');
        Intrinsics.checkNotNullExpressionValue((Object)splitter, (String)"on('\\n')");
        Splitter splitter2 = splitter;
        boolean firstMessage = false;
        String messagesString = null;
        try {
            string = buffer.toString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n      buffer.toString(\u2026dardCharsets.UTF_8)\n    }");
        }
        catch (IllegalArgumentException e) {
            logger.debug("Invalid message with non UTF-8 characters: " + e.getMessage(), (Throwable)e);
            this.closeHandle.invoke();
            return;
        }
        messagesString = string;
        Iterator messages = splitter2.split((CharSequence)messagesString).iterator();
        while (messages.hasNext()) {
            Object message = (String)messages.next();
            if (!firstMessage) {
                message = this.incompleteMessage + (String)message;
                firstMessage = true;
            }
            if (!messages.hasNext()) {
                this.incompleteMessage = message;
                continue;
            }
            logger.trace("Dispatching message {}", message);
            this.handleMessage((String)message);
        }
    }

    public final void close() {
        logger.trace("Closing connection");
        StratumProtocol stratumProtocol = this.protocol;
        if (stratumProtocol != null) {
            stratumProtocol.onClose(this);
        }
    }

    private final void handleMessage(String message) {
        if (this.protocol == null) {
            for (StratumProtocol protocol : this.protocols) {
                if (!protocol.canHandle(message, this)) continue;
                this.protocol = protocol;
            }
            if (this.protocol == null) {
                logger.debug("Invalid first message: {}", (Object)message);
                this.closeHandle.invoke();
            }
        } else {
            StratumProtocol stratumProtocol = this.protocol;
            if (stratumProtocol != null) {
                stratumProtocol.handle(this, message);
            }
        }
    }

    public final void send(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        logger.debug("Sending message {}", (Object)message);
        this.sender.invoke((Object)message);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/stratum/server/StratumConnection$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

