/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.commons.io.UnsignedNumeric;

public final class SignedNumeric {
    private SignedNumeric() {
    }

    public static int readSignedInt(ObjectInput in) throws IOException {
        return SignedNumeric.decode(UnsignedNumeric.readUnsignedInt(in));
    }

    public static int readSignedInt(InputStream in) throws IOException {
        return SignedNumeric.decode(UnsignedNumeric.readUnsignedInt(in));
    }

    public static void writeSignedInt(ObjectOutput out, int i) throws IOException {
        UnsignedNumeric.writeUnsignedInt(out, SignedNumeric.encode(i));
    }

    public static void writeSignedInt(OutputStream out, int i) throws IOException {
        UnsignedNumeric.writeUnsignedInt(out, SignedNumeric.encode(i));
    }

    public static int decode(int vint) {
        return (vint & 1) == 0 ? vint >>> 1 : ~(vint >>> 1);
    }

    public static int encode(int vint) {
        return vint << 1 ^ vint >> 31;
    }
}

