/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.ethclient.EthereumConnection;
import org.apache.tuweni.ethclient.EthereumPeerRepository;
import org.apache.tuweni.peer.repository.Identity;
import org.apache.tuweni.peer.repository.Peer;
import org.apache.tuweni.rlpx.WireConnectionRepository;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u000bH\u0096\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/apache/tuweni/ethclient/WireConnectionPeerRepositoryAdapter;", "Lorg/apache/tuweni/rlpx/WireConnectionRepository;", "peerRepository", "Lorg/apache/tuweni/ethclient/EthereumPeerRepository;", "(Lorg/apache/tuweni/ethclient/EthereumPeerRepository;)V", "connectionListeners", "Ljava/util/ArrayList;", "Lorg/apache/tuweni/rlpx/WireConnectionRepository$Listener;", "Lkotlin/collections/ArrayList;", "connections", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/apache/tuweni/rlpx/wire/WireConnection;", "disconnectionListeners", "getPeerRepository", "()Lorg/apache/tuweni/ethclient/EthereumPeerRepository;", "wireConnectionToIdentities", "add", "wireConnection", "addConnectionListener", "", "listener", "addDisconnectionListener", "asIterable", "", "identifier", "Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "close", "get", "id", "ethereumConnection", "Lorg/apache/tuweni/ethclient/EthereumConnection;", "listenToStatus", "conn", "status", "Lorg/apache/tuweni/devp2p/eth/Status;", "eth-client"})
public final class WireConnectionPeerRepositoryAdapter
implements WireConnectionRepository {
    @NotNull
    private final EthereumPeerRepository peerRepository;
    @NotNull
    private final ConcurrentHashMap<String, String> wireConnectionToIdentities;
    @NotNull
    private final ConcurrentHashMap<String, WireConnection> connections;
    @NotNull
    private final ArrayList<WireConnectionRepository.Listener> connectionListeners;
    @NotNull
    private final ArrayList<WireConnectionRepository.Listener> disconnectionListeners;

    public WireConnectionPeerRepositoryAdapter(@NotNull EthereumPeerRepository peerRepository) {
        Intrinsics.checkNotNullParameter((Object)peerRepository, (String)"peerRepository");
        this.peerRepository = peerRepository;
        this.wireConnectionToIdentities = new ConcurrentHashMap();
        this.connections = new ConcurrentHashMap();
        this.connectionListeners = new ArrayList();
        this.disconnectionListeners = new ArrayList();
    }

    @NotNull
    public final EthereumPeerRepository getPeerRepository() {
        return this.peerRepository;
    }

    public void addConnectionListener(@NotNull WireConnectionRepository.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.connectionListeners.add(listener);
    }

    public void addDisconnectionListener(@NotNull WireConnectionRepository.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.disconnectionListeners.add(listener);
    }

    @NotNull
    public String add(@NotNull WireConnection wireConnection) {
        Intrinsics.checkNotNullParameter((Object)wireConnection, (String)"wireConnection");
        String string = wireConnection.peerHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wireConnection.peerHost()");
        String string2 = string;
        int n = wireConnection.peerPort();
        string = wireConnection.peerPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wireConnection.peerPublicKey()");
        Identity id = this.peerRepository.storeIdentity(string2, n, (SECP256K1.PublicKey)string);
        Peer peer = this.peerRepository.storePeer(id, Instant.now(), Instant.now());
        this.peerRepository.addConnection(peer, id);
        Map map = this.connections;
        String string3 = id.id();
        map.put(string3, wireConnection);
        map = this.wireConnectionToIdentities;
        string3 = wireConnection.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wireConnection.uri()");
        String string4 = id.id();
        map.put(string3, string4);
        wireConnection.registerListener(arg_0 -> WireConnectionPeerRepositoryAdapter.add$lambda-0(this, wireConnection, peer, id, arg_0));
        return id.id();
    }

    @Nullable
    public WireConnection get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.connections.get(id);
    }

    @NotNull
    public Iterable<WireConnection> asIterable() {
        Collection<WireConnection> collection = this.connections.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"connections.values");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<WireConnection> asIterable(@NotNull SubProtocolIdentifier identifier) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Collection<WireConnection> collection = this.connections.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"connections.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WireConnection conn = (WireConnection)element$iv$iv;
            boolean bl = false;
            if (!conn.supports(identifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void close() {
        this.connections.clear();
        this.wireConnectionToIdentities.clear();
    }

    @NotNull
    public final WireConnection get(@NotNull EthereumConnection ethereumConnection) {
        Intrinsics.checkNotNullParameter((Object)ethereumConnection, (String)"ethereumConnection");
        WireConnection wireConnection = this.connections.get(ethereumConnection.identity().id());
        if (wireConnection == null) {
            throw new NoSuchElementException("No connection available");
        }
        WireConnection conn = wireConnection;
        return conn;
    }

    public final void listenToStatus(@NotNull WireConnection conn, @NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String string = this.wireConnectionToIdentities.get(conn.uri());
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.getPeerRepository().storeStatus(it, status);
        }
    }

    private static final void add$lambda-0(WireConnectionPeerRepositoryAdapter this$0, WireConnection $wireConnection, Peer $peer, Identity $id, WireConnection.Event it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$wireConnection, (String)"$wireConnection");
        Intrinsics.checkNotNullParameter((Object)$peer, (String)"$peer");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it == WireConnection.Event.CONNECTED) {
            for (WireConnectionRepository.Listener listener : this$0.connectionListeners) {
                listener.connectionEvent($wireConnection);
            }
        } else if (it == WireConnection.Event.DISCONNECTED) {
            for (WireConnectionRepository.Listener listener : this$0.disconnectionListeners) {
                listener.connectionEvent($wireConnection);
            }
            this$0.peerRepository.markConnectionInactive($peer, $id);
        }
    }
}

