/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethstats;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.coroutines.AsyncResultKt;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.ethstats.AuthMessage;
import org.apache.tuweni.ethstats.BlockStats;
import org.apache.tuweni.ethstats.EthStatsReporter;
import org.apache.tuweni.ethstats.NodeInfo;
import org.apache.tuweni.ethstats.NodeStats;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 P2\u00020\u0001:\u0001PB\u0095\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\u0004\u0012\u00020\u00150\u0013\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u001f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010/\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0018\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002J\u0018\u0010:\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\b2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=H\u0002J\u0014\u0010>\u001a\u00020\u00152\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\"0\u0007J\u000e\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\"J\u000e\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020%J\u000e\u0010D\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\rJ\u0011\u0010F\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0011\u0010H\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0011\u0010I\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ \u0010J\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020MH\u0002J(\u0010J\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0006\u0010K\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u00052\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010O\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00070!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Q"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsReporter;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "id", "", "ethstatsServerURIs", "", "Ljava/net/URI;", "secret", "name", "node", "port", "", "network", "protocol", "os", "osVer", "historyRequester", "Lkotlin/Function1;", "Lorg/apache/tuweni/units/bigints/UInt256;", "", "timeSupplier", "Lkotlin/Function0;", "Ljava/time/Instant;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/CoroutineContext;)V", "client", "Lio/vertx/core/http/HttpClient;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "newHead", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/apache/tuweni/ethstats/BlockStats;", "newHistory", "newNodeStats", "Lorg/apache/tuweni/ethstats/NodeStats;", "newTxCount", "nodeInfo", "Lorg/apache/tuweni/ethstats/NodeInfo;", "getNodeInfo", "()Lorg/apache/tuweni/ethstats/NodeInfo;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "waitingOnPong", "attemptConnect", "uri", "(Ljava/net/URI;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connect", "Lorg/apache/tuweni/concurrent/AsyncResult;", "", "handleEmitEvent", "event", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "ws", "Lio/vertx/core/http/WebSocket;", "report", "reportPeriodically", "requestHistory", "list", "Lcom/fasterxml/jackson/databind/JsonNode;", "sendHistoryResponse", "blocks", "sendNewHead", "newBlockStats", "sendNewNodeStats", "nodeStats", "sendNewPendingTransactionCount", "txCount", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startInternal", "stop", "writeCommand", "command", "payload", "", "key", "writePing", "Companion", "ethstats"})
public final class EthStatsReporter
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final String id;
    @NotNull
    private final List<URI> ethstatsServerURIs;
    @NotNull
    private final String secret;
    @NotNull
    private final String name;
    @NotNull
    private final String node;
    private final int port;
    @NotNull
    private final String network;
    @NotNull
    private final String protocol;
    @NotNull
    private final String os;
    @NotNull
    private final String osVer;
    @NotNull
    private final Function1<List<UInt256>, Unit> historyRequester;
    @NotNull
    private final Function0<Instant> timeSupplier;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final NodeInfo nodeInfo;
    @NotNull
    private final AtomicBoolean started;
    @Nullable
    private HttpClient client;
    @NotNull
    private final AtomicReference<Integer> newTxCount;
    @NotNull
    private final AtomicReference<BlockStats> newHead;
    @NotNull
    private final AtomicReference<NodeStats> newNodeStats;
    @NotNull
    private final AtomicReference<List<BlockStats>> newHistory;
    @NotNull
    private final AtomicBoolean waitingOnPong;
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger;
    public static final long DELAY = 5000L;
    public static final long REPORTING_PERIOD = 1000L;
    public static final long PING_PERIOD = 15000L;

    public EthStatsReporter(@NotNull Vertx vertx, @NotNull String id, @NotNull List<URI> ethstatsServerURIs, @NotNull String secret, @NotNull String name, @NotNull String node, int port, @NotNull String network, @NotNull String protocol, @NotNull String os, @NotNull String osVer, @NotNull Function1<? super List<UInt256>, Unit> historyRequester, @NotNull Function0<Instant> timeSupplier, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(ethstatsServerURIs, (String)"ethstatsServerURIs");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)osVer, (String)"osVer");
        Intrinsics.checkNotNullParameter(historyRequester, (String)"historyRequester");
        Intrinsics.checkNotNullParameter(timeSupplier, (String)"timeSupplier");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.id = id;
        this.ethstatsServerURIs = ethstatsServerURIs;
        this.secret = secret;
        this.name = name;
        this.node = node;
        this.port = port;
        this.network = network;
        this.protocol = protocol;
        this.os = os;
        this.osVer = osVer;
        this.historyRequester = historyRequester;
        this.timeSupplier = timeSupplier;
        this.coroutineContext = coroutineContext;
        this.nodeInfo = new NodeInfo(this.name, this.node, this.port, this.network, this.protocol, null, this.os, this.osVer, false, null, 800, null);
        this.started = new AtomicBoolean(false);
        this.newTxCount = new AtomicReference();
        this.newHead = new AtomicReference();
        this.newNodeStats = new AtomicReference();
        this.newHistory = new AtomicReference();
        this.waitingOnPong = new AtomicBoolean(false);
    }

    public /* synthetic */ EthStatsReporter(Vertx vertx, String string, List list, String string2, String string3, String string4, int n, String string5, String string6, String string7, String string8, Function1 function1, Function0 function0, CoroutineContext coroutineContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x2000) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(vertx, string, list, string2, string3, string4, n, string5, string6, string7, string8, (Function1<? super List<UInt256>, Unit>)function1, (Function0<Instant>)function0, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> $completion) {
        if (this.started.compareAndSet(false, true)) {
            this.client = this.vertx.createHttpClient(new HttpClientOptions().setLogActivity(true));
            Object object = this.startInternal($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (this.started.compareAndSet(true, false)) {
            logger.debug("Stopping the ethstats client service");
            HttpClient httpClient = this.client;
            Object object = httpClient == null ? null : httpClient.close();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    public final void sendNewHead(@NotNull BlockStats newBlockStats) {
        Intrinsics.checkNotNullParameter((Object)newBlockStats, (String)"newBlockStats");
        this.newHead.set(newBlockStats);
    }

    public final void sendNewPendingTransactionCount(int txCount) {
        this.newTxCount.set(txCount);
    }

    public final void sendNewNodeStats(@NotNull NodeStats nodeStats) {
        Intrinsics.checkNotNullParameter((Object)nodeStats, (String)"nodeStats");
        this.newNodeStats.set(nodeStats);
    }

    public final void sendHistoryResponse(@NotNull List<BlockStats> blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        this.newHistory.set(blocks);
    }

    private final Object startInternal(Continuation<? super Unit> $completion) {
        for (URI uri : this.ethstatsServerURIs) {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uri, null){
                int label;
                final /* synthetic */ EthStatsReporter this$0;
                final /* synthetic */ URI $uri;
                {
                    this.this$0 = $receiver;
                    this.$uri = $uri;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = EthStatsReporter.access$attemptConnect(this.this$0, this.$uri, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object attemptConnect(URI var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof attemptConnect.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EthStatsReporter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EthStatsReporter.access$attemptConnect(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 2 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = uri;
                    $continuation.label = 1;
                    v0 = this.connect(uri, (Continuation<? super AsyncResult<Boolean>>)$continuation);
                    if (v0 == var5_5) {
                        return var5_5;
                    }
                    ** GOTO lbl25
                    break;
                }
            }
            case 1: {
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.label = 2;
                v1 = AsyncResultKt.await((AsyncResult)((AsyncResult)v0), (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl37
            }
            case 2: {
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                if (((Boolean)v1).booleanValue() || !this.started.get()) break;
                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.label = 3;
                v2 = DelayKt.delay((long)5000L, (Continuation)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl50
            }
            case 3: {
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl50:
                // 2 sources

                ** continue;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object connect(URI var1_1, Continuation<? super AsyncResult<Boolean>> var2_2) {
        if (!(var2_2 instanceof connect.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ EthStatsReporter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EthStatsReporter.access$connect(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = AsyncResult.incomplete();
                options = new WebSocketConnectOptions().setHost(uri.getHost()).setPort(Boxing.boxInt((int)uri.getPort())).setHeaders(MultiMap.caseInsensitiveMultiMap().add("origin", "http://localhost"));
                v0 = this.client;
                Intrinsics.checkNotNull((Object)v0);
                var6_8 = v0.webSocket(options);
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"client!!.webSocket(options)");
                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.L$2 = result;
                $continuation.label = 1;
                v1 = VertxCoroutineKt.await((Future)var6_8, (Continuation)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                result = (CompletableAsyncResult)$continuation.L$2;
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                ws = (WebSocket)v1;
                ws.closeHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, connect$lambda-0(org.apache.tuweni.ethstats.EthStatsReporter java.net.URI java.lang.Void ), (Ljava/lang/Void;)V)((EthStatsReporter)this, (URI)uri));
                ws.exceptionHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, connect$lambda-1(java.lang.Throwable ), (Ljava/lang/Throwable;)V)());
                ws.textMessageHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, connect$lambda-2(org.apache.tuweni.concurrent.CompletableAsyncResult org.apache.tuweni.ethstats.EthStatsReporter java.net.URI io.vertx.core.http.WebSocket java.lang.String ), (Ljava/lang/String;)V)((CompletableAsyncResult)result, (EthStatsReporter)this, (URI)uri, (WebSocket)ws));
                Intrinsics.checkNotNullExpressionValue((Object)ws, (String)"ws");
                this.writeCommand(ws, "hello", new AuthMessage(this.getNodeInfo(), this.id, this.secret));
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleEmitEvent(ArrayNode event, WebSocket ws) {
        String command = event.get(0).textValue();
        String string = command;
        if (Intrinsics.areEqual((Object)string, (Object)"node-pong")) {
            logger.debug("Received a pong {}", (Object)event.get(1));
            if (!this.waitingOnPong.compareAndSet(true, false)) {
                logger.warn("Received pong when we didn't expect one");
            } else {
                long start2 = event.get(1).get("clientTime").longValue();
                long latency = (Instant.now().toEpochMilli() - start2) / (long)2000;
                this.writeCommand(ws, "latency", "latency", latency);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"history")) {
            logger.debug("History request {}", (Object)event.get(1));
            JsonNode jsonNode = event.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"event.get(1)");
            this.requestHistory(jsonNode);
        } else {
            logger.warn("Unexpected message {}", (Object)command);
        }
    }

    private final void requestHistory(JsonNode list) {
        List request = new ArrayList();
        for (JsonNode elt : list) {
            UInt256 uInt256 = UInt256.fromHexString((String)elt.asText());
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"fromHexString(elt.asText())");
            request.add(uInt256);
        }
        this.historyRequester.invoke((Object)request);
    }

    private final void writePing(WebSocket ws) {
        this.waitingOnPong.set(true);
        this.writeCommand(ws, "node-ping", "clientTime", this.timeSupplier.invoke());
    }

    private final void reportPeriodically(URI uri, WebSocket ws) {
        TimeoutStream reportingStream = this.vertx.periodicStream(1000L).handler(arg_0 -> EthStatsReporter.reportPeriodically$lambda-3(this, ws, arg_0));
        TimeoutStream pingStream = this.vertx.periodicStream(15000L).handler(arg_0 -> EthStatsReporter.reportPeriodically$lambda-4(this, ws, arg_0));
        ws.closeHandler(arg_0 -> EthStatsReporter.reportPeriodically$lambda-5(reportingStream, pingStream, this, uri, arg_0));
    }

    private final void report(WebSocket ws) {
        List newBlocks;
        NodeStats nodeStats;
        Integer count;
        BlockStats head = this.newHead.getAndSet(null);
        if (head != null) {
            this.writeCommand(ws, "block", "block", head);
        }
        if ((count = (Integer)this.newTxCount.getAndSet(null)) != null) {
            Map<String, Integer> map = Collections.singletonMap("pending", count);
            Intrinsics.checkNotNullExpressionValue(map, (String)"singletonMap(\"pending\", count)");
            this.writeCommand(ws, "pending", "stats", map);
        }
        if ((nodeStats = (NodeStats)this.newNodeStats.getAndSet(null)) != null) {
            this.writeCommand(ws, "stats", "stats", nodeStats);
        }
        if ((newBlocks = (List)this.newHistory.getAndSet(null)) != null && !newBlocks.isEmpty()) {
            this.writeCommand(ws, "history", "history", newBlocks);
        }
    }

    private final void writeCommand(WebSocket ws, String command, Object payload) {
        try {
            Object[] objectArray = new Object[]{command, payload};
            String message = mapper.writer().writeValueAsString(Collections.singletonMap("emit", Arrays.asList(objectArray)));
            logger.debug("Sending {} message {}", (Object)command, (Object)message);
            ws.writeTextMessage(message);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private final void writeCommand(WebSocket ws, String command, String key, Object payload) {
        Map body;
        Map map = body = (Map)new LinkedHashMap();
        String string = "id";
        String string2 = this.id;
        map.put(string, string2);
        body.put(key, payload);
        this.writeCommand(ws, command, body);
    }

    private static final void connect$lambda-0(EthStatsReporter this$0, URI $uri, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $uri, null){
            int label;
            final /* synthetic */ EthStatsReporter this$0;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = EthStatsReporter.access$attemptConnect(this.this$0, this.$uri, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void connect$lambda-1(Throwable e) {
        logger.debug("Error while communicating with ethnetstats", e);
    }

    private static final void connect$lambda-2(CompletableAsyncResult $result, EthStatsReporter this$0, URI $uri, WebSocket $ws, String message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        try {
            JsonNode node = mapper.readTree(message);
            JsonNode emitEvent = node.get("emit");
            if (emitEvent.isArray()) {
                String eventValue = emitEvent.get(0).textValue();
                if (!$result.isDone()) {
                    if (!Intrinsics.areEqual((Object)"ready", (Object)eventValue)) {
                        logger.warn(message);
                        $result.complete((Object)false);
                    } else {
                        logger.debug("Connected OK! {}", (Object)message);
                        $result.complete((Object)true);
                        Intrinsics.checkNotNullExpressionValue((Object)$ws, (String)"ws");
                        this$0.reportPeriodically($uri, $ws);
                        this$0.writePing($ws);
                        this$0.report($ws);
                    }
                } else {
                    JsonNode jsonNode = emitEvent;
                    if (jsonNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
                    }
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    Intrinsics.checkNotNullExpressionValue((Object)$ws, (String)"ws");
                    this$0.handleEmitEvent(arrayNode, $ws);
                }
            } else {
                logger.warn(message);
                $result.complete((Object)false);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final void reportPeriodically$lambda-3(EthStatsReporter this$0, WebSocket $ws, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ws, (String)"$ws");
        this$0.report($ws);
    }

    private static final void reportPeriodically$lambda-4(EthStatsReporter this$0, WebSocket $ws, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ws, (String)"$ws");
        this$0.writePing($ws);
    }

    private static final void reportPeriodically$lambda-5(TimeoutStream $reportingStream, TimeoutStream $pingStream, EthStatsReporter this$0, URI $uri, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        $reportingStream.cancel();
        $pingStream.cancel();
        BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $uri, null){
            int label;
            final /* synthetic */ EthStatsReporter this$0;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = EthStatsReporter.access$attemptConnect(this.this$0, this.$uri, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Object access$startInternal(EthStatsReporter $this, Continuation $completion) {
        return $this.startInternal((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$attemptConnect(EthStatsReporter $this, URI uri, Continuation $completion) {
        return $this.attemptConnect(uri, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$connect(EthStatsReporter $this, URI uri, Continuation $completion) {
        return $this.connect(uri, (Continuation<? super AsyncResult<Boolean>>)$completion);
    }

    static {
        mapper.registerModule((Module)new EthJsonModule());
        logger = LoggerFactory.getLogger(EthStatsReporter.class);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsReporter$Companion;", "", "()V", "DELAY", "", "PING_PERIOD", "REPORTING_PERIOD", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "ethstats"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

