/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.Closeable;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.JSONRPCRequest;
import org.apache.tuweni.eth.JSONRPCResponse;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.jsonrpc.ClientRequestException;
import org.apache.tuweni.jsonrpc.JSONRPCClient;
import org.apache.tuweni.jsonrpc.JSONRPCClientKt;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0019\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0019\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\b\u0010&\u001a\u00020'H\u0002J\u0019\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u001f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0019\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lorg/apache/tuweni/jsonrpc/JSONRPCClient;", "Ljava/io/Closeable;", "vertx", "Lio/vertx/core/Vertx;", "endpointUrl", "", "userAgent", "basicAuthenticationEnabled", "", "basicAuthenticationUsername", "basicAuthenticationPassword", "(Lio/vertx/core/Vertx;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "authorizationHeader", "getAuthorizationHeader", "()Ljava/lang/String;", "getBasicAuthenticationEnabled", "()Z", "getBasicAuthenticationPassword", "getBasicAuthenticationUsername", "client", "Lio/vertx/ext/web/client/WebClient;", "kotlin.jvm.PlatformType", "getClient", "()Lio/vertx/ext/web/client/WebClient;", "getEndpointUrl", "requestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getRequestCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getUserAgent", "close", "", "getBalance_latest", "Lorg/apache/tuweni/units/bigints/UInt256;", "address", "Lorg/apache/tuweni/eth/Address;", "(Lorg/apache/tuweni/eth/Address;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTransactionCount_latest", "nextId", "", "sendRawTransaction", "tx", "Lorg/apache/tuweni/eth/Transaction;", "(Lorg/apache/tuweni/eth/Transaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRequest", "Lkotlinx/coroutines/Deferred;", "Lorg/apache/tuweni/eth/JSONRPCResponse;", "request", "Lorg/apache/tuweni/eth/JSONRPCRequest;", "(Lorg/apache/tuweni/eth/JSONRPCRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jsonrpc"})
public final class JSONRPCClient
implements Closeable {
    @NotNull
    private final String endpointUrl;
    @NotNull
    private final String userAgent;
    private final boolean basicAuthenticationEnabled;
    @NotNull
    private final String basicAuthenticationUsername;
    @NotNull
    private final String basicAuthenticationPassword;
    @NotNull
    private final AtomicInteger requestCounter;
    private final WebClient client;
    @NotNull
    private final String authorizationHeader;

    public JSONRPCClient(@NotNull Vertx vertx, @NotNull String endpointUrl, @NotNull String userAgent, boolean basicAuthenticationEnabled, @NotNull String basicAuthenticationUsername, @NotNull String basicAuthenticationPassword) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        Intrinsics.checkNotNullParameter((Object)basicAuthenticationUsername, (String)"basicAuthenticationUsername");
        Intrinsics.checkNotNullParameter((Object)basicAuthenticationPassword, (String)"basicAuthenticationPassword");
        this.endpointUrl = endpointUrl;
        this.userAgent = userAgent;
        this.basicAuthenticationEnabled = basicAuthenticationEnabled;
        this.basicAuthenticationUsername = basicAuthenticationUsername;
        this.basicAuthenticationPassword = basicAuthenticationPassword;
        this.requestCounter = new AtomicInteger(1);
        HttpClientOptions httpClientOptions = new WebClientOptions().setUserAgent(this.userAgent).setTryUseCompression(true).setTracingPolicy(TracingPolicy.ALWAYS);
        if (httpClientOptions == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.vertx.ext.web.client.WebClientOptions");
        }
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)((WebClientOptions)httpClientOptions));
        Base64.Encoder encoder = Base64.getEncoder();
        String string = this.basicAuthenticationUsername + ":" + this.basicAuthenticationPassword;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.authorizationHeader = "Basic " + encoder.encode(byArray);
    }

    public /* synthetic */ JSONRPCClient(Vertx vertx, String string, String string2, boolean bl, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "Apache Tuweni JSON-RPC Client";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string3 = "";
        }
        if ((n & 0x20) != 0) {
            string4 = "";
        }
        this(vertx, string, string2, bl, string3, string4);
    }

    @NotNull
    public final String getEndpointUrl() {
        return this.endpointUrl;
    }

    @NotNull
    public final String getUserAgent() {
        return this.userAgent;
    }

    public final boolean getBasicAuthenticationEnabled() {
        return this.basicAuthenticationEnabled;
    }

    @NotNull
    public final String getBasicAuthenticationUsername() {
        return this.basicAuthenticationUsername;
    }

    @NotNull
    public final String getBasicAuthenticationPassword() {
        return this.basicAuthenticationPassword;
    }

    @NotNull
    public final AtomicInteger getRequestCounter() {
        return this.requestCounter;
    }

    public final WebClient getClient() {
        return this.client;
    }

    @NotNull
    public final String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    @Nullable
    public final Object sendRequest(@NotNull JSONRPCRequest request, @NotNull Continuation<? super Deferred<JSONRPCResponse>> $completion) {
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        HttpRequest httpRequest = this.getClient().postAbs(this.getEndpointUrl()).putHeader("Content-Type", "application/json");
        if (this.getBasicAuthenticationEnabled()) {
            httpRequest.putHeader("authorization", this.getAuthorizationHeader());
        }
        httpRequest.sendBuffer(Buffer.buffer((byte[])JSONRPCClientKt.getMapper().writeValueAsBytes((Object)request)), arg_0 -> JSONRPCClient.sendRequest$lambda-0(deferred, arg_0));
        return deferred;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object sendRawTransaction(@NotNull Transaction var1_1, @NotNull Continuation<? super String> var2_2) {
        if (!(var2_2 instanceof sendRawTransaction.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRPCClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.sendRawTransaction(null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.nextId();
                var4_6 = new String[1];
                var5_7 = tx.toBytes().toHexString();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"tx.toBytes().toHexString()");
                var4_6[0] = var5_7;
                body = new JSONRPCRequest(v0, "eth_sendRawTransaction", var4_6, null, 8, null);
                $continuation.label = 1;
                v1 = this.sendRequest(body, (Continuation<? super Deferred<JSONRPCResponse>>)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                $continuation.label = 2;
                v2 = ((Deferred)v1).await((Continuation)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl34
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                if ((err = (jsonResponse = (JSONRPCResponse)v2).getError()) != null) {
                    errorMessage = "Code " + err.getCode() + ": " + err.getMessage();
                    throw new ClientRequestException(errorMessage);
                }
                return String.valueOf(jsonResponse.getResult());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getBalance_latest(@NotNull Address var1_1, @NotNull Continuation<? super UInt256> var2_2) {
        if (!(var2_2 instanceof getBalance_latest.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRPCClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getBalance_latest(null, (Continuation<? super UInt256>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.nextId();
                var4_6 = new String[2];
                var5_7 = address.toHexString();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"address.toHexString()");
                var4_6[0] = var5_7;
                var4_6[1] = "latest";
                body = new JSONRPCRequest(v0, "eth_getBalance", var4_6, null, 8, null);
                $continuation.label = 1;
                v1 = this.sendRequest(body, (Continuation<? super Deferred<JSONRPCResponse>>)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                $continuation.label = 2;
                v2 = ((Deferred)v1).await((Continuation)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl35
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                if ((err = (jsonResponse = (JSONRPCResponse)v2).getError()) != null) {
                    errorMessage = "Code " + err.getCode() + ": " + err.getMessage();
                    throw new ClientRequestException(errorMessage);
                }
                var6_10 = UInt256.fromHexString((String)String.valueOf(jsonResponse.getResult()));
                Intrinsics.checkNotNullExpressionValue((Object)var6_10, (String)"fromHexString(jsonResponse.result.toString())");
                return var6_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getTransactionCount_latest(@NotNull Address var1_1, @NotNull Continuation<? super UInt256> var2_2) {
        if (!(var2_2 instanceof getTransactionCount_latest.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRPCClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getTransactionCount_latest(null, (Continuation<? super UInt256>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.nextId();
                var4_6 = new String[2];
                var5_7 = address.toHexString();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"address.toHexString()");
                var4_6[0] = var5_7;
                var4_6[1] = "latest";
                body = new JSONRPCRequest(v0, "eth_getTransactionCount", var4_6, null, 8, null);
                $continuation.label = 1;
                v1 = this.sendRequest(body, (Continuation<? super Deferred<JSONRPCResponse>>)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                $continuation.label = 2;
                v2 = ((Deferred)v1).await((Continuation)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl35
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                if ((err = (jsonResponse = (JSONRPCResponse)v2).getError()) != null) {
                    errorMessage = "Code " + err.getCode() + ": " + err.getMessage();
                    throw new ClientRequestException(errorMessage);
                }
                var6_10 = UInt256.fromHexString((String)String.valueOf(jsonResponse.getResult()));
                Intrinsics.checkNotNullExpressionValue((Object)var6_10, (String)"fromHexString(jsonResponse.result.toString())");
                return var6_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void close() {
        this.client.close();
    }

    private final int nextId() {
        int next = this.requestCounter.incrementAndGet();
        if (next == Integer.MAX_VALUE) {
            this.requestCounter.set(1);
        }
        return next;
    }

    private static final void sendRequest$lambda-0(CompletableDeferred $deferred, AsyncResult response) {
        Intrinsics.checkNotNullParameter((Object)$deferred, (String)"$deferred");
        if (response.failed()) {
            Throwable throwable = response.cause();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"response.cause()");
            $deferred.completeExceptionally(throwable);
        } else {
            JSONRPCResponse jsonResponse = (JSONRPCResponse)((HttpResponse)response.result()).bodyAsJson(JSONRPCResponse.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonResponse, (String)"jsonResponse");
            $deferred.complete((Object)jsonResponse);
        }
    }
}

