/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.net.impl.pool.Executor;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class CombinerExecutor<S>
implements Executor<S> {
    private final Queue<Executor.Action<S>> q = PlatformDependent.newMpscQueue();
    private final AtomicInteger s = new AtomicInteger();
    private final S state;

    public CombinerExecutor(S state) {
        this.state = state;
    }

    @Override
    public void submit(Executor.Action<S> action) {
        this.q.add(action);
        if (this.s.get() != 0 || !this.s.compareAndSet(0, 1)) {
            return;
        }
        do {
            try {
                this.pollAndExecute();
            }
            finally {
                this.s.set(0);
            }
        } while (!this.q.isEmpty() && this.s.compareAndSet(0, 1));
    }

    private void pollAndExecute() {
        Executor.Action<S> a;
        while ((a = this.q.poll()) != null) {
            Runnable post = a.execute(this.state);
            if (post == null) continue;
            post.run();
        }
    }
}

