/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import io.vertx.core.net.SocketAddress;
import java.math.BigInteger;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.FindNodeMessage;
import org.apache.tuweni.devp2p.v5.HandshakeSessionKt;
import org.apache.tuweni.devp2p.v5.Message;
import org.apache.tuweni.devp2p.v5.MessageType;
import org.apache.tuweni.devp2p.v5.RandomMessage;
import org.apache.tuweni.devp2p.v5.WhoAreYouMessage;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKey;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKeyGenerator;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 72\u00020\u0001:\u00017BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140+J\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0006\u00101\u001a\u00020\u0018J(\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\n0&j\b\u0012\u0004\u0012\u00020\n`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n )*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lorg/apache/tuweni/devp2p/v5/HandshakeSession;", "Lkotlinx/coroutines/CoroutineScope;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "address", "Lio/vertx/core/net/SocketAddress;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "sendFn", "Lkotlin/Function2;", "Lorg/apache/tuweni/bytes/Bytes;", "", "enr", "Lkotlin/Function0;", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;Lio/vertx/core/net/SocketAddress;Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/CoroutineContext;)V", "connected", "Lorg/apache/tuweni/concurrent/CompletableAsyncResult;", "Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKey;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "getNodeId", "()Lorg/apache/tuweni/bytes/Bytes32;", "receivedEnr", "getReceivedEnr", "()Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "setReceivedEnr", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;)V", "requestId", "getRequestId", "()Lorg/apache/tuweni/bytes/Bytes;", "setRequestId", "(Lorg/apache/tuweni/bytes/Bytes;)V", "tokens", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "whoAreYouHeader", "kotlin.jvm.PlatformType", "awaitConnection", "Lorg/apache/tuweni/concurrent/AsyncResult;", "connect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processMessage", "messageBytes", "(Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tag", "verifySignature", "", "signatureBytes", "idNonce", "ephemeralPublicKey", "Companion", "devp2p"})
public final class HandshakeSession
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SECP256K1.KeyPair keyPair;
    @NotNull
    private final SocketAddress address;
    @Nullable
    private SECP256K1.PublicKey publicKey;
    @NotNull
    private final Function2<SocketAddress, Bytes, Unit> sendFn;
    @NotNull
    private final Function0<EthereumNodeRecord> enr;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private Bytes requestId;
    @NotNull
    private final CompletableAsyncResult<SessionKey> connected;
    @Nullable
    private EthereumNodeRecord receivedEnr;
    @NotNull
    private final Bytes32 nodeId;
    private final Bytes32 whoAreYouHeader;
    @NotNull
    private final ArrayList<Bytes> tokens;
    private static final Logger logger = LoggerFactory.getLogger(HandshakeSession.class);

    public HandshakeSession(@NotNull SECP256K1.KeyPair keyPair, @NotNull SocketAddress address, @Nullable SECP256K1.PublicKey publicKey, @NotNull Function2<? super SocketAddress, ? super Bytes, Unit> sendFn, @NotNull Function0<EthereumNodeRecord> enr, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(sendFn, (String)"sendFn");
        Intrinsics.checkNotNullParameter(enr, (String)"enr");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.keyPair = keyPair;
        this.address = address;
        this.publicKey = publicKey;
        this.sendFn = sendFn;
        this.enr = enr;
        this.coroutineContext = coroutineContext;
        Bytes[] bytesArray = AsyncResult.incomplete();
        Intrinsics.checkNotNullExpressionValue((Object)bytesArray, (String)"incomplete()");
        this.connected = bytesArray;
        bytesArray = this.keyPair.publicKey();
        Intrinsics.checkNotNullExpressionValue((Object)bytesArray, (String)"keyPair.publicKey()");
        this.nodeId = EthereumNodeRecord.Companion.nodeId((SECP256K1.PublicKey)bytesArray);
        bytesArray = new Bytes[2];
        bytesArray[0] = (Bytes)this.nodeId;
        String string = "WHOAREYOU";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        bytesArray[1] = Bytes.wrap((byte[])byArray);
        this.whoAreYouHeader = Hash.sha2_256((Bytes)Bytes.concatenate((Bytes[])bytesArray));
        this.tokens = new ArrayList();
    }

    public /* synthetic */ HandshakeSession(SECP256K1.KeyPair keyPair, SocketAddress socketAddress, SECP256K1.PublicKey publicKey, Function2 function2, Function0 function0, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            publicKey = null;
        }
        this(keyPair, socketAddress, publicKey, (Function2<? super SocketAddress, ? super Bytes, Unit>)function2, (Function0<EthereumNodeRecord>)function0, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Nullable
    public final Bytes getRequestId() {
        return this.requestId;
    }

    public final void setRequestId(@Nullable Bytes bytes) {
        this.requestId = bytes;
    }

    @Nullable
    public final EthereumNodeRecord getReceivedEnr() {
        return this.receivedEnr;
    }

    public final void setReceivedEnr(@Nullable EthereumNodeRecord ethereumNodeRecord) {
        this.receivedEnr = ethereumNodeRecord;
    }

    @NotNull
    public final Bytes32 getNodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Object connect(@NotNull Continuation<? super AsyncResult<SessionKey>> $completion) {
        RandomMessage message = new RandomMessage(null, null, 3, null);
        this.tokens.add(message.getAuthTag());
        Bytes32 tag = this.tag();
        Bytes rlpAuthTag = RLP.encodeValue((Bytes)message.getAuthTag());
        Bytes[] bytesArray = new Bytes[]{(Bytes)tag, rlpAuthTag, message.toRLP()};
        Bytes content = Bytes.concatenate((Bytes[])bytesArray);
        logger.trace("Sending random packet {} {}", (Object)this.address, (Object)content);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
        this.sendFn.invoke((Object)this.address, (Object)content);
        return this.connected;
    }

    @Nullable
    public final Object processMessage(@NotNull Bytes messageBytes, @NotNull Continuation<? super Unit> $completion) {
        if (messageBytes.size() > 1280) {
            logger.trace("Message too long, dropping from {}", (Object)this.address);
            return Unit.INSTANCE;
        }
        if (messageBytes.size() < 32) {
            logger.trace("Message too short, dropping from {}", (Object)this.address);
        }
        logger.trace("Received message from {}", (Object)this.address);
        Bytes tag = messageBytes.slice(0, 32);
        Bytes content = messageBytes.slice(32);
        if (Intrinsics.areEqual((Object)this.whoAreYouHeader, (Object)tag)) {
            logger.trace("Identified a WHOAREYOU message");
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
            WhoAreYouMessage message = WhoAreYouMessage.Companion.create(tag, content);
            if (!this.tokens.contains(message.getToken())) {
                logger.trace("Unexpected WHOAREYOU packet {}", (Object)message.getToken());
                return Unit.INSTANCE;
            }
            SECP256K1.KeyPair ephemeralKeyPair = SECP256K1.KeyPair.random();
            SECP256K1.SecretKey ephemeralKey = ephemeralKeyPair.secretKey();
            SECP256K1.PublicKey publicKey = this.publicKey;
            Intrinsics.checkNotNull((Object)publicKey);
            Bytes32 destNodeId = EthereumNodeRecord.Companion.nodeId(publicKey);
            Bytes bytes = (Bytes)ephemeralKey.bytes();
            SECP256K1.PublicKey publicKey2 = this.publicKey;
            Intrinsics.checkNotNull((Object)publicKey2);
            Bytes secret = SECP256K1.deriveECDHKeyAgreement((Bytes)bytes, (Bytes)publicKey2.bytes());
            Bytes bytes2 = (Bytes)this.getNodeId();
            Bytes bytes3 = (Bytes)destNodeId;
            Intrinsics.checkNotNullExpressionValue((Object)secret, (String)"secret");
            SessionKey newSession2 = SessionKeyGenerator.INSTANCE.generate(bytes2, bytes3, secret, message.getIdNonce());
            Bytes[] bytesArray = new Bytes[]{HandshakeSessionKt.access$getDISCOVERY_ID_NONCE$p(), message.getIdNonce(), ephemeralKeyPair.publicKey().bytes()};
            Bytes signValue = Bytes.concatenate((Bytes[])bytesArray);
            SECP256K1.Signature signature = SECP256K1.signHashed((Bytes32)Hash.sha2_256((Bytes)signValue), (SECP256K1.KeyPair)this.keyPair);
            Bytes plain = RLP.encodeList(arg_0 -> HandshakeSession.processMessage$lambda-0(signature, this, arg_0));
            Bytes zeroNonce = Bytes.wrap((byte[])new byte[12]);
            Bytes bytes4 = newSession2.getAuthRespKey();
            Intrinsics.checkNotNullExpressionValue((Object)zeroNonce, (String)"zeroNonce");
            Intrinsics.checkNotNullExpressionValue((Object)plain, (String)"plain");
            Bytes bytes5 = Bytes.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bytes5, (String)"EMPTY");
            Bytes authResponse = AES128GCM.INSTANCE.encrypt(bytes4, zeroNonce, plain, bytes5);
            Bytes authTag = Message.Companion.authTag();
            Bytes32 newTag = this.tag();
            FindNodeMessage findNode = new FindNodeMessage(null, 0, 3, null);
            this.setRequestId(findNode.getRequestId());
            Bytes bytes6 = newSession2.getInitiatorKey();
            Bytes[] bytesArray2 = new Bytes[2];
            byte[] byArray = new byte[]{MessageType.FINDNODE.byte()};
            bytesArray2[0] = Bytes.of((byte[])byArray);
            bytesArray2[1] = findNode.toRLP();
            Bytes bytes7 = Bytes.concatenate((Bytes[])bytesArray2);
            Intrinsics.checkNotNullExpressionValue((Object)bytes7, (String)"concatenate(Bytes.of(Mes\u2026yte()), findNode.toRLP())");
            Bytes encryptedMessage = AES128GCM.INSTANCE.encrypt(bytes6, authTag, bytes7, (Bytes)newTag);
            bytesArray2 = new Bytes[]{(Bytes)newTag, RLP.encodeList(arg_0 -> HandshakeSession.processMessage$lambda-1(authTag, message, ephemeralKeyPair, authResponse, arg_0)), encryptedMessage};
            Bytes response = Bytes.concatenate((Bytes[])bytesArray2);
            logger.trace("Sending handshake FindNode {}", (Object)response);
            this.connected.complete((Object)newSession2);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            Object object = this.sendFn.invoke((Object)this.address, (Object)response);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        } else {
            Boolean hasHeader = (Boolean)RLP.decode((Bytes)content, RLPReader::nextIsList);
            Intrinsics.checkNotNullExpressionValue((Object)hasHeader, (String)"hasHeader");
            if (hasHeader.booleanValue()) {
                logger.trace("Identified a valid message");
                Object object = RLP.decodeList((Bytes)content, arg_0 -> HandshakeSession.processMessage$lambda-4(this, tag, arg_0));
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            } else {
                logger.trace("Identified a RANDOM message");
                Bytes token = RLP.decodeValue((Bytes)content);
                Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
                Bytes peerNodeId = Message.Companion.getSourceFromTag(tag, (Bytes)this.getNodeId());
                logger.trace("Found peerNodeId " + peerNodeId);
                Bytes[] secret = new Bytes[2];
                secret[0] = peerNodeId;
                String string = "WHOAREYOU";
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                secret[1] = Bytes.wrap((byte[])byArray);
                Bytes32 whoAreYouTag = Hash.sha2_256((Bytes)Bytes.concatenate((Bytes[])secret));
                Intrinsics.checkNotNullExpressionValue((Object)whoAreYouTag, (String)"whoAreYouTag");
                Bytes bytes = (Bytes)whoAreYouTag;
                Intrinsics.checkNotNullExpressionValue((Object)token, (String)"token");
                WhoAreYouMessage response = new WhoAreYouMessage(bytes, token, Message.Companion.idNonce(), ((EthereumNodeRecord)this.enr.invoke()).seq());
                this.tokens.add(token);
                logger.trace("Sending WHOAREYOU to {}", (Object)this.address);
                Object object = this.sendFn.invoke((Object)this.address, (Object)response.toRLP());
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
        }
        return Unit.INSTANCE;
    }

    private final boolean verifySignature(Bytes signatureBytes, Bytes idNonce, SECP256K1.PublicKey ephemeralPublicKey, SECP256K1.PublicKey publicKey) {
        SECP256K1.Signature signature = SECP256K1.Signature.create((byte)1, (BigInteger)signatureBytes.slice(0, 32).toUnsignedBigInteger(), (BigInteger)signatureBytes.slice(32).toUnsignedBigInteger());
        Bytes[] bytesArray = new Bytes[]{HandshakeSessionKt.access$getDISCOVERY_ID_NONCE$p(), idNonce, ephemeralPublicKey.bytes()};
        Bytes signValue = Bytes.concatenate((Bytes[])bytesArray);
        Bytes32 hashedSignValue = Hash.sha2_256((Bytes)signValue);
        if (!SECP256K1.verifyHashed((Bytes32)hashedSignValue, (SECP256K1.Signature)signature, (SECP256K1.PublicKey)publicKey)) {
            SECP256K1.Signature signature0 = SECP256K1.Signature.create((byte)0, (BigInteger)signatureBytes.slice(0, 32).toUnsignedBigInteger(), (BigInteger)signatureBytes.slice(32).toUnsignedBigInteger());
            return SECP256K1.verifyHashed((Bytes32)hashedSignValue, (SECP256K1.Signature)signature0, (SECP256K1.PublicKey)publicKey);
        }
        return true;
    }

    @NotNull
    public final AsyncResult<SessionKey> awaitConnection() {
        return (AsyncResult)this.connected;
    }

    @NotNull
    public final Bytes32 tag() {
        SECP256K1.PublicKey publicKey = this.publicKey;
        Intrinsics.checkNotNull((Object)publicKey);
        return Message.Companion.tag(this.nodeId, (Bytes)EthereumNodeRecord.Companion.nodeId(publicKey));
    }

    private static final void processMessage$lambda-0(SECP256K1.Signature $signature, HandshakeSession this$0, RLPWriter writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        writer.writeInt(5);
        Bytes[] bytesArray = new Bytes[]{(Bytes)UInt256.valueOf((BigInteger)$signature.r()).toBytes(), (Bytes)UInt256.valueOf((BigInteger)$signature.s()).toBytes()};
        writer.writeValue(Bytes.concatenate((Bytes[])bytesArray));
        writer.writeRLP(((EthereumNodeRecord)this$0.enr.invoke()).toRLP());
    }

    private static final void processMessage$lambda-1(Bytes $authTag, WhoAreYouMessage $message, SECP256K1.KeyPair $ephemeralKeyPair, Bytes $authResponse, RLPWriter it) {
        Intrinsics.checkNotNullParameter((Object)$authTag, (String)"$authTag");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$authResponse, (String)"$authResponse");
        it.writeValue($authTag);
        it.writeValue($message.getIdNonce());
        String string = "gcm";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        it.writeValue(Bytes.wrap((byte[])byArray));
        it.writeValue($ephemeralKeyPair.publicKey().bytes());
        it.writeValue($authResponse);
    }

    private static final EthereumNodeRecord processMessage$lambda-4$lambda-3$lambda-2(RLPReader enrReader) {
        Intrinsics.checkNotNullExpressionValue((Object)enrReader, (String)"enrReader");
        return EthereumNodeRecord.Companion.fromRLP(enrReader);
    }

    private static final Boolean processMessage$lambda-4$lambda-3(HandshakeSession this$0, Bytes $idNonce, SECP256K1.PublicKey $ephemeralPublicKey, SessionKey $sessionKey, RLPReader reader) {
        EthereumNodeRecord enr;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sessionKey, (String)"$sessionKey");
        reader.skipNext();
        Bytes signatureBytes = reader.readValue();
        this$0.receivedEnr = enr = (EthereumNodeRecord)reader.readList(HandshakeSession::processMessage$lambda-4$lambda-3$lambda-2);
        this$0.publicKey = enr.publicKey();
        Intrinsics.checkNotNullExpressionValue((Object)signatureBytes, (String)"signatureBytes");
        Intrinsics.checkNotNullExpressionValue((Object)$idNonce, (String)"idNonce");
        Intrinsics.checkNotNullExpressionValue((Object)$ephemeralPublicKey, (String)"ephemeralPublicKey");
        boolean signatureVerified = this$0.verifySignature(signatureBytes, $idNonce, $ephemeralPublicKey, enr.publicKey());
        if (!signatureVerified) {
            throw new IllegalArgumentException("Signature is not verified");
        }
        logger.trace("Finalized handshake");
        return this$0.connected.complete((Object)$sessionKey);
    }

    private static final Boolean processMessage$lambda-4(HandshakeSession this$0, Bytes $tag, RLPReader it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.skipNext();
        Bytes idNonce = it.readValue();
        it.skipNext();
        SECP256K1.PublicKey ephemeralPublicKey = SECP256K1.PublicKey.fromBytes((Bytes)it.readValue());
        Bytes authResponse = it.readValue();
        Bytes secret = SECP256K1.deriveECDHKeyAgreement((Bytes)((Bytes)this$0.keyPair.secretKey().bytes()), (Bytes)ephemeralPublicKey.bytes());
        Intrinsics.checkNotNullExpressionValue((Object)$tag, (String)"tag");
        Bytes senderNodeId = Message.Companion.getSourceFromTag($tag, (Bytes)this$0.nodeId);
        Bytes bytes = (Bytes)this$0.nodeId;
        Intrinsics.checkNotNullExpressionValue((Object)secret, (String)"secret");
        Intrinsics.checkNotNullExpressionValue((Object)idNonce, (String)"idNonce");
        SessionKey sessionKey = SessionKeyGenerator.INSTANCE.generate(senderNodeId, bytes, secret, idNonce);
        Bytes[] bytesArray = new Bytes[1];
        Bytes bytes2 = sessionKey.getAuthRespKey();
        Bytes bytes3 = Bytes.wrap((byte[])new byte[12]);
        Intrinsics.checkNotNullExpressionValue((Object)bytes3, (String)"wrap(ByteArray(12))");
        Bytes bytes4 = bytes3;
        Intrinsics.checkNotNullExpressionValue((Object)authResponse, (String)"authResponse");
        bytes3 = Bytes.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)bytes3, (String)"EMPTY");
        bytesArray[0] = AES128GCM.INSTANCE.decrypt(bytes2, bytes4, authResponse, bytes3);
        Bytes decryptedAuthResponse = Bytes.wrap((Bytes[])bytesArray);
        return (Boolean)RLP.decodeList((Bytes)decryptedAuthResponse, arg_0 -> HandshakeSession.processMessage$lambda-4$lambda-3(this$0, idNonce, ephemeralPublicKey, sessionKey, arg_0));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/devp2p/v5/HandshakeSession$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

