/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.handshake;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Box;
import org.apache.tuweni.crypto.sodium.Concatenate;
import org.apache.tuweni.crypto.sodium.DiffieHelman;
import org.apache.tuweni.crypto.sodium.HMACSHA512256;
import org.apache.tuweni.crypto.sodium.SHA256Hash;
import org.apache.tuweni.crypto.sodium.SecretBox;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.handshake.HandshakeException;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStream;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamServer;

public final class SecureScuttlebuttHandshakeServer {
    private final Signature.KeyPair longTermKeyPair;
    private final Box.KeyPair ephemeralKeyPair;
    private final HMACSHA512256.Key networkIdentifier;
    private Box.PublicKey clientEphemeralPublicKey;
    private DiffieHelman.Secret sharedSecret;
    private DiffieHelman.Secret sharedSecret2;
    private Signature.PublicKey clientLongTermPublicKey;
    private DiffieHelman.Secret sharedSecret3;
    private Allocated detachedSignature;

    public static SecureScuttlebuttHandshakeServer create(Signature.KeyPair ourKeyPair, Bytes32 networkIdentifier) {
        return new SecureScuttlebuttHandshakeServer(ourKeyPair, networkIdentifier);
    }

    private SecureScuttlebuttHandshakeServer(Signature.KeyPair longTermKeyPair, Bytes32 networkIdentifier) {
        this.longTermKeyPair = longTermKeyPair;
        this.ephemeralKeyPair = Box.KeyPair.random();
        this.networkIdentifier = HMACSHA512256.Key.fromBytes((Bytes)networkIdentifier);
    }

    public Bytes createHello() {
        Bytes hmac = HMACSHA512256.authenticate((Bytes)this.ephemeralKeyPair.publicKey().bytes(), (HMACSHA512256.Key)this.networkIdentifier);
        return Bytes.concatenate((Bytes[])new Bytes[]{hmac, this.ephemeralKeyPair.publicKey().bytes()});
    }

    public void readHello(Bytes message) {
        Bytes key;
        if (message.size() != 64) {
            throw new HandshakeException("Invalid handshake message length: " + message.size());
        }
        Bytes hmac = message.slice(0, 32);
        if (!HMACSHA512256.verify((Bytes)hmac, (Bytes)(key = message.slice(32, 32)), (HMACSHA512256.Key)this.networkIdentifier)) {
            throw new HandshakeException("MAC does not match our network identifier");
        }
        this.clientEphemeralPublicKey = Box.PublicKey.fromBytes((Bytes)key);
        this.computeSharedSecrets();
    }

    void computeSharedSecrets() {
        this.sharedSecret = DiffieHelman.Secret.forKeys((DiffieHelman.SecretKey)DiffieHelman.SecretKey.forBoxSecretKey((Box.SecretKey)this.ephemeralKeyPair.secretKey()), (DiffieHelman.PublicKey)DiffieHelman.PublicKey.forBoxPublicKey((Box.PublicKey)this.clientEphemeralPublicKey));
        this.sharedSecret2 = DiffieHelman.Secret.forKeys((DiffieHelman.SecretKey)DiffieHelman.SecretKey.forSignatureSecretKey((Signature.SecretKey)this.longTermKeyPair.secretKey()), (DiffieHelman.PublicKey)DiffieHelman.PublicKey.forBoxPublicKey((Box.PublicKey)this.clientEphemeralPublicKey));
    }

    DiffieHelman.Secret sharedSecret() {
        return this.sharedSecret;
    }

    DiffieHelman.Secret sharedSecret2() {
        return this.sharedSecret2;
    }

    DiffieHelman.Secret sharedSecret3() {
        return this.sharedSecret3;
    }

    Signature.PublicKey clientLongTermPublicKey() {
        return this.clientLongTermPublicKey;
    }

    public void readIdentityMessage(Bytes message) {
        Bytes plaintext = SecretBox.decrypt((Bytes)message, (SecretBox.Key)SecretBox.Key.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).concatenate()))), (SecretBox.Nonce)SecretBox.Nonce.fromBytes((byte[])new byte[24]));
        if (plaintext == null) {
            throw new HandshakeException("Could not decrypt the plaintext with our shared secrets");
        }
        if (plaintext.size() != 96) {
            throw new HandshakeException("Identity message should be 96 bytes long, was " + plaintext.size());
        }
        this.detachedSignature = Allocated.fromBytes((Bytes)plaintext.slice(0, 64));
        this.clientLongTermPublicKey = Signature.PublicKey.fromBytes((Bytes)plaintext.slice(64, 32));
        boolean verified = this.clientLongTermPublicKey.verify(new Concatenate().add(this.networkIdentifier).add(this.longTermKeyPair.publicKey()).add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromSecret((DiffieHelman.Secret)this.sharedSecret))).concatenate(), this.detachedSignature);
        if (!verified) {
            throw new HandshakeException("Identity message signature does not match");
        }
        this.sharedSecret3 = DiffieHelman.Secret.forKeys((DiffieHelman.SecretKey)DiffieHelman.SecretKey.forBoxSecretKey((Box.SecretKey)this.ephemeralKeyPair.secretKey()), (DiffieHelman.PublicKey)DiffieHelman.PublicKey.forSignaturePublicKey((Signature.PublicKey)this.clientLongTermPublicKey));
    }

    public Bytes createAcceptMessage() {
        Allocated signature = Signature.signDetached((Allocated)new Concatenate().add(this.networkIdentifier).add(this.detachedSignature).add(this.clientLongTermPublicKey).add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromSecret((DiffieHelman.Secret)this.sharedSecret))).concatenate(), (Signature.SecretKey)this.longTermKeyPair.secretKey());
        return SecretBox.encrypt((Allocated)signature, (SecretBox.Key)SecretBox.Key.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).add(this.sharedSecret3).concatenate()))), (SecretBox.Nonce)SecretBox.Nonce.fromBytes((byte[])new byte[24])).bytes();
    }

    SHA256Hash.Hash clientToServerSecretBoxKey() {
        return SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).add(this.sharedSecret3).concatenate()))))).add(this.longTermKeyPair.publicKey()).concatenate()));
    }

    Bytes clientToServerNonce() {
        return HMACSHA512256.authenticate((Bytes)this.ephemeralKeyPair.publicKey().bytes(), (HMACSHA512256.Key)this.networkIdentifier).slice(0, 24);
    }

    SHA256Hash.Hash serverToClientSecretBoxKey() {
        return SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromHash((SHA256Hash.Hash)SHA256Hash.hash((SHA256Hash.Input)SHA256Hash.Input.fromPointer((Allocated)new Concatenate().add(this.networkIdentifier).add(this.sharedSecret).add(this.sharedSecret2).add(this.sharedSecret3).concatenate()))))).add(this.clientLongTermPublicKey).concatenate()));
    }

    Bytes serverToClientNonce() {
        return HMACSHA512256.authenticate((Bytes)this.clientEphemeralPublicKey.bytes(), (HMACSHA512256.Key)this.networkIdentifier).slice(0, 24);
    }

    public SecureScuttlebuttStreamServer createStream() {
        return new SecureScuttlebuttStream(this.clientToServerSecretBoxKey(), this.clientToServerNonce(), this.serverToClientSecretBoxKey(), this.serverToClientNonce());
    }
}

