/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.handshake.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import java.net.InetSocketAddress;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.handshake.HandshakeException;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttHandshakeServer;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamServer;
import org.apache.tuweni.scuttlebutt.handshake.StreamException;
import org.apache.tuweni.scuttlebutt.handshake.vertx.ServerHandler;
import org.apache.tuweni.scuttlebutt.handshake.vertx.ServerHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecureScuttlebuttVertxServer {
    private static final Logger logger = LoggerFactory.getLogger(SecureScuttlebuttVertxServer.class);
    private final Vertx vertx;
    private final InetSocketAddress addr;
    private final Signature.KeyPair keyPair;
    private final Bytes32 networkIdentifier;
    private NetServer server;
    private final ServerHandlerFactory handlerFactory;

    private int getBodyLength(Bytes rpcHeader) {
        Bytes size = rpcHeader.slice(1, 4);
        return size.toInt();
    }

    public SecureScuttlebuttVertxServer(Vertx vertx, InetSocketAddress addr, Signature.KeyPair keyPair, Bytes32 networkIdentifier, ServerHandlerFactory handlerFactory) {
        this.vertx = vertx;
        this.addr = addr;
        this.keyPair = keyPair;
        this.networkIdentifier = networkIdentifier;
        this.handlerFactory = handlerFactory;
    }

    public AsyncCompletion start() {
        this.server = this.vertx.createNetServer(new NetServerOptions().setTcpKeepAlive(true).setHost(this.addr.getHostString()).setPort(this.addr.getPort()));
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.server.connectHandler(new NetSocketHandler()::handle);
        this.server.listen(res -> {
            if (res.failed()) {
                completion.completeExceptionally(res.cause());
            } else {
                completion.complete();
            }
        });
        return completion;
    }

    public AsyncCompletion stop() {
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.server.close(res -> {
            if (res.failed()) {
                completion.completeExceptionally(res.cause());
            } else {
                completion.complete();
            }
        });
        return completion;
    }

    public int getPort() {
        if (this.server == null) {
            return 0;
        }
        return this.server.actualPort();
    }

    private final class NetSocketHandler {
        int handshakeCounter = 0;
        NetSocket netSocket;
        ServerHandler handler;
        SecureScuttlebuttStreamServer streamServer;
        SecureScuttlebuttHandshakeServer handshakeServer;
        private Bytes messageBuffer;

        private NetSocketHandler() {
            this.handshakeServer = SecureScuttlebuttHandshakeServer.create(SecureScuttlebuttVertxServer.this.keyPair, SecureScuttlebuttVertxServer.this.networkIdentifier);
            this.messageBuffer = Bytes.EMPTY;
        }

        void handle(NetSocket netSocket) {
            this.netSocket = netSocket;
            netSocket.closeHandler(res -> {
                if (this.handler != null) {
                    this.handler.streamClosed();
                }
            });
            netSocket.exceptionHandler(e -> logger.error(e.getMessage(), e));
            netSocket.handler(this::handleMessage);
        }

        private void handleMessage(Buffer buffer) {
            block8: {
                try {
                    if (this.handshakeCounter == 0) {
                        this.handshakeServer.readHello(Bytes.wrapBuffer((Buffer)buffer));
                        this.netSocket.write((Object)Buffer.buffer((byte[])this.handshakeServer.createHello().toArrayUnsafe()));
                        ++this.handshakeCounter;
                        break block8;
                    }
                    if (this.handshakeCounter == 1) {
                        this.handshakeServer.readIdentityMessage(Bytes.wrapBuffer((Buffer)buffer));
                        this.netSocket.write((Object)Buffer.buffer((byte[])this.handshakeServer.createAcceptMessage().toArrayUnsafe()));
                        this.streamServer = this.handshakeServer.createStream();
                        ++this.handshakeCounter;
                        this.handler = SecureScuttlebuttVertxServer.this.handlerFactory.createHandler(bytes -> {
                            NetSocketHandler netSocketHandler = this;
                            synchronized (netSocketHandler) {
                                this.netSocket.write((Object)Buffer.buffer((byte[])this.streamServer.sendToClient((Bytes)bytes).toArrayUnsafe()));
                            }
                        }, () -> {
                            NetSocketHandler netSocketHandler = this;
                            synchronized (netSocketHandler) {
                                this.netSocket.write((Object)Buffer.buffer((byte[])this.streamServer.sendGoodbyeToClient().toArrayUnsafe()));
                                this.netSocket.close();
                            }
                        });
                        break block8;
                    }
                    Bytes message = this.streamServer.readFromClient(Bytes.wrapBuffer((Buffer)buffer));
                    this.messageBuffer = Bytes.concatenate((Bytes[])new Bytes[]{this.messageBuffer, message});
                    int headerSize = 9;
                    while (this.messageBuffer.size() >= headerSize) {
                        Bytes header = this.messageBuffer.slice(0, 9);
                        int bodyLength = SecureScuttlebuttVertxServer.this.getBodyLength(header);
                        if (this.messageBuffer.size() - headerSize >= bodyLength) {
                            int headerAndBodyLength = bodyLength + headerSize;
                            Bytes wholeMessage = this.messageBuffer.slice(0, headerAndBodyLength);
                            if (SecureScuttlebuttStreamServer.isGoodbye(wholeMessage)) {
                                this.netSocket.close();
                            } else {
                                this.handler.receivedMessage(wholeMessage.slice(9));
                            }
                            this.messageBuffer = this.messageBuffer.slice(headerAndBodyLength);
                            continue;
                        }
                        break;
                    }
                }
                catch (HandshakeException | StreamException e) {
                    this.netSocket.close();
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }
}

