/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.handshake.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Invite;
import org.apache.tuweni.scuttlebutt.handshake.HandshakeException;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttHandshakeClient;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamClient;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamServer;
import org.apache.tuweni.scuttlebutt.handshake.StreamException;
import org.apache.tuweni.scuttlebutt.handshake.vertx.ClientHandler;
import org.apache.tuweni.scuttlebutt.handshake.vertx.ClientHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecureScuttlebuttVertxClient {
    private static final Logger logger = LoggerFactory.getLogger(NetSocketClientHandler.class);
    private final Vertx vertx;
    private final Signature.KeyPair keyPair;
    private final Bytes32 networkIdentifier;
    private NetClient client;

    private int getBodyLength(Bytes rpcHeader) {
        Bytes size = rpcHeader.slice(1, 4);
        return size.toInt();
    }

    public SecureScuttlebuttVertxClient(Vertx vertx, Signature.KeyPair keyPair, Bytes32 networkIdentifier) {
        this.vertx = vertx;
        this.keyPair = keyPair;
        this.networkIdentifier = networkIdentifier;
    }

    public <T extends ClientHandler> AsyncResult<T> connectTo(int port, String host, @Nullable Signature.PublicKey remotePublicKey, @Nullable Invite invite, ClientHandlerFactory<T> handlerFactory) {
        this.client = this.vertx.createNetClient(new NetClientOptions().setTcpKeepAlive(true));
        CompletableAsyncResult completion = AsyncResult.incomplete();
        this.client.connect(port, host, res -> {
            if (res.failed()) {
                completion.completeExceptionally(res.cause());
            } else {
                NetSocket socket = (NetSocket)res.result();
                new NetSocketClientHandler(socket, remotePublicKey, invite, handlerFactory, completion);
            }
        });
        return completion;
    }

    public AsyncCompletion stop() {
        this.client.close();
        return AsyncCompletion.completed();
    }

    private class NetSocketClientHandler<T extends ClientHandler> {
        private final NetSocket socket;
        private final SecureScuttlebuttHandshakeClient handshakeClient;
        private final ClientHandlerFactory<T> handlerFactory;
        private final CompletableAsyncResult<T> completionHandle;
        private int handshakeCounter;
        private SecureScuttlebuttStreamClient client;
        private T handler;
        private Bytes messageBuffer = Bytes.EMPTY;

        NetSocketClientHandler(NetSocket socket, @Nullable Signature.PublicKey remotePublicKey, Invite invite, ClientHandlerFactory<T> handlerFactory, CompletableAsyncResult<T> completionHandle) {
            this.socket = socket;
            this.handshakeClient = invite != null ? SecureScuttlebuttHandshakeClient.fromInvite(SecureScuttlebuttVertxClient.this.networkIdentifier, invite) : SecureScuttlebuttHandshakeClient.create(SecureScuttlebuttVertxClient.this.keyPair, SecureScuttlebuttVertxClient.this.networkIdentifier, remotePublicKey);
            this.handlerFactory = handlerFactory;
            this.completionHandle = completionHandle;
            socket.closeHandler(res -> {
                if (this.handler != null) {
                    this.handler.streamClosed();
                }
                if (!completionHandle.isDone()) {
                    completionHandle.completeExceptionally((Throwable)new IllegalStateException("Connection closed before handshake"));
                }
            });
            socket.exceptionHandler(e -> logger.error(e.getMessage(), e));
            socket.handler(this::handle);
            socket.write((Object)Buffer.buffer((byte[])this.handshakeClient.createHello().toArrayUnsafe()));
        }

        void handle(Buffer buffer) {
            block10: {
                try {
                    if (this.handshakeCounter == 0) {
                        this.handshakeClient.readHello(Bytes.wrapBuffer((Buffer)buffer));
                        this.socket.write((Object)Buffer.buffer((byte[])this.handshakeClient.createIdentityMessage().toArrayUnsafe()));
                        ++this.handshakeCounter;
                        break block10;
                    }
                    if (this.handshakeCounter == 1) {
                        this.handshakeClient.readAcceptMessage(Bytes.wrapBuffer((Buffer)buffer));
                        this.client = this.handshakeClient.createStream();
                        this.handler = this.handlerFactory.createHandler(bytes -> {
                            NetSocketClientHandler netSocketClientHandler = this;
                            synchronized (netSocketClientHandler) {
                                this.socket.write((Object)Buffer.buffer((byte[])this.client.sendToServer((Bytes)bytes).toArrayUnsafe()));
                            }
                        }, () -> {
                            NetSocketClientHandler netSocketClientHandler = this;
                            synchronized (netSocketClientHandler) {
                                this.socket.write((Object)Buffer.buffer((byte[])this.client.sendGoodbyeToServer().toArrayUnsafe()));
                                this.socket.close();
                            }
                        });
                        this.completionHandle.complete(this.handler);
                        ++this.handshakeCounter;
                        break block10;
                    }
                    Bytes message = this.client.readFromServer(Bytes.wrapBuffer((Buffer)buffer));
                    this.messageBuffer = Bytes.concatenate((Bytes[])new Bytes[]{this.messageBuffer, message});
                    int headerSize = 9;
                    while (this.messageBuffer.size() >= headerSize) {
                        Bytes header = this.messageBuffer.slice(0, 9);
                        int bodyLength = SecureScuttlebuttVertxClient.this.getBodyLength(header);
                        if (this.messageBuffer.size() - headerSize >= bodyLength) {
                            int headerAndBodyLength = bodyLength + headerSize;
                            Bytes wholeMessage = this.messageBuffer.slice(0, headerAndBodyLength);
                            if (SecureScuttlebuttStreamServer.isGoodbye(wholeMessage)) {
                                logger.debug("Goodbye received from remote peer");
                                this.socket.close();
                            } else {
                                this.handler.receivedMessage(wholeMessage);
                            }
                            this.messageBuffer = this.messageBuffer.slice(headerAndBodyLength);
                            continue;
                        }
                        break;
                    }
                }
                catch (HandshakeException | StreamException e) {
                    this.completionHandle.completeExceptionally((Throwable)e);
                    logger.debug(e.getMessage(), (Throwable)e);
                    this.socket.close();
                }
                catch (Throwable t) {
                    if (!this.completionHandle.isDone()) {
                        this.completionHandle.completeExceptionally(t);
                    }
                    logger.error(t.getMessage(), t);
                    throw new RuntimeException(t);
                }
            }
        }
    }
}

