/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.plumtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuweni.plumtree.Peer;
import org.apache.tuweni.plumtree.PeerRepository;

public final class EphemeralPeerRepository
implements PeerRepository {
    private final Set<Peer> eagerPushPeers = ConcurrentHashMap.newKeySet();
    private final Set<Peer> lazyPushPeers = ConcurrentHashMap.newKeySet();

    @Override
    public void addEager(Peer peer) {
        this.eagerPushPeers.add(peer);
    }

    @Override
    public List<Peer> peers() {
        ArrayList<Peer> peers = new ArrayList<Peer>(this.eagerPushPeers);
        peers.addAll(this.lazyPushPeers);
        return peers;
    }

    @Override
    public Collection<Peer> lazyPushPeers() {
        return this.lazyPushPeers;
    }

    @Override
    public Collection<Peer> eagerPushPeers() {
        return this.eagerPushPeers;
    }

    @Override
    public void removePeer(Peer peer) {
        this.lazyPushPeers.remove(peer);
        this.eagerPushPeers.remove(peer);
    }

    @Override
    public boolean moveToLazy(Peer peer) {
        this.eagerPushPeers.remove(peer);
        this.lazyPushPeers.add(peer);
        return true;
    }

    @Override
    public void moveToEager(Peer peer) {
        this.lazyPushPeers.remove(peer);
        this.eagerPushPeers.add(peer);
    }

    @Override
    public void considerNewPeer(Peer peer) {
        if (!this.lazyPushPeers.contains(peer)) {
            this.eagerPushPeers.add(peer);
        }
    }
}

