/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JK\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\t\u0010#\u001a\u00020$H\u00d6\u0001J\b\u0010\u0004\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/apache/tuweni/devp2p/eth/SimpleBlockchainInformation;", "Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;", "networkID", "Lorg/apache/tuweni/units/bigints/UInt256;", "totalDifficulty", "bestHash", "Lorg/apache/tuweni/eth/Hash;", "bestNumber", "genesisHash", "forks", "", "", "(Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Ljava/util/List;)V", "getBestHash", "()Lorg/apache/tuweni/eth/Hash;", "getBestNumber", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getForks", "()Ljava/util/List;", "getGenesisHash", "getNetworkID", "getTotalDifficulty", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "devp2p-eth"})
public final class SimpleBlockchainInformation
implements BlockchainInformation {
    @NotNull
    private final UInt256 networkID;
    @NotNull
    private final UInt256 totalDifficulty;
    @NotNull
    private final Hash bestHash;
    @NotNull
    private final UInt256 bestNumber;
    @NotNull
    private final Hash genesisHash;
    @NotNull
    private final List<Long> forks;

    public SimpleBlockchainInformation(@NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull UInt256 bestNumber, @NotNull Hash genesisHash, @NotNull List<Long> forks) {
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)bestNumber, (String)"bestNumber");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        Intrinsics.checkNotNullParameter(forks, (String)"forks");
        this.networkID = networkID;
        this.totalDifficulty = totalDifficulty;
        this.bestHash = bestHash;
        this.bestNumber = bestNumber;
        this.genesisHash = genesisHash;
        this.forks = forks;
    }

    @NotNull
    public final UInt256 getNetworkID() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 getTotalDifficulty() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash getBestHash() {
        return this.bestHash;
    }

    @NotNull
    public final UInt256 getBestNumber() {
        return this.bestNumber;
    }

    @NotNull
    public final Hash getGenesisHash() {
        return this.genesisHash;
    }

    @NotNull
    public final List<Long> getForks() {
        return this.forks;
    }

    @Override
    @NotNull
    public UInt256 networkID() {
        return this.networkID;
    }

    @Override
    @NotNull
    public UInt256 totalDifficulty() {
        return this.totalDifficulty;
    }

    @Override
    @NotNull
    public Hash bestHash() {
        return this.bestHash;
    }

    @Override
    @NotNull
    public UInt256 bestNumber() {
        return this.bestNumber;
    }

    @Override
    @NotNull
    public Hash genesisHash() {
        return this.genesisHash;
    }

    @Override
    @NotNull
    public List<Long> forks() {
        return this.forks;
    }

    @Override
    @Nullable
    public Long getLatestFork() {
        return BlockchainInformation.DefaultImpls.getLatestFork(this);
    }

    @Override
    @NotNull
    public List<Bytes> getForkHashes() {
        return BlockchainInformation.DefaultImpls.getForkHashes(this);
    }

    @Override
    @Nullable
    public Bytes getLatestForkHash() {
        return BlockchainInformation.DefaultImpls.getLatestForkHash(this);
    }

    @NotNull
    public final UInt256 component1() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 component2() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash component3() {
        return this.bestHash;
    }

    @NotNull
    public final UInt256 component4() {
        return this.bestNumber;
    }

    @NotNull
    public final Hash component5() {
        return this.genesisHash;
    }

    @NotNull
    public final List<Long> component6() {
        return this.forks;
    }

    @NotNull
    public final SimpleBlockchainInformation copy(@NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull UInt256 bestNumber, @NotNull Hash genesisHash, @NotNull List<Long> forks) {
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)bestNumber, (String)"bestNumber");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        Intrinsics.checkNotNullParameter(forks, (String)"forks");
        return new SimpleBlockchainInformation(networkID, totalDifficulty, bestHash, bestNumber, genesisHash, forks);
    }

    public static /* synthetic */ SimpleBlockchainInformation copy$default(SimpleBlockchainInformation simpleBlockchainInformation, UInt256 uInt256, UInt256 uInt2562, Hash hash, UInt256 uInt2563, Hash hash2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            uInt256 = simpleBlockchainInformation.networkID;
        }
        if ((n & 2) != 0) {
            uInt2562 = simpleBlockchainInformation.totalDifficulty;
        }
        if ((n & 4) != 0) {
            hash = simpleBlockchainInformation.bestHash;
        }
        if ((n & 8) != 0) {
            uInt2563 = simpleBlockchainInformation.bestNumber;
        }
        if ((n & 0x10) != 0) {
            hash2 = simpleBlockchainInformation.genesisHash;
        }
        if ((n & 0x20) != 0) {
            list = simpleBlockchainInformation.forks;
        }
        return simpleBlockchainInformation.copy(uInt256, uInt2562, hash, uInt2563, hash2, list);
    }

    @NotNull
    public String toString() {
        return "SimpleBlockchainInformation(networkID=" + this.networkID + ", totalDifficulty=" + this.totalDifficulty + ", bestHash=" + this.bestHash + ", bestNumber=" + this.bestNumber + ", genesisHash=" + this.genesisHash + ", forks=" + this.forks + ")";
    }

    public int hashCode() {
        int result = this.networkID.hashCode();
        result = result * 31 + this.totalDifficulty.hashCode();
        result = result * 31 + this.bestHash.hashCode();
        result = result * 31 + this.bestNumber.hashCode();
        result = result * 31 + this.genesisHash.hashCode();
        result = result * 31 + ((Object)this.forks).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleBlockchainInformation)) {
            return false;
        }
        SimpleBlockchainInformation simpleBlockchainInformation = (SimpleBlockchainInformation)other;
        if (!Intrinsics.areEqual((Object)this.networkID, (Object)simpleBlockchainInformation.networkID)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.totalDifficulty, (Object)simpleBlockchainInformation.totalDifficulty)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bestHash, (Object)simpleBlockchainInformation.bestHash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bestNumber, (Object)simpleBlockchainInformation.bestNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.genesisHash, (Object)simpleBlockchainInformation.genesisHash)) {
            return false;
        }
        return Intrinsics.areEqual(this.forks, simpleBlockchainInformation.forks);
    }
}

