/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx.wire;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.rlpx.RLPxMessage;
import org.apache.tuweni.rlpx.wire.Capability;
import org.apache.tuweni.rlpx.wire.DisconnectMessage;
import org.apache.tuweni.rlpx.wire.DisconnectReason;
import org.apache.tuweni.rlpx.wire.HelloMessage;
import org.apache.tuweni.rlpx.wire.SubProtocolHandler;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultWireConnection
implements WireConnection {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWireConnection.class);
    private final Bytes nodeId;
    private final Bytes peerNodeId;
    private final Consumer<RLPxMessage> writer;
    private final Consumer<HelloMessage> afterHandshakeListener;
    private final Runnable disconnectHandler;
    private final LinkedHashMap<SubProtocolIdentifier, SubProtocolHandler> subprotocols;
    private final int p2pVersion;
    private final String clientId;
    private final int advertisedPort;
    private final CompletableAsyncResult<WireConnection> ready;
    private final String peerHost;
    private final int peerPort;
    private final AtomicBoolean disconnectRequested = new AtomicBoolean(false);
    private CompletableAsyncCompletion awaitingPong;
    private HelloMessage myHelloMessage;
    private HelloMessage peerHelloMessage;
    private RangeMap<Integer, SubProtocolIdentifier> subprotocolRangeMap = TreeRangeMap.create();
    private DisconnectReason disconnectReason;
    private boolean disconnectReceived;
    private WireConnection.EventListener eventListener;

    public DefaultWireConnection(Bytes nodeId, Bytes peerNodeId, Consumer<RLPxMessage> writer, Consumer<HelloMessage> afterHandshakeListener, Runnable disconnectHandler, LinkedHashMap<SubProtocolIdentifier, SubProtocolHandler> subprotocols, int p2pVersion, String clientId, int advertisedPort, CompletableAsyncResult<WireConnection> ready, String peerHost, int peerPort) {
        this.nodeId = nodeId;
        this.peerNodeId = peerNodeId;
        this.writer = writer;
        this.afterHandshakeListener = afterHandshakeListener;
        this.disconnectHandler = disconnectHandler;
        this.subprotocols = subprotocols;
        this.p2pVersion = p2pVersion;
        this.clientId = clientId;
        this.advertisedPort = advertisedPort;
        this.ready = ready;
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        logger.debug("New wire connection created");
    }

    public void messageReceived(RLPxMessage message) {
        if (message.messageId() == 0) {
            this.peerHelloMessage = HelloMessage.read(message.content());
            logger.debug("Received peer Hello message {}", (Object)this.peerHelloMessage);
            this.initSupportedRange(this.peerHelloMessage.capabilities());
            if (this.peerHelloMessage.nodeId() == null || this.peerHelloMessage.nodeId().isEmpty()) {
                this.disconnect(DisconnectReason.NULL_NODE_IDENTITY_RECEIVED);
                this.ready.complete((Object)this);
                return;
            }
            if (!this.peerHelloMessage.nodeId().equals(this.peerNodeId)) {
                this.disconnect(DisconnectReason.UNEXPECTED_IDENTITY);
                this.ready.complete((Object)this);
                return;
            }
            if (this.peerHelloMessage.nodeId().equals(this.nodeId)) {
                this.disconnect(DisconnectReason.CONNECTED_TO_SELF);
                this.ready.complete((Object)this);
                return;
            }
            if (this.peerHelloMessage.p2pVersion() > this.p2pVersion) {
                this.disconnect(DisconnectReason.INCOMPATIBLE_DEVP2P_VERSION);
                this.ready.complete((Object)this);
                return;
            }
            if (this.subprotocolRangeMap.asMapOfRanges().isEmpty()) {
                logger.debug("Useless peer detected, caps {}, our caps {}", this.peerHelloMessage.capabilities(), this.subprotocols.keySet());
                this.disconnect(DisconnectReason.USELESS_PEER);
                this.ready.complete((Object)this);
                return;
            }
            if (this.myHelloMessage == null) {
                this.sendHello();
            }
            this.afterHandshakeListener.accept(this.peerHelloMessage);
            AsyncCompletion allSubProtocols = AsyncCompletion.allOf(this.subprotocolRangeMap.asMapOfRanges().values().stream().map(this.subprotocols::get).map(handler -> handler.handleNewPeerConnection(this)));
            allSubProtocols.thenRun(() -> {
                this.ready.complete((Object)this);
                this.eventListener.onEvent(WireConnection.Event.CONNECTED);
            });
            return;
        }
        if (message.messageId() == 1) {
            DisconnectMessage disconnect = DisconnectMessage.read(message.content());
            logger.debug("Received disconnect {}", (Object)disconnect);
            this.disconnectReceived = true;
            this.disconnectReason = DisconnectReason.valueOf(disconnect.reason());
            this.disconnectHandler.run();
            if (!this.ready.isDone()) {
                this.ready.complete((Object)this);
            }
            this.eventListener.onEvent(WireConnection.Event.DISCONNECTED);
            return;
        }
        if (this.peerHelloMessage == null || this.myHelloMessage == null) {
            logger.debug("Message sent before hello exchanged {}", (Object)message.messageId());
            this.disconnect(DisconnectReason.PROTOCOL_BREACH);
        }
        if (message.messageId() == 2) {
            this.sendPong();
        } else if (message.messageId() == 3) {
            if (this.awaitingPong != null) {
                this.awaitingPong.complete();
            }
        } else {
            Map.Entry subProtocolEntry = this.subprotocolRangeMap.getEntry((Comparable)Integer.valueOf(message.messageId()));
            if (subProtocolEntry == null) {
                logger.debug("Unknown message received {}", (Object)message.messageId());
                this.disconnect(DisconnectReason.PROTOCOL_BREACH);
                if (!this.ready.isDone()) {
                    this.ready.complete((Object)this);
                }
            } else {
                int offset = (Integer)((Range)subProtocolEntry.getKey()).lowerEndpoint();
                logger.trace("Received message of type {}", (Object)(message.messageId() - offset));
                SubProtocolHandler handler2 = this.subprotocols.get(subProtocolEntry.getValue());
                try {
                    handler2.handle(this, message.messageId() - offset, message.content());
                }
                catch (Throwable t) {
                    logger.error("Handler " + handler2.toString() + " threw an exception", t);
                }
            }
        }
    }

    void initSupportedRange(List<Capability> capabilities) {
        int startRange = 16;
        HashMap<String, SubProtocolIdentifier> pickedCapabilities = new HashMap<String, SubProtocolIdentifier>();
        for (SubProtocolIdentifier sp : this.subprotocols.keySet()) {
            for (Capability cap : capabilities) {
                SubProtocolIdentifier oldPick;
                if (!sp.equals(SubProtocolIdentifier.of(cap.name(), cap.version())) || (oldPick = (SubProtocolIdentifier)pickedCapabilities.get(cap.name())) != null && oldPick.version() >= cap.version()) continue;
                pickedCapabilities.put(cap.name(), sp);
            }
        }
        block2: for (Capability cap : capabilities) {
            SubProtocolIdentifier capSp = SubProtocolIdentifier.of(cap.name(), cap.version());
            if (!Objects.equals(pickedCapabilities.get(cap.name()), capSp)) continue;
            for (SubProtocolIdentifier sp : this.subprotocols.keySet()) {
                if (!sp.equals(capSp)) continue;
                int numberOfMessageTypes = sp.versionRange();
                this.subprotocolRangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(startRange), (Comparable)Integer.valueOf(startRange + numberOfMessageTypes)), (Object)sp);
                startRange += numberOfMessageTypes;
                continue block2;
            }
        }
    }

    @Override
    public void disconnect(DisconnectReason reason) {
        if (this.disconnectRequested.compareAndSet(false, true)) {
            logger.debug("Sending disconnect message with reason {}", (Object)reason);
            this.writer.accept(new RLPxMessage(1, new DisconnectMessage(reason).toBytes()));
            this.disconnectReason = reason;
            this.disconnectHandler.run();
            this.eventListener.onEvent(WireConnection.Event.DISCONNECTED);
        }
    }

    public AsyncCompletion sendPing() {
        logger.debug("Sending ping message");
        this.writer.accept(new RLPxMessage(2, Bytes.EMPTY));
        this.awaitingPong = AsyncCompletion.incomplete();
        return this.awaitingPong;
    }

    private void sendPong() {
        logger.debug("Sending pong message");
        this.writer.accept(new RLPxMessage(3, Bytes.EMPTY));
    }

    void sendHello() {
        this.myHelloMessage = HelloMessage.create(this.nodeId, this.advertisedPort, this.p2pVersion, this.clientId, this.subprotocols.keySet().stream().map(subProtocolIdentifier -> new Capability(subProtocolIdentifier.name(), subProtocolIdentifier.version())).collect(Collectors.toList()));
        logger.debug("Sending hello message {}", (Object)this.myHelloMessage);
        this.writer.accept(new RLPxMessage(0, this.myHelloMessage.toBytes()));
    }

    @Override
    public boolean supports(SubProtocolIdentifier subProtocolIdentifier) {
        for (SubProtocolIdentifier sp : this.subprotocolRangeMap.asMapOfRanges().values()) {
            if (!sp.equals(subProtocolIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<SubProtocolIdentifier> agreedSubprotocols() {
        ArrayList<SubProtocolIdentifier> identifiers = new ArrayList<SubProtocolIdentifier>();
        for (SubProtocolIdentifier sp : this.subprotocolRangeMap.asMapOfRanges().values()) {
            identifiers.add(sp);
        }
        return identifiers;
    }

    public void sendMessage(SubProtocolIdentifier subProtocolIdentifier, int messageType, Bytes message) {
        logger.trace("Sending sub-protocol message {} {}", (Object)messageType, (Object)message);
        Integer offset = null;
        for (Map.Entry entry : this.subprotocolRangeMap.asMapOfRanges().entrySet()) {
            if (!((SubProtocolIdentifier)entry.getValue()).equals(subProtocolIdentifier)) continue;
            offset = (Integer)((Range)entry.getKey()).lowerEndpoint();
            break;
        }
        if (offset == null) {
            throw new UnsupportedOperationException();
        }
        this.writer.accept(new RLPxMessage(messageType + offset, message));
    }

    public void handleConnectionStart() {
        this.sendHello();
    }

    public String toString() {
        return this.peerNodeId.toHexString();
    }

    @Override
    public boolean isDisconnectReceived() {
        return this.disconnectReceived;
    }

    @Override
    public boolean isDisconnectRequested() {
        return this.disconnectRequested.get();
    }

    @Override
    public DisconnectReason getDisconnectReason() {
        return this.disconnectReason;
    }

    @Override
    public String peerHost() {
        return this.peerHost;
    }

    @Override
    public int peerPort() {
        return this.peerPort;
    }

    @Override
    public SECP256K1.PublicKey peerPublicKey() {
        return SECP256K1.PublicKey.fromBytes((Bytes)this.peerNodeId);
    }

    @Override
    public HelloMessage getPeerHello() {
        return this.peerHelloMessage;
    }

    @Override
    public void registerListener(WireConnection.EventListener listener) {
        this.eventListener = listener;
    }
}

