/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.ethereum;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Wei;
import org.jetbrains.annotations.NotNull;

public final class Gas
implements Comparable<Gas> {
    private static final int MAX_CONSTANT = 64;
    private static final BigInteger BI_MAX_CONSTANT = BigInteger.valueOf(64L);
    private static final UInt256 UINT256_MAX_CONSTANT = UInt256.valueOf(64L);
    private static Gas[] CONSTANTS = new Gas[65];
    public static final Gas ZERO;
    public static final Gas MAX;
    public static final Gas TOO_HIGH;
    private final long value;

    private Gas(long value) {
        this.value = value;
    }

    public static Gas valueOf(UInt256 value) {
        if (value.compareTo((Bytes)UINT256_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        if (!value.fitsLong()) {
            return TOO_HIGH;
        }
        return new Gas(value.toLong());
    }

    public static Gas valueOf(long value) {
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"Argument must be positive");
        if (value <= 64L) {
            return CONSTANTS[(int)value];
        }
        return new Gas(value);
    }

    public static Gas valueOf(BigInteger value) {
        Preconditions.checkArgument((value.signum() >= 0 ? 1 : 0) != 0, (Object)"Argument must be positive");
        if (value.compareTo(BI_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        try {
            return new Gas(value.longValueExact());
        }
        catch (ArithmeticException e) {
            return TOO_HIGH;
        }
    }

    public Wei priceFor(Wei gasPrice) {
        return Wei.valueOf(gasPrice.toUInt256().multiply(this.value).toUInt256());
    }

    public Gas add(Gas other) {
        if (this.tooHigh() || other.tooHigh()) {
            return TOO_HIGH;
        }
        try {
            return Gas.valueOf(Math.addExact(this.value, other.value));
        }
        catch (ArithmeticException e) {
            return TOO_HIGH;
        }
    }

    public Gas subtract(Gas other) {
        if (this.tooHigh() || other.tooHigh()) {
            return TOO_HIGH;
        }
        long newValue = Math.subtractExact(this.value, other.value);
        if (newValue < 0L) {
            return TOO_HIGH;
        }
        return Gas.valueOf(newValue);
    }

    public Gas multiply(Gas other) {
        if (this.tooHigh() || other.tooHigh()) {
            return TOO_HIGH;
        }
        return Gas.valueOf(Math.multiplyExact(this.value, other.value));
    }

    public Gas divide(Gas other) {
        if (this.tooHigh() || other.tooHigh()) {
            return TOO_HIGH;
        }
        return Gas.valueOf(this.value / other.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Gas)) {
            return false;
        }
        Gas gas = (Gas)o;
        return this.value == gas.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public String toString() {
        return "Gas{value=" + this.value + "}";
    }

    public long toLong() {
        return this.value;
    }

    public Bytes toBytes() {
        MutableBytes bytes = MutableBytes.create((int)8);
        bytes.setLong(0, this.value);
        return bytes;
    }

    public Bytes toMinimalBytes() {
        return Bytes.minimalBytes((long)this.value);
    }

    @Override
    public int compareTo(long other) {
        return Long.compare(this.value, other);
    }

    @Override
    public int compareTo(@NotNull Gas o) {
        return this.compareTo(o.value);
    }

    public boolean tooHigh() {
        return this.value == -1L;
    }

    static {
        Gas.CONSTANTS[0] = new Gas(0L);
        for (int i = 1; i <= 64; ++i) {
            Gas.CONSTANTS[i] = new Gas(i);
        }
        ZERO = Gas.valueOf(0L);
        MAX = Gas.valueOf(Long.MAX_VALUE);
        TOO_HIGH = new Gas(-1L);
    }
}

