/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.ethclient.EthereumConnection;
import org.apache.tuweni.ethclient.EthereumPeerRepository;
import org.apache.tuweni.ethclient.MemoryEthereumConnection;
import org.apache.tuweni.ethclient.MemoryEthereumIdentity;
import org.apache.tuweni.ethclient.MemoryEthereumPeer;
import org.apache.tuweni.peer.repository.Identity;
import org.apache.tuweni.peer.repository.Peer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u001c\u0010 \u001a\u00020\u00052\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001c\u0010\"\u001a\u00020\u00052\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010$\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0005H\u0016J \u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J$\u00103\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000105H\u0016J\u0018\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020:H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRE\u0010\u000f\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00110\u0010j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bRE\u0010\u0019\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015\u00a8\u0006;"}, d2={"Lorg/apache/tuweni/ethclient/MemoryEthereumPeerRepository;", "Lorg/apache/tuweni/ethclient/EthereumPeerRepository;", "()V", "connections", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/apache/tuweni/ethclient/EthereumConnection;", "getConnections", "()Ljava/util/concurrent/ConcurrentHashMap;", "identities", "Ljava/util/HashSet;", "Lorg/apache/tuweni/peer/repository/Identity;", "Lkotlin/collections/HashSet;", "getIdentities", "()Ljava/util/HashSet;", "identityListeners", "Ljava/util/HashMap;", "Lkotlin/Function1;", "", "Lkotlin/collections/HashMap;", "getIdentityListeners", "()Ljava/util/HashMap;", "peerMap", "Lorg/apache/tuweni/peer/repository/Peer;", "getPeerMap", "statusListeners", "getStatusListeners", "activeConnections", "Ljava/util/stream/Stream;", "addConnection", "peer", "identity", "addIdentityListener", "identityListener", "addStatusListener", "statusListener", "createConnectionKey", "markConnectionInactive", "peerDiscoveredAt", "time", "", "randomPeer", "removeIdentityListener", "id", "removeStatusListener", "storeIdentity", "networkInterface", "port", "", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "storePeer", "lastContacted", "Ljava/time/Instant;", "lastDiscovered", "storeStatus", "connId", "status", "Lorg/apache/tuweni/devp2p/eth/Status;", "eth-client"})
public final class MemoryEthereumPeerRepository
implements EthereumPeerRepository {
    @NotNull
    private final ConcurrentHashMap<Identity, Peer> peerMap = new ConcurrentHashMap();
    @NotNull
    private final HashSet<Identity> identities = new HashSet();
    @NotNull
    private final ConcurrentHashMap<String, EthereumConnection> connections = new ConcurrentHashMap();
    @NotNull
    private final HashMap<String, Function1<EthereumConnection, Unit>> statusListeners = new HashMap();
    @NotNull
    private final HashMap<String, Function1<Identity, Unit>> identityListeners = new HashMap();

    @NotNull
    public final ConcurrentHashMap<Identity, Peer> getPeerMap() {
        return this.peerMap;
    }

    @NotNull
    public final HashSet<Identity> getIdentities() {
        return this.identities;
    }

    @NotNull
    public final ConcurrentHashMap<String, EthereumConnection> getConnections() {
        return this.connections;
    }

    @NotNull
    public final HashMap<String, Function1<EthereumConnection, Unit>> getStatusListeners() {
        return this.statusListeners;
    }

    @NotNull
    public final HashMap<String, Function1<Identity, Unit>> getIdentityListeners() {
        return this.identityListeners;
    }

    @Override
    public void storeStatus(@NotNull String connId, @NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)connId, (String)"connId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        EthereumConnection ethereumConnection = this.connections.get(connId);
        if (ethereumConnection != null) {
            EthereumConnection conn = ethereumConnection;
            boolean bl = false;
            ((MemoryEthereumConnection)conn).setStatus(status);
            Collection<Function1<EthereumConnection, Unit>> collection = this.getStatusListeners().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"statusListeners.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke((Object)conn);
            }
        }
    }

    @Override
    @NotNull
    public String addStatusListener(@NotNull Function1<? super EthereumConnection, Unit> statusListener) {
        Intrinsics.checkNotNullParameter(statusListener, (String)"statusListener");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String id = string;
        this.statusListeners.put(id, statusListener);
        return id;
    }

    @Override
    public void removeStatusListener(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.statusListeners.remove(id);
    }

    @Override
    @NotNull
    public String addIdentityListener(@NotNull Function1<? super Identity, Unit> identityListener) {
        Intrinsics.checkNotNullParameter(identityListener, (String)"identityListener");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String id = string;
        this.identityListeners.put(id, identityListener);
        return id;
    }

    @Override
    public void removeIdentityListener(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.identityListeners.remove(id);
    }

    @Override
    @NotNull
    public Stream<EthereumConnection> activeConnections() {
        Stream<EthereumConnection> stream = this.connections.values().stream().filter(MemoryEthereumPeerRepository::activeConnections$lambda-2);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"connections.values.stream().filter { it.active() }");
        return stream;
    }

    @NotNull
    public Peer storePeer(@NotNull Identity id, @Nullable Instant lastContacted, @Nullable Instant lastDiscovered) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MemoryEthereumPeer peer = new MemoryEthereumPeer(id, lastContacted, lastDiscovered);
        Map map = this.peerMap;
        Identity identity = peer.id();
        map.put(identity, peer);
        return peer;
    }

    @Nullable
    public Peer randomPeer() {
        Collection<Peer> collection = this.peerMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"peerMap.values");
        return (Peer)CollectionsKt.firstOrNull((Iterable)collection);
    }

    @NotNull
    public Identity storeIdentity(@NotNull String networkInterface, int port, @NotNull SECP256K1.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        MemoryEthereumIdentity identity = new MemoryEthereumIdentity(networkInterface, port, publicKey);
        if (this.identities.add(identity)) {
            Collection<Function1<Identity, Unit>> collection = this.identityListeners.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"identityListeners.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)identity);
            }
        }
        return identity;
    }

    public void addConnection(@NotNull Peer peer, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Instant now = Instant.now();
        MemoryEthereumConnection conn = new MemoryEthereumConnection(true, peer, identity, null, 8, null);
        Map map = this.connections;
        String string = this.createConnectionKey(peer, identity);
        map.put(string, conn);
        ((MemoryEthereumPeer)peer).getConnections().add(conn);
        ((MemoryEthereumPeer)peer).setLastContacted$eth_client(now);
        ((MemoryEthereumIdentity)identity).getConnections$eth_client().add(conn);
    }

    public void markConnectionInactive(@NotNull Peer peer, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        EthereumConnection ethereumConnection = this.connections.get(this.createConnectionKey(peer, identity));
        if (ethereumConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.ethclient.MemoryEthereumConnection");
        }
        ((MemoryEthereumConnection)ethereumConnection).setActive(false);
    }

    public void peerDiscoveredAt(@NotNull Peer peer, long time) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Instant timestamp = Instant.ofEpochMilli(time);
        Instant lastDiscovered = peer.lastDiscovered();
        if (lastDiscovered == null || lastDiscovered.isBefore(timestamp)) {
            ((MemoryEthereumPeer)peer).setLastDiscovered$eth_client(timestamp);
        }
    }

    private final String createConnectionKey(Peer peer, Identity identity) {
        return peer.id() + "-" + identity.publicKey().toHexString();
    }

    private static final boolean activeConnections$lambda-2(EthereumConnection it) {
        return it.active();
    }
}

